# SageOne\BusinessesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getBusinesses()**](BusinessesApi.md#getBusinesses) | **GET** /businesses | Returns all Businesses
[**getBusinessesKey()**](BusinessesApi.md#getBusinessesKey) | **GET** /businesses/{key} | Returns a Business


## `getBusinesses()`

```php
getBusinesses(): \SageOne\Model\PagingBusiness
```

Returns all Businesses

Returns all Businesses

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BusinessesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getBusinesses();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BusinessesApi->getBusinesses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\SageOne\Model\PagingBusiness**](../Model/PagingBusiness.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBusinessesKey()`

```php
getBusinessesKey($key): \SageOne\Model\Business
```

Returns a Business

Returns a Business

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BusinessesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bussiness Key.

try {
    $result = $apiInstance->getBusinessesKey($key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BusinessesApi->getBusinessesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bussiness Key. |

### Return type

[**\SageOne\Model\Business**](../Model/Business.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
