# SageOne\BusinessTypesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getBusinessTypes()**](BusinessTypesApi.md#getBusinessTypes) | **GET** /business_types | Returns all Business Types
[**getBusinessTypesKey()**](BusinessTypesApi.md#getBusinessTypesKey) | **GET** /business_types/{key} | Returns a Business Type


## `getBusinessTypes()`

```php
getBusinessTypes($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\BusinessType[]
```

Returns all Business Types

Returns all Business Types

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BusinessTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the For Business Types.
$items_per_page = 20; // int | Returns the given number of For Business Types per request.
$page = 1; // int | Go to specific page of For Business Types
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the For Business Types (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBusinessTypes($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BusinessTypesApi->getBusinessTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the For Business Types. | [optional]
 **items_per_page** | **int**| Returns the given number of For Business Types per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of For Business Types | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the For Business Types (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\BusinessType[]**](../Model/BusinessType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBusinessTypesKey()`

```php
getBusinessTypesKey($key, $show_legacy_id, $attributes): \SageOne\Model\BusinessType
```

Returns a Business Type

Returns a Business Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BusinessTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Business Type Key.
$show_legacy_id = True; // bool | Display the legacy_id for the For Business Type.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the For Business Type (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBusinessTypesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BusinessTypesApi->getBusinessTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Business Type Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the For Business Type. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the For Business Type (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\BusinessType**](../Model/BusinessType.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
