# SageOne\BusinessSettingsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getBusinessSettings()**](BusinessSettingsApi.md#getBusinessSettings) | **GET** /business_settings | Returns all Business Settings
[**putBusinessSettings()**](BusinessSettingsApi.md#putBusinessSettings) | **PUT** /business_settings | Updates a Business Settings


## `getBusinessSettings()`

```php
getBusinessSettings($show_legacy_id): \SageOne\Model\BusinessSettings
```

Returns all Business Settings

Returns all Business Settings

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BusinessSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Business Settings.

try {
    $result = $apiInstance->getBusinessSettings($show_legacy_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BusinessSettingsApi->getBusinessSettings: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Business Settings. | [optional]

### Return type

[**\SageOne\Model\BusinessSettings**](../Model/BusinessSettings.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putBusinessSettings()`

```php
putBusinessSettings($business_settings): \SageOne\Model\BusinessSettings
```

Updates a Business Settings

Updates a Business Settings

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BusinessSettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$business_settings = new \SageOne\Model\PutBusinessSettings(); // \SageOne\Model\PutBusinessSettings

try {
    $result = $apiInstance->putBusinessSettings($business_settings);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BusinessSettingsApi->putBusinessSettings: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **business_settings** | [**\SageOne\Model\PutBusinessSettings**](../Model/PutBusinessSettings.md)|  |

### Return type

[**\SageOne\Model\BusinessSettings**](../Model/BusinessSettings.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
