# SageOne\BusinessExchangeRatesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteBusinessExchangeRatesKey()**](BusinessExchangeRatesApi.md#deleteBusinessExchangeRatesKey) | **DELETE** /business_exchange_rates/{key} | Deletes a Business Exchange Rate
[**getBusinessExchangeRates()**](BusinessExchangeRatesApi.md#getBusinessExchangeRates) | **GET** /business_exchange_rates | Returns all Business Exchange Rates
[**getBusinessExchangeRatesKey()**](BusinessExchangeRatesApi.md#getBusinessExchangeRatesKey) | **GET** /business_exchange_rates/{key} | Returns a Business Exchange Rate
[**postBusinessExchangeRates()**](BusinessExchangeRatesApi.md#postBusinessExchangeRates) | **POST** /business_exchange_rates | Creates a Business Exchange Rate
[**putBusinessExchangeRatesKey()**](BusinessExchangeRatesApi.md#putBusinessExchangeRatesKey) | **PUT** /business_exchange_rates/{key} | Updates a Business Exchange Rate


## `deleteBusinessExchangeRatesKey()`

```php
deleteBusinessExchangeRatesKey($key)
```

Deletes a Business Exchange Rate

Deletes a Business Exchange Rate

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BusinessExchangeRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Business Exchange Rate Key.

try {
    $apiInstance->deleteBusinessExchangeRatesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling BusinessExchangeRatesApi->deleteBusinessExchangeRatesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Business Exchange Rate Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBusinessExchangeRates()`

```php
getBusinessExchangeRates($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\BusinessExchangeRate[]
```

Returns all Business Exchange Rates

Returns all Business Exchange Rates

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BusinessExchangeRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Business Exchange Rates.
$items_per_page = 20; // int | Returns the given number of Business Exchange Rates per request.
$page = 1; // int | Go to specific page of Business Exchange Rates
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Business Exchange Rates (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBusinessExchangeRates($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BusinessExchangeRatesApi->getBusinessExchangeRates: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Business Exchange Rates. | [optional]
 **items_per_page** | **int**| Returns the given number of Business Exchange Rates per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Business Exchange Rates | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Business Exchange Rates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\BusinessExchangeRate[]**](../Model/BusinessExchangeRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBusinessExchangeRatesKey()`

```php
getBusinessExchangeRatesKey($key, $show_legacy_id, $attributes): \SageOne\Model\BusinessExchangeRate
```

Returns a Business Exchange Rate

Returns a Business Exchange Rate

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BusinessExchangeRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Business Exchange Rate Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Business Exchange Rate.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Business Exchange Rate (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBusinessExchangeRatesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BusinessExchangeRatesApi->getBusinessExchangeRatesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Business Exchange Rate Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Business Exchange Rate. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Business Exchange Rate (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\BusinessExchangeRate**](../Model/BusinessExchangeRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postBusinessExchangeRates()`

```php
postBusinessExchangeRates($business_exchange_rates): \SageOne\Model\BusinessExchangeRate
```

Creates a Business Exchange Rate

Creates a Business Exchange Rate

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BusinessExchangeRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$business_exchange_rates = new \SageOne\Model\PostBusinessExchangeRates(); // \SageOne\Model\PostBusinessExchangeRates

try {
    $result = $apiInstance->postBusinessExchangeRates($business_exchange_rates);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BusinessExchangeRatesApi->postBusinessExchangeRates: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **business_exchange_rates** | [**\SageOne\Model\PostBusinessExchangeRates**](../Model/PostBusinessExchangeRates.md)|  |

### Return type

[**\SageOne\Model\BusinessExchangeRate**](../Model/BusinessExchangeRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putBusinessExchangeRatesKey()`

```php
putBusinessExchangeRatesKey($key, $business_exchange_rates): \SageOne\Model\BusinessExchangeRate
```

Updates a Business Exchange Rate

Updates a Business Exchange Rate

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BusinessExchangeRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Business Exchange Rate Key.
$business_exchange_rates = new \SageOne\Model\PutBusinessExchangeRates(); // \SageOne\Model\PutBusinessExchangeRates

try {
    $result = $apiInstance->putBusinessExchangeRatesKey($key, $business_exchange_rates);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BusinessExchangeRatesApi->putBusinessExchangeRatesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Business Exchange Rate Key. |
 **business_exchange_rates** | [**\SageOne\Model\PutBusinessExchangeRates**](../Model/PutBusinessExchangeRates.md)|  |

### Return type

[**\SageOne\Model\BusinessExchangeRate**](../Model/BusinessExchangeRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
