# SageOne\BankTransfersApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteBankTransfersKey()**](BankTransfersApi.md#deleteBankTransfersKey) | **DELETE** /bank_transfers/{key} | Deletes a Bank Transfer
[**getBankTransfers()**](BankTransfersApi.md#getBankTransfers) | **GET** /bank_transfers | Returns all Bank Transfers
[**getBankTransfersKey()**](BankTransfersApi.md#getBankTransfersKey) | **GET** /bank_transfers/{key} | Returns a Bank Transfer
[**postBankTransfers()**](BankTransfersApi.md#postBankTransfers) | **POST** /bank_transfers | Creates a Bank Transfer
[**putBankTransfersKey()**](BankTransfersApi.md#putBankTransfersKey) | **PUT** /bank_transfers/{key} | Updates a Bank Transfer


## `deleteBankTransfersKey()`

```php
deleteBankTransfersKey($key)
```

Deletes a Bank Transfer

Deletes a Bank Transfer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankTransfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bank Transfer Key.

try {
    $apiInstance->deleteBankTransfersKey($key);
} catch (Exception $e) {
    echo 'Exception when calling BankTransfersApi->deleteBankTransfersKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bank Transfer Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBankTransfers()`

```php
getBankTransfers($updated_or_created_since, $deleted_since, $from_date, $to_date, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\BankTransfer[]
```

Returns all Bank Transfers

Returns all Bank Transfers

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankTransfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Bank Transfers changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Bank Transfers deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Bank Transfers dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Bank Transfers dates
$show_legacy_id = True; // bool | Display the legacy_id for the Bank Transfers.
$items_per_page = 20; // int | Returns the given number of Bank Transfers per request.
$page = 1; // int | Go to specific page of Bank Transfers
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Bank Transfers (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBankTransfers($updated_or_created_since, $deleted_since, $from_date, $to_date, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankTransfersApi->getBankTransfers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Bank Transfers changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Bank Transfers deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **from_date** | **\DateTime**| Use this to filter by Bank Transfers dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Bank Transfers dates | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Bank Transfers. | [optional]
 **items_per_page** | **int**| Returns the given number of Bank Transfers per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Bank Transfers | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Bank Transfers (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\BankTransfer[]**](../Model/BankTransfer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBankTransfersKey()`

```php
getBankTransfersKey($key, $nested_attributes, $show_legacy_id, $attributes): \SageOne\Model\BankTransfer
```

Returns a Bank Transfer

Returns a Bank Transfer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankTransfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bank Transfer Key.
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Bank Transfer (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_legacy_id = True; // bool | Display the legacy_id for the Bank Transfer.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Bank Transfer (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBankTransfersKey($key, $nested_attributes, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankTransfersApi->getBankTransfersKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bank Transfer Key. |
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Bank Transfer (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Bank Transfer. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Bank Transfer (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\BankTransfer**](../Model/BankTransfer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postBankTransfers()`

```php
postBankTransfers($bank_transfers): \SageOne\Model\BankTransfer
```

Creates a Bank Transfer

Creates a Bank Transfer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankTransfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$bank_transfers = new \SageOne\Model\PostBankTransfers(); // \SageOne\Model\PostBankTransfers

try {
    $result = $apiInstance->postBankTransfers($bank_transfers);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankTransfersApi->postBankTransfers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **bank_transfers** | [**\SageOne\Model\PostBankTransfers**](../Model/PostBankTransfers.md)|  |

### Return type

[**\SageOne\Model\BankTransfer**](../Model/BankTransfer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putBankTransfersKey()`

```php
putBankTransfersKey($key, $bank_transfers): \SageOne\Model\BankTransfer
```

Updates a Bank Transfer

Updates a Bank Transfer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankTransfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bank Transfer Key.
$bank_transfers = new \SageOne\Model\PutBankTransfers(); // \SageOne\Model\PutBankTransfers

try {
    $result = $apiInstance->putBankTransfersKey($key, $bank_transfers);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankTransfersApi->putBankTransfersKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bank Transfer Key. |
 **bank_transfers** | [**\SageOne\Model\PutBankTransfers**](../Model/PutBankTransfers.md)|  |

### Return type

[**\SageOne\Model\BankTransfer**](../Model/BankTransfer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
