# SageOne\BankReconciliationsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getBankReconciliations()**](BankReconciliationsApi.md#getBankReconciliations) | **GET** /bank_reconciliations | Returns all Bank Reconciliations
[**getBankReconciliationsKey()**](BankReconciliationsApi.md#getBankReconciliationsKey) | **GET** /bank_reconciliations/{key} | Returns a Bank Reconciliation
[**postBankReconciliations()**](BankReconciliationsApi.md#postBankReconciliations) | **POST** /bank_reconciliations | Creates a Bank Reconciliation
[**putBankReconciliationsKey()**](BankReconciliationsApi.md#putBankReconciliationsKey) | **PUT** /bank_reconciliations/{key} | Updates a Bank Reconciliation


## `getBankReconciliations()`

```php
getBankReconciliations($updated_or_created_since, $bank_account_id, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\BankReconciliation[]
```

Returns all Bank Reconciliations

Returns all Bank Reconciliations

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankReconciliationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Bank Reconciliations changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$bank_account_id = 'bank_account_id_example'; // string | Use this to filter by bank account id
$show_legacy_id = True; // bool | Display the legacy_id for the Bank Reconciliations.
$items_per_page = 20; // int | Returns the given number of Bank Reconciliations per request.
$page = 1; // int | Go to specific page of Bank Reconciliations
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Bank Reconciliations (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBankReconciliations($updated_or_created_since, $bank_account_id, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankReconciliationsApi->getBankReconciliations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Bank Reconciliations changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **bank_account_id** | **string**| Use this to filter by bank account id | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Bank Reconciliations. | [optional]
 **items_per_page** | **int**| Returns the given number of Bank Reconciliations per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Bank Reconciliations | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Bank Reconciliations (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\BankReconciliation[]**](../Model/BankReconciliation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBankReconciliationsKey()`

```php
getBankReconciliationsKey($key, $show_legacy_id, $attributes): \SageOne\Model\BankReconciliation
```

Returns a Bank Reconciliation

Returns a Bank Reconciliation

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankReconciliationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bank Reconciliation Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Bank Reconciliation.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Bank Reconciliation (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBankReconciliationsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankReconciliationsApi->getBankReconciliationsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bank Reconciliation Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Bank Reconciliation. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Bank Reconciliation (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\BankReconciliation**](../Model/BankReconciliation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postBankReconciliations()`

```php
postBankReconciliations($bank_reconciliations): \SageOne\Model\BankReconciliation
```

Creates a Bank Reconciliation

Creates a Bank Reconciliation

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankReconciliationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$bank_reconciliations = new \SageOne\Model\PostBankReconciliations(); // \SageOne\Model\PostBankReconciliations

try {
    $result = $apiInstance->postBankReconciliations($bank_reconciliations);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankReconciliationsApi->postBankReconciliations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **bank_reconciliations** | [**\SageOne\Model\PostBankReconciliations**](../Model/PostBankReconciliations.md)|  |

### Return type

[**\SageOne\Model\BankReconciliation**](../Model/BankReconciliation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putBankReconciliationsKey()`

```php
putBankReconciliationsKey($key, $bank_reconciliations): \SageOne\Model\BankReconciliation
```

Updates a Bank Reconciliation

Updates a Bank Reconciliation

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankReconciliationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bank Reconciliation Key.
$bank_reconciliations = new \SageOne\Model\PutBankReconciliations(); // \SageOne\Model\PutBankReconciliations

try {
    $result = $apiInstance->putBankReconciliationsKey($key, $bank_reconciliations);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankReconciliationsApi->putBankReconciliationsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bank Reconciliation Key. |
 **bank_reconciliations** | [**\SageOne\Model\PutBankReconciliations**](../Model/PutBankReconciliations.md)|  |

### Return type

[**\SageOne\Model\BankReconciliation**](../Model/BankReconciliation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
