# SageOne\BankOpeningBalancesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteBankOpeningBalancesKey()**](BankOpeningBalancesApi.md#deleteBankOpeningBalancesKey) | **DELETE** /bank_opening_balances/{key} | Deletes a Bank Opening Balance
[**getBankOpeningBalances()**](BankOpeningBalancesApi.md#getBankOpeningBalances) | **GET** /bank_opening_balances | Returns all Bank Opening Balances
[**getBankOpeningBalancesKey()**](BankOpeningBalancesApi.md#getBankOpeningBalancesKey) | **GET** /bank_opening_balances/{key} | Returns a Bank Opening Balance
[**postBankOpeningBalances()**](BankOpeningBalancesApi.md#postBankOpeningBalances) | **POST** /bank_opening_balances | Creates a Bank Opening Balance
[**putBankOpeningBalancesKey()**](BankOpeningBalancesApi.md#putBankOpeningBalancesKey) | **PUT** /bank_opening_balances/{key} | Updates a Bank Opening Balance


## `deleteBankOpeningBalancesKey()`

```php
deleteBankOpeningBalancesKey($key)
```

Deletes a Bank Opening Balance

Deletes a Bank Opening Balance

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bank Opening Balance Key.

try {
    $apiInstance->deleteBankOpeningBalancesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling BankOpeningBalancesApi->deleteBankOpeningBalancesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bank Opening Balance Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBankOpeningBalances()`

```php
getBankOpeningBalances($updated_or_created_since, $bank_account_id, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\BankOpeningBalance[]
```

Returns all Bank Opening Balances

Returns all Bank Opening Balances

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Bank Opening Balances changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$bank_account_id = 'bank_account_id_example'; // string | Use this to filter by bank account id
$show_legacy_id = True; // bool | Display the legacy_id for the Bank Opening Balances.
$items_per_page = 20; // int | Returns the given number of Bank Opening Balances per request.
$page = 1; // int | Go to specific page of Bank Opening Balances
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Bank Opening Balances (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBankOpeningBalances($updated_or_created_since, $bank_account_id, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankOpeningBalancesApi->getBankOpeningBalances: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Bank Opening Balances changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **bank_account_id** | **string**| Use this to filter by bank account id | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Bank Opening Balances. | [optional]
 **items_per_page** | **int**| Returns the given number of Bank Opening Balances per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Bank Opening Balances | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Bank Opening Balances (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\BankOpeningBalance[]**](../Model/BankOpeningBalance.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBankOpeningBalancesKey()`

```php
getBankOpeningBalancesKey($key, $show_legacy_id, $attributes): \SageOne\Model\BankOpeningBalance
```

Returns a Bank Opening Balance

Returns a Bank Opening Balance

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bank Opening Balance Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Bank Opening Balance.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Bank Opening Balance (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBankOpeningBalancesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankOpeningBalancesApi->getBankOpeningBalancesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bank Opening Balance Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Bank Opening Balance. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Bank Opening Balance (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\BankOpeningBalance**](../Model/BankOpeningBalance.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postBankOpeningBalances()`

```php
postBankOpeningBalances($bank_opening_balances): \SageOne\Model\BankOpeningBalance
```

Creates a Bank Opening Balance

Creates a Bank Opening Balance

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$bank_opening_balances = new \SageOne\Model\PostBankOpeningBalances(); // \SageOne\Model\PostBankOpeningBalances

try {
    $result = $apiInstance->postBankOpeningBalances($bank_opening_balances);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankOpeningBalancesApi->postBankOpeningBalances: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **bank_opening_balances** | [**\SageOne\Model\PostBankOpeningBalances**](../Model/PostBankOpeningBalances.md)|  |

### Return type

[**\SageOne\Model\BankOpeningBalance**](../Model/BankOpeningBalance.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putBankOpeningBalancesKey()`

```php
putBankOpeningBalancesKey($key, $bank_opening_balances): \SageOne\Model\BankOpeningBalance
```

Updates a Bank Opening Balance

Updates a Bank Opening Balance

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankOpeningBalancesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bank Opening Balance Key.
$bank_opening_balances = new \SageOne\Model\PutBankOpeningBalances(); // \SageOne\Model\PutBankOpeningBalances

try {
    $result = $apiInstance->putBankOpeningBalancesKey($key, $bank_opening_balances);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankOpeningBalancesApi->putBankOpeningBalancesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bank Opening Balance Key. |
 **bank_opening_balances** | [**\SageOne\Model\PutBankOpeningBalances**](../Model/PutBankOpeningBalances.md)|  |

### Return type

[**\SageOne\Model\BankOpeningBalance**](../Model/BankOpeningBalance.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
