# SageOne\BankDepositsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteBankDepositsKey()**](BankDepositsApi.md#deleteBankDepositsKey) | **DELETE** /bank_deposits/{key} | Deletes a Bank Deposit
[**getBankDeposits()**](BankDepositsApi.md#getBankDeposits) | **GET** /bank_deposits | Returns all Bank Deposits
[**getBankDepositsKey()**](BankDepositsApi.md#getBankDepositsKey) | **GET** /bank_deposits/{key} | Returns a Bank Deposit
[**postBankDeposits()**](BankDepositsApi.md#postBankDeposits) | **POST** /bank_deposits | Creates a Bank Deposit


## `deleteBankDepositsKey()`

```php
deleteBankDepositsKey($key)
```

Deletes a Bank Deposit

Deletes a Bank Deposit

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankDepositsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bank Deposit Key.

try {
    $apiInstance->deleteBankDepositsKey($key);
} catch (Exception $e) {
    echo 'Exception when calling BankDepositsApi->deleteBankDepositsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bank Deposit Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBankDeposits()`

```php
getBankDeposits($updated_or_created_since, $deleted_since, $from_date, $to_date, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\BankDeposit[]
```

Returns all Bank Deposits

Returns all Bank Deposits

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankDepositsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Deposits changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Deposits deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Deposits dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Deposits dates
$show_legacy_id = True; // bool | Display the legacy_id for the Deposits.
$items_per_page = 20; // int | Returns the given number of Deposits per request.
$page = 1; // int | Go to specific page of Deposits
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Deposits (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBankDeposits($updated_or_created_since, $deleted_since, $from_date, $to_date, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankDepositsApi->getBankDeposits: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Deposits changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Deposits deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **from_date** | **\DateTime**| Use this to filter by Deposits dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Deposits dates | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Deposits. | [optional]
 **items_per_page** | **int**| Returns the given number of Deposits per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Deposits | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Deposits (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\BankDeposit[]**](../Model/BankDeposit.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBankDepositsKey()`

```php
getBankDepositsKey($key, $nested_attributes, $show_legacy_id, $attributes): \SageOne\Model\BankDeposit
```

Returns a Bank Deposit

Returns a Bank Deposit

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankDepositsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bank Deposit Key.
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Deposit (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_legacy_id = True; // bool | Display the legacy_id for the Deposit.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Deposit (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBankDepositsKey($key, $nested_attributes, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankDepositsApi->getBankDepositsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bank Deposit Key. |
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Deposit (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Deposit. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Deposit (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\BankDeposit**](../Model/BankDeposit.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postBankDeposits()`

```php
postBankDeposits($bank_deposits): \SageOne\Model\BankDeposit
```

Creates a Bank Deposit

Creates a Bank Deposit

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankDepositsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$bank_deposits = new \SageOne\Model\PostBankDeposits(); // \SageOne\Model\PostBankDeposits

try {
    $result = $apiInstance->postBankDeposits($bank_deposits);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankDepositsApi->postBankDeposits: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **bank_deposits** | [**\SageOne\Model\PostBankDeposits**](../Model/PostBankDeposits.md)|  |

### Return type

[**\SageOne\Model\BankDeposit**](../Model/BankDeposit.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
