# SageOne\BankAccountsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteBankAccountsKey()**](BankAccountsApi.md#deleteBankAccountsKey) | **DELETE** /bank_accounts/{key} | Deletes a Bank Account
[**getBankAccounts()**](BankAccountsApi.md#getBankAccounts) | **GET** /bank_accounts | Returns all Bank Accounts
[**getBankAccountsKey()**](BankAccountsApi.md#getBankAccountsKey) | **GET** /bank_accounts/{key} | Returns a Bank Account
[**postBankAccounts()**](BankAccountsApi.md#postBankAccounts) | **POST** /bank_accounts | Creates a Bank Account
[**putBankAccountsKey()**](BankAccountsApi.md#putBankAccountsKey) | **PUT** /bank_accounts/{key} | Updates a Bank Account


## `deleteBankAccountsKey()`

```php
deleteBankAccountsKey($key)
```

Deletes a Bank Account

Deletes a Bank Account

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankAccountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bank Account Key.

try {
    $apiInstance->deleteBankAccountsKey($key);
} catch (Exception $e) {
    echo 'Exception when calling BankAccountsApi->deleteBankAccountsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bank Account Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBankAccounts()`

```php
getBankAccounts($updated_or_created_since, $deleted_since, $nested_attributes, $exclude_stripe, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\PagingBankAccount
```

Returns all Bank Accounts

Returns all Bank Accounts

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankAccountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Bank Accounts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Bank Accounts deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Bank Accounts (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$exclude_stripe = True; // bool | Use this to filter out Stripe Bank Accounts
$show_legacy_id = True; // bool | Display the legacy_id for the Bank Accounts.
$items_per_page = 20; // int | Returns the given number of Bank Accounts per request.
$page = 1; // int | Go to specific page of Bank Accounts
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Bank Accounts (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBankAccounts($updated_or_created_since, $deleted_since, $nested_attributes, $exclude_stripe, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankAccountsApi->getBankAccounts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Bank Accounts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Bank Accounts deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Bank Accounts (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **exclude_stripe** | **bool**| Use this to filter out Stripe Bank Accounts | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Bank Accounts. | [optional]
 **items_per_page** | **int**| Returns the given number of Bank Accounts per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Bank Accounts | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Bank Accounts (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\PagingBankAccount**](../Model/PagingBankAccount.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBankAccountsKey()`

```php
getBankAccountsKey($key, $nested_attributes, $show_legacy_id, $attributes): \SageOne\Model\BankAccount
```

Returns a Bank Account

Returns a Bank Account

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankAccountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bank Account Key.
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Bank Account (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_legacy_id = True; // bool | Display the legacy_id for the Bank Account.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Bank Account (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBankAccountsKey($key, $nested_attributes, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankAccountsApi->getBankAccountsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bank Account Key. |
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Bank Account (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Bank Account. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Bank Account (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\BankAccount**](../Model/BankAccount.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postBankAccounts()`

```php
postBankAccounts($bank_accounts): \SageOne\Model\BankAccount
```

Creates a Bank Account

Creates a Bank Account

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankAccountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$bank_accounts = new \SageOne\Model\PostBankAccounts(); // \SageOne\Model\PostBankAccounts

try {
    $result = $apiInstance->postBankAccounts($bank_accounts);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankAccountsApi->postBankAccounts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **bank_accounts** | [**\SageOne\Model\PostBankAccounts**](../Model/PostBankAccounts.md)|  |

### Return type

[**\SageOne\Model\BankAccount**](../Model/BankAccount.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putBankAccountsKey()`

```php
putBankAccountsKey($key, $bank_accounts): \SageOne\Model\BankAccount
```

Updates a Bank Account

Updates a Bank Account

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankAccountsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bank Account Key.
$bank_accounts = new \SageOne\Model\PutBankAccounts(); // \SageOne\Model\PutBankAccounts

try {
    $result = $apiInstance->putBankAccountsKey($key, $bank_accounts);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankAccountsApi->putBankAccountsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bank Account Key. |
 **bank_accounts** | [**\SageOne\Model\PutBankAccounts**](../Model/PutBankAccounts.md)|  |

### Return type

[**\SageOne\Model\BankAccount**](../Model/BankAccount.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
