# SageOne\BankAccountTypesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getBankAccountTypes()**](BankAccountTypesApi.md#getBankAccountTypes) | **GET** /bank_account_types | Returns all Bank Account Types
[**getBankAccountTypesKey()**](BankAccountTypesApi.md#getBankAccountTypesKey) | **GET** /bank_account_types/{key} | Returns a Bank Account Type


## `getBankAccountTypes()`

```php
getBankAccountTypes($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\Base[]
```

Returns all Bank Account Types

Returns all Bank Account Types

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankAccountTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Account Types.
$items_per_page = 20; // int | Returns the given number of Account Types per request.
$page = 1; // int | Go to specific page of Account Types
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Account Types (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBankAccountTypes($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankAccountTypesApi->getBankAccountTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Account Types. | [optional]
 **items_per_page** | **int**| Returns the given number of Account Types per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Account Types | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Account Types (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base[]**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBankAccountTypesKey()`

```php
getBankAccountTypesKey($key, $show_legacy_id, $attributes): \SageOne\Model\Base
```

Returns a Bank Account Type

Returns a Bank Account Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\BankAccountTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Bank Account Type Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Account Type.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Account Type (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getBankAccountTypesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BankAccountTypesApi->getBankAccountTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Bank Account Type Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Account Type. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Account Type (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
