# SageOne\AttachmentsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAttachmentsKey()**](AttachmentsApi.md#deleteAttachmentsKey) | **DELETE** /attachments/{key} | Deletes a Attachment
[**getAttachments()**](AttachmentsApi.md#getAttachments) | **GET** /attachments | Returns all Attachments
[**getAttachmentsKey()**](AttachmentsApi.md#getAttachmentsKey) | **GET** /attachments/{key} | Returns a Attachment
[**getAttachmentsKeyFile()**](AttachmentsApi.md#getAttachmentsKeyFile) | **GET** /attachments/{key}/file | Returns an Attachment File
[**postAttachments()**](AttachmentsApi.md#postAttachments) | **POST** /attachments | Creates a Attachment
[**putAttachmentsKey()**](AttachmentsApi.md#putAttachmentsKey) | **PUT** /attachments/{key} | Updates a Attachment


## `deleteAttachmentsKey()`

```php
deleteAttachmentsKey($key)
```

Deletes a Attachment

Deletes a Attachment

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AttachmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Attachment Key.

try {
    $apiInstance->deleteAttachmentsKey($key);
} catch (Exception $e) {
    echo 'Exception when calling AttachmentsApi->deleteAttachmentsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Attachment Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAttachments()`

```php
getAttachments($attachment_context_id, $attachment_context_type_id, $legacy_attachment_context_type, $legacy_attachment_context_id, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\Attachment[]
```

Returns all Attachments

Returns all Attachments

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AttachmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$attachment_context_id = 'attachment_context_id_example'; // string | Use this to filter Attachments by attachment_context_id. Requires filtering by attachment_context_type_id as well
$attachment_context_type_id = 'attachment_context_type_id_example'; // string | Use this to filter Attachments by attachment_context_type_id. Requires filtering by attachment_context_id as well
$legacy_attachment_context_type = 'legacy_attachment_context_type_example'; // string
$legacy_attachment_context_id = 56; // int
$show_legacy_id = True; // bool | Display the legacy_id for the Attachments.
$items_per_page = 20; // int | Returns the given number of Attachments per request.
$page = 1; // int | Go to specific page of Attachments
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Attachments (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getAttachments($attachment_context_id, $attachment_context_type_id, $legacy_attachment_context_type, $legacy_attachment_context_id, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttachmentsApi->getAttachments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attachment_context_id** | **string**| Use this to filter Attachments by attachment_context_id. Requires filtering by attachment_context_type_id as well | [optional]
 **attachment_context_type_id** | **string**| Use this to filter Attachments by attachment_context_type_id. Requires filtering by attachment_context_id as well | [optional]
 **legacy_attachment_context_type** | **string**|  | [optional]
 **legacy_attachment_context_id** | **int**|  | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Attachments. | [optional]
 **items_per_page** | **int**| Returns the given number of Attachments per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Attachments | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Attachments (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Attachment[]**](../Model/Attachment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAttachmentsKey()`

```php
getAttachmentsKey($key, $show_legacy_id, $attributes): \SageOne\Model\Attachment
```

Returns a Attachment

Returns a Attachment

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AttachmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Attachment Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Attachment.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Attachment (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getAttachmentsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttachmentsApi->getAttachmentsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Attachment Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Attachment. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Attachment (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Attachment**](../Model/Attachment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAttachmentsKeyFile()`

```php
getAttachmentsKeyFile($key): \SageOne\Model\Attachment
```

Returns an Attachment File

Returns an Attachment File

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AttachmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Attachment Key.

try {
    $result = $apiInstance->getAttachmentsKeyFile($key);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttachmentsApi->getAttachmentsKeyFile: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Attachment Key. |

### Return type

[**\SageOne\Model\Attachment**](../Model/Attachment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postAttachments()`

```php
postAttachments($attachments): \SageOne\Model\Attachment
```

Creates a Attachment

Creates a Attachment

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AttachmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$attachments = new \SageOne\Model\PostAttachments(); // \SageOne\Model\PostAttachments

try {
    $result = $apiInstance->postAttachments($attachments);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttachmentsApi->postAttachments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attachments** | [**\SageOne\Model\PostAttachments**](../Model/PostAttachments.md)|  |

### Return type

[**\SageOne\Model\Attachment**](../Model/Attachment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putAttachmentsKey()`

```php
putAttachmentsKey($key, $attachments): \SageOne\Model\Attachment
```

Updates a Attachment

Updates a Attachment

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AttachmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Attachment Key.
$attachments = new \SageOne\Model\PutAttachments(); // \SageOne\Model\PutAttachments

try {
    $result = $apiInstance->putAttachmentsKey($key, $attachments);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttachmentsApi->putAttachmentsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Attachment Key. |
 **attachments** | [**\SageOne\Model\PutAttachments**](../Model/PutAttachments.md)|  |

### Return type

[**\SageOne\Model\Attachment**](../Model/Attachment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
