# SageOne\AttachmentContextTypesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getAttachmentContextTypes()**](AttachmentContextTypesApi.md#getAttachmentContextTypes) | **GET** /attachment_context_types | Returns all Attachment Context Types
[**getAttachmentContextTypesKey()**](AttachmentContextTypesApi.md#getAttachmentContextTypesKey) | **GET** /attachment_context_types/{key} | Returns a Attachment Context Type


## `getAttachmentContextTypes()`

```php
getAttachmentContextTypes($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\Base[]
```

Returns all Attachment Context Types

Returns all Attachment Context Types

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AttachmentContextTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Attachment Context Types.
$items_per_page = 20; // int | Returns the given number of Attachment Context Types per request.
$page = 1; // int | Go to specific page of Attachment Context Types
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Attachment Context Types (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getAttachmentContextTypes($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttachmentContextTypesApi->getAttachmentContextTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Attachment Context Types. | [optional]
 **items_per_page** | **int**| Returns the given number of Attachment Context Types per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Attachment Context Types | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Attachment Context Types (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base[]**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAttachmentContextTypesKey()`

```php
getAttachmentContextTypesKey($key, $show_legacy_id, $attributes): \SageOne\Model\Base
```

Returns a Attachment Context Type

Returns a Attachment Context Type

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AttachmentContextTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Attachment Context Type Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Attachment Context Type.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Attachment Context Type (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getAttachmentContextTypesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttachmentContextTypesApi->getAttachmentContextTypesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Attachment Context Type Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Attachment Context Type. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Attachment Context Type (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
