# SageOne\ArtefactStatusesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getArtefactStatuses()**](ArtefactStatusesApi.md#getArtefactStatuses) | **GET** /artefact_statuses | Returns all Artefact Statuses
[**getArtefactStatusesKey()**](ArtefactStatusesApi.md#getArtefactStatusesKey) | **GET** /artefact_statuses/{key} | Returns a Artefact Status


## `getArtefactStatuses()`

```php
getArtefactStatuses($show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\Base[]
```

Returns all Artefact Statuses

Returns all Artefact Statuses

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ArtefactStatusesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the Artefact Statuses.
$items_per_page = 20; // int | Returns the given number of Artefact Statuses per request.
$page = 1; // int | Go to specific page of Artefact Statuses
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Artefact Statuses (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getArtefactStatuses($show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArtefactStatusesApi->getArtefactStatuses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the Artefact Statuses. | [optional]
 **items_per_page** | **int**| Returns the given number of Artefact Statuses per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Artefact Statuses | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Artefact Statuses (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base[]**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getArtefactStatusesKey()`

```php
getArtefactStatusesKey($key, $show_legacy_id, $attributes): \SageOne\Model\Base
```

Returns a Artefact Status

Returns a Artefact Status

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\ArtefactStatusesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Artefact Status Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Artefact Status.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Artefact Status (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getArtefactStatusesKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArtefactStatusesApi->getArtefactStatusesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Artefact Status Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Artefact Status. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Artefact Status (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Base**](../Model/Base.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
