# SageOne\AddressesApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAddressesKey()**](AddressesApi.md#deleteAddressesKey) | **DELETE** /addresses/{key} | Deletes a Address
[**getAddresses()**](AddressesApi.md#getAddresses) | **GET** /addresses | Returns all Addresses
[**getAddressesKey()**](AddressesApi.md#getAddressesKey) | **GET** /addresses/{key} | Returns a Address
[**postAddresses()**](AddressesApi.md#postAddresses) | **POST** /addresses | Creates a Address
[**putAddressesKey()**](AddressesApi.md#putAddressesKey) | **PUT** /addresses/{key} | Updates a Address


## `deleteAddressesKey()`

```php
deleteAddressesKey($key)
```

Deletes a Address

Deletes a Address

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Address Key.

try {
    $apiInstance->deleteAddressesKey($key);
} catch (Exception $e) {
    echo 'Exception when calling AddressesApi->deleteAddressesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Address Key. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAddresses()`

```php
getAddresses($contact_id, $bank_account_id, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes): \SageOne\Model\Address[]
```

Returns all Addresses

Returns all Addresses

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$bank_account_id = 'bank_account_id_example'; // string | Use this to filter by bank account id
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Addresses changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$deleted_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Addresses deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp.
$show_legacy_id = True; // bool | Display the legacy_id for the Addresses.
$items_per_page = 20; // int | Returns the given number of Addresses per request.
$page = 1; // int | Go to specific page of Addresses
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Addresses (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getAddresses($contact_id, $bank_account_id, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AddressesApi->getAddresses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **bank_account_id** | **string**| Use this to filter by bank account id | [optional]
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Addresses changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **deleted_since** | **\DateTime**| Use this to limit the response to Addresses deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Addresses. | [optional]
 **items_per_page** | **int**| Returns the given number of Addresses per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Addresses | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Addresses (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Address[]**](../Model/Address.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAddressesKey()`

```php
getAddressesKey($key, $nested_attributes, $show_legacy_id, $attributes): \SageOne\Model\Address
```

Returns a Address

Returns a Address

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Address Key.
$nested_attributes = 'nested_attributes_example'; // string | Specify the attributes that you want to expose for nested entities of the Address (expose all nested attributes with 'all'). These are in addition to the base attributes (name, path)
$show_legacy_id = True; // bool | Display the legacy_id for the Address.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Address (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getAddressesKey($key, $nested_attributes, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AddressesApi->getAddressesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Address Key. |
 **nested_attributes** | **string**| Specify the attributes that you want to expose for nested entities of the Address (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Address. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Address (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Address**](../Model/Address.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postAddresses()`

```php
postAddresses($addresses): \SageOne\Model\Address
```

Creates a Address

Creates a Address

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$addresses = new \SageOne\Model\PostAddresses(); // \SageOne\Model\PostAddresses

try {
    $result = $apiInstance->postAddresses($addresses);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AddressesApi->postAddresses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **addresses** | [**\SageOne\Model\PostAddresses**](../Model/PostAddresses.md)|  |

### Return type

[**\SageOne\Model\Address**](../Model/Address.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putAddressesKey()`

```php
putAddressesKey($key, $addresses): \SageOne\Model\Address
```

Updates a Address

Updates a Address

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Address Key.
$addresses = new \SageOne\Model\PutAddresses(); // \SageOne\Model\PutAddresses

try {
    $result = $apiInstance->putAddressesKey($key, $addresses);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AddressesApi->putAddressesKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Address Key. |
 **addresses** | [**\SageOne\Model\PutAddresses**](../Model/PutAddresses.md)|  |

### Return type

[**\SageOne\Model\Address**](../Model/Address.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
