# SageOne\AddressRegionsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getAddressRegions()**](AddressRegionsApi.md#getAddressRegions) | **GET** /address_regions | Returns all Address Regions
[**getAddressRegionsKey()**](AddressRegionsApi.md#getAddressRegionsKey) | **GET** /address_regions/{key} | Returns a Address Region


## `getAddressRegions()`

```php
getAddressRegions($show_legacy_id, $items_per_page, $page, $attributes, $country_id): \SageOne\Model\AddressRegion[]
```

Returns all Address Regions

Returns all Address Regions

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AddressRegionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$show_legacy_id = True; // bool | Display the legacy_id for the States.
$items_per_page = 20; // int | Returns the given number of States per request.
$page = 1; // int | Go to specific page of States
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the States (expose all attributes with 'all'). These are in addition to the base attributes (name, path)
$country_id = 'country_id_example'; // string | Use this to filter by country id

try {
    $result = $apiInstance->getAddressRegions($show_legacy_id, $items_per_page, $page, $attributes, $country_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AddressRegionsApi->getAddressRegions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **show_legacy_id** | **bool**| Display the legacy_id for the States. | [optional]
 **items_per_page** | **int**| Returns the given number of States per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of States | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the States (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **country_id** | **string**| Use this to filter by country id | [optional]

### Return type

[**\SageOne\Model\AddressRegion[]**](../Model/AddressRegion.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAddressRegionsKey()`

```php
getAddressRegionsKey($key, $show_legacy_id, $attributes): \SageOne\Model\AddressRegion
```

Returns a Address Region

Returns a Address Region

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\AddressRegionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Address Region Key.
$show_legacy_id = True; // bool | Display the legacy_id for the State.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the State (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getAddressRegionsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AddressRegionsApi->getAddressRegionsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Address Region Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the State. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the State (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\AddressRegion**](../Model/AddressRegion.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
