<?php

/* 
 * Copyright Talisman Innovations Ltd. (2017). All rights reserved.
 * 
 * example usage
 * 
 * $revel = $this->get('talisman_revel');
   $revel->setup($shopName, $key, $secret, $establishment, $user);
         
   $product = $revel->product();
         
   $search = [];
   $search['updated_date'] = ['filter'=>'gte', 'query'=>'2017-06-06T15:13:09'];
         
   $products = $product->searchProducts($search);
 * 
 * 
 */

namespace Talisman\RevelBundle\Revel;

use Revel\Product;
use Revel\Inventory;
use Revel\Order;
use Revel\WebOrder;
use Revel\Category;
use Revel\Brand;
use Revel\Classes;
use Revel\User;
use Revel\Tax;
use Revel\Vendor;
use Revel\Returns;
use Revel\PhysicalInventory;
use Revel\InventoryReceipt;
use Revel\SystemSettingOption;
use Revel\Payment;
use Revel\OrderAllInOne;
use Revel\Customer;
use Exception;
use Psr\Log\LoggerInterface;

class Service {

    protected $logger;
    protected $shopName; 
    protected $key; 
    protected $secret; 
    protected $establishment; 
    protected $user;
    protected $setup = false;

    public function __construct(LoggerInterface $logger) {
        $this->logger = $logger;
    }
    /**
     * Pass in the access etc settings 
     * @param string $shopName
     * @param string $key
     * @param string $secret
     * @param integer $establishment
     * @param integer $user
     */
    public function setup($shopName, $key, $secret, $establishment, $user) {
        
        if(!$shopName || !$key || !$secret || !$establishment || !$user) {
            throw new Exception('Please check that all fields have been set');
        }
        
        $this->shopName = $shopName;
        $this->key = $key;
        $this->secret = $secret; 
        $this->establishment = $establishment; 
        $this->user = $user;
        $this->setup = true;
    }

    /**
     * Product object
     * @return \Revel\Revel\Product
     */
    public function product() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new Product($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    /**
     * Inventory object
     * @return \Revel\Revel\Inventory
     */
    public function inventory() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new Inventory($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    /**
     * Sale Object
     * @return \Revel\Revel\Inventory
     */
    public function order() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new Order($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    /**
     * WebOrder Object
     * @return \Revel\Revel\WebOrder
     */
    public function webOrder() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new WebOrder($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    /**
     * PO Object
     * @return \Revel\Revel\PurchaseOrder
     */
    public function purchaseOrder() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new purchaseOrder($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    public function purchaseOrderInvoice() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new purchaseOrderInvoice($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    /**
     * Category Object
     * @return \Revel\Revel\Category
     */
    public function category() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new Category($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    
    /**
     * Classes Object
     * @return \Revel\Revel\Classes
     */
    public function classes() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new Classes($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    
    /**
     * Brand Object
     * @return \Revel\Revel\Brand
     */
    public function brand() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new Brand($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    
    /**
     * User Object
     * @return \Revel\Revel\Brand
     */
    public function user() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new User($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    
    /**
     * Tax Object
     * @return \Revel\Revel\Tax
     */
    public function tax() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new Tax($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    
    /**
     * Vendor
     * @return Vendor
     * @throws Exception
     */
    public function vendor() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new Vendor($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    
    /**
     * Returns
     * @return Returns
     * @throws Exception
     */
    public function returns() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new Returns($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    
    /**
     * Physical Inventory (stock check)
     * @return PhysicalInventory
     * @throws Exception
     */
    public function physicalInventory() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new PhysicalInventory($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    
    /**
     * Inventory Receipt
     * @return InventoryReceipt
     * @throws Exception
     */
    public function inventoryReceipt() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new InventoryReceipt($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    
    /**
     * System Setting Optiion
     * @return SystemSettingOption
     * @throws Exception
     */
    public function systemSettingOption() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new SystemSettingOption($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    
    public function payment() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new Payment($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    
    public function orderAllInOne() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new OrderAllInOne($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
    
    public function customer() {
        if($this->setup===false) {
            throw new Exception('Setup data needs to be added, please check');
        }
        return new Customer($this->logger, $this->shopName, $this->key, $this->secret, $this->establishment, $this->user);
    }
}
