<?php

/* 
 * Copyright Talisman Innovations Ltd. (2017). All rights reserved.
 */

namespace Revel;

use Revel\Call;
use Psr\Log\LoggerInterface;

class WebOrder extends Call {
    
    protected $endpoint = '/weborders/';
    protected $cart = '/specialresources/cart/';

    /**
     * Setup orders
     * @param \Revel\LoggerInterface $logger
     * @param string $shopName
     * @param string $key
     * @param string $secret
     * @param int $establishment (Passing this in limits the results to a particular warehouse)
     * @param int $user
     */
    public function __construct(LoggerInterface $logger, $shopName, $key, $secret, $establishment=null, $user=null, $format = 'json') {
        parent::__construct($logger, $shopName, $key, $secret, $establishment, $user, $format);
    }
  
    public function getProducts() {
        return $this->request($this->endpoint.'products/');
    }
    
    public function getAllProducts() {
        return $this->requestAll($this->endpoint.'products/');
    }
    
    public function getMenus() {
        return $this->request($this->endpoint.'menu/');
    }
    
    public function getSystemSettings() {
        return $this->request($this->endpoint.'system_settings/');
    }

    public function getCategories() {
        return $this->request($this->endpoint.'product_categories/');
    }

    public function validateOrder(array $order) {
        return $this->post($this->cart.'validate/', $order);
    }
    
    public function postOrder(array $order) {
        return $this->post($this->cart.'submit/', $order);
    }
    
 
    
}