<?php

/* 
 * Copyright Talisman Innovations Ltd. (2017). All rights reserved.
 */

namespace Revel;

use Revel\Call;
use Psr\Log\LoggerInterface;

class Tax extends Call {
    
    protected $tax = '/resources/Tax/';
    protected $taxProductGroup = '/resources/TaxProductGroup/';
    protected $viewTax = '/resources/ViewTax/';

    /**
     * Setup Tax
     * @param \Revel\LoggerInterface $logger
     * @param string $shopName
     * @param string $key
     * @param string $secret
     * @param int $establishment (Passing this in limits the results to a particular warehouse)
     * @param int $user
     */
    public function __construct(LoggerInterface $logger, $shopName, $key, $secret, $establishment=null, $user=null, $format = 'json') {
        parent::__construct($logger, $shopName, $key, $secret, $establishment, $user, $format);
    }
    
    /**
     * Get a single product from ID
     * @param Integer $productId
     * @return object
     */
    public function getTax($taxId) {
        return $this->request($this->tax.$taxId.'/');
    }
    
    /**
     * Pass in an array of search parameters and filters 
     * i.e.
     * $search = [];
     * $search['updated_date'] = ['filter'=>'gte', 'query'=>'2017-06-06T15:13:09'];
     * 
     * available filters
     * lt = Less than
     * lte = Less than or equals
     * gt = Greater than
     * gte = Greater than or equals
     * exact = Case-sensitive exact match
     * iexact = Case-insensitive exact match
     * contains = Case-sensitive containment
     * icontains = Case-insensitive containment
     * in = In a given array (comma separated) 1,2,4
     * startswith = Case-sensitive starts-with
     * istartswith = Case-insensitive starts-with
     * endswith = Case-sensitive ends-with
     * iendswith = Case-insensitive ends-with
     * range = Inclusive range (comma separated)
     * isnull = Checks null value
     * 
     * @param array $search
     * @return array of objects
     */
    public function searchTaxes(array $search) {
        return $this->requestAll($this->tax, $search);
    }   
    
    /**
     * Get All Taxs
     * @return array of objects
     */
    public function getTaxes() {
        return $this->requestAll($this->tax);
    } 
    
    public function getTaxProductGroups() {
        return $this->requestAll($this->taxProductGroup);
    } 
    
    public function getTaxProductGroup($groupId) {
        return $this->request($this->taxProductGroup.$groupId.'/');
    }
    
    
    public function viewTax($taxId) {
        return $this->request($this->viewTax.$taxId.'/');
    }
}