<?php

/* 
 * Copyright Talisman Innovations Ltd. (2017). All rights reserved.
 */

namespace Revel;

use Revel\Call;
use Psr\Log\LoggerInterface;

class SystemSettingOption extends Call {
    
    protected $systemSettingOption = '/resources/SystemSettingOption/';
   
    /**
     * Setup SystemSettingOption
     * @param \Revel\LoggerInterface $logger
     * @param string $shopName
     * @param string $key
     * @param string $secret
     * @param int $establishment (Passing this in limits the results to a particular warehouse)
     * @param int $user
     */
    public function __construct(LoggerInterface $logger, $shopName, $key, $secret, $establishment=null, $user=null, $format = 'json') {
        parent::__construct($logger, $shopName, $key, $secret, $establishment, $user, $format);
    }
    
    /**
     * Get a single product from ID
     * @param Integer $productId
     * @return object
     */
    public function getSystemSettingOption($systemSettingOptionId) {
        return $this->request($this->systemSettingOption.$systemSettingOptionId.'/', 1);
    }
    
       
    public function getSystemSettingOptionByName($optSearch) {
        return $this->request($this->systemSettingOption, 1, ['setting_name'=>$optSearch]);
    }
    
    
    public function getSystemSettingOptions() {
        return $this->requestAll($this->systemSettingOption, [], 1);
    }
   
   
}