<?php

/* 
 * Copyright Talisman Innovations Ltd. (2017). All rights reserved.
 */

namespace Revel;

use Revel\Call;
use Psr\Log\LoggerInterface;

class Returns extends Call {
    
    protected $endpoint = '/resources/Return/';

    /**
     * Setup Return
     * @param \Revel\LoggerInterface $logger
     * @param string $shopName
     * @param string $key
     * @param string $secret
     * @param int $establishment (Passing this in limits the results to a particular warehouse)
     * @param int $user
     */
    public function __construct(LoggerInterface $logger, $shopName, $key, $secret, $establishment=null, $user=null, $format = 'json') {
        parent::__construct($logger, $shopName, $key, $secret, $establishment, $user, $format);
    }
    
    public function getReturn($orderId) {
        return $this->request($this->endpoint.$orderId.'/');
    }
    
    public function getReturns() {
        return $this->requestAll($this->endpoint);
    }
    public function searchReturns(array $search) {
        return $this->requestAll($this->endpoint, $search);
    }   
   
    public function addReturn() {
        
    }
    
    public function updateReturn() {
        
    }
    
}