<?php

/* 
 * Copyright Talisman Innovations Ltd. (2017). All rights reserved.
 */

namespace Revel;

use Revel\Call;
use Psr\Log\LoggerInterface;

class Product extends Call {
    
    protected $endpoint = '/resources/Product/';

    /**
     * Setup products
     * @param \Revel\LoggerInterface $logger
     * @param string $shopName
     * @param string $key
     * @param string $secret
     * @param int $establishment (Passing this in limits the results to a particular warehouse)
     * @param int $user
     */
    public function __construct(LoggerInterface $logger, $shopName, $key, $secret, $establishment=null, $user=null, $format = 'json') {
        parent::__construct($logger, $shopName, $key, $secret, $establishment, $user, $format);
    }
    
    /**
     * Get a single product from ID
     * @param Integer $productId
     * @return object
     */
    public function getProduct($productId) {
        return $this->request($this->endpoint.$productId.'/');
    }
    
    public function getProductBySku($sku) {
        return $this->request($this->endpoint, null, ['sku'=>$sku]);
    }
    
    
    
    /**
     * Pass in an array of search parameters and filters 
     * i.e.
     * $search = [];
     * $search['updated_date'] = ['filter'=>'gte', 'query'=>'2017-06-06T15:13:09'];
     * 
     * available filters
     * lt = Less than
     * lte = Less than or equals
     * gt = Greater than
     * gte = Greater than or equals
     * exact = Case-sensitive exact match
     * iexact = Case-insensitive exact match
     * contains = Case-sensitive containment
     * icontains = Case-insensitive containment
     * in = In a given array (comma separated) 1,2,4
     * startswith = Case-sensitive starts-with
     * istartswith = Case-insensitive starts-with
     * endswith = Case-sensitive ends-with
     * iendswith = Case-insensitive ends-with
     * range = Inclusive range (comma separated)
     * isnull = Checks null value
     * 
     * @param array $search
     * @return array of objects
     */
    public function searchProducts(array $search) {
        return $this->requestAll($this->endpoint, $search);
    }   
    
    /**
     * Get All Products
     * @return array of objects
     */
    public function getProducts() {
        return $this->requestAll($this->endpoint);
    } 
    
    /**
     * Get Products in a category
     * @param integer $catId
     * @return array of objects
     */
    public function getProductsByCategory($catId) {
        return $this->requestAll($this->endpoint.'ProductCategory/'.$catId.'/');
    }
    
    /**
     * Get Products in a class
     * @param integer $classId
     * @return array of objects
     */
    public function getProductsByClass($classId) {
        return $this->requestAll($this->endpoint.'ProductClass/'.$classId.'/');
    }
   
    public function addProduct() {
        
    }
    
    public function updateProduct() {
        
    }
    
}