<?php

/* 
 * Copyright Talisman Innovations Ltd. (2017). All rights reserved.
 */

namespace Revel;

use Revel\Call;
use Psr\Log\LoggerInterface;

class Order extends Call {
    
    protected $endpoint = '/resources/Order/';

    /**
     * Setup orders
     * @param \Revel\LoggerInterface $logger
     * @param string $shopName
     * @param string $key
     * @param string $secret
     * @param int $establishment (Passing this in limits the results to a particular warehouse)
     * @param int $user
     */
    public function __construct(LoggerInterface $logger, $shopName, $key, $secret, $establishment=null, $user=null, $format = 'json') {
        parent::__construct($logger, $shopName, $key, $secret, $establishment, $user, $format);
    }
    
    public function getOrder($orderId) {
        return $this->request($this->endpoint.$orderId.'/');
    }
    
    public function getOrderByExternalSync($external) {
        return $this->request($this->endpoint, null, ['external_sync'=>$external]);
    }
  
    
    public function getOrders() {
        return $this->requestAll($this->endpoint);
    }
    public function searchOrders(array $search) {
        return $this->requestAll($this->endpoint, $search);
    }   
   
    public function addOrder() {
        
    }
    
    public function updateOrder() {
        
    }
    
}