<?php

/* 
 * Copyright Talisman Innovations Ltd. (2017). All rights reserved.
 */

namespace Revel;

use Revel\Call;
use Psr\Log\LoggerInterface;

class InventoryReceipt extends Call {
    
    protected $endpoint = '/resources/InventoryReceipt/';

    /**
     * Setup InventoryReceipt
     * @param \Revel\LoggerInterface $logger
     * @param string $shopName
     * @param string $key
     * @param string $secret
     * @param int $establishment (Passing this in limits the results to a particular warehouse)
     * @param int $user
     */
    public function __construct(LoggerInterface $logger, $shopName, $key, $secret, $establishment=null, $user=null, $format = 'json') {
        parent::__construct($logger, $shopName, $key, $secret, $establishment, $user, $format);
    }
    
    public function getInventoryReceipt($orderId) {
        return $this->request($this->endpoint.$orderId.'/');
    }
    
    public function getInventoryReceipts() {
        return $this->requestAll($this->endpoint);
    }
    public function searchInventoryReceipts(array $search) {
        return $this->requestAll($this->endpoint, $search);
    }   
   
    public function addInventoryReceipt() {
        
    }
    
    public function updateInventoryReceipt() {
        
    }
    
}