<?php

/* 
 * Copyright Talisman Innovations Ltd. (2017). All rights reserved.
 */

namespace Revel;

use Revel\Call;
use Psr\Log\LoggerInterface;
use DateTime;

class Inventory extends Call {
    
    protected $endpoint = '/inventoryx/api/inventory/Product/';

    /**
     * Setup inventory
     * @param \Revel\LoggerInterface $logger
     * @param string $shopName
     * @param string $key
     * @param string $secret
     * @param int $establishment (Passing this in limits the results to a particular warehouse)
     * @param int $user
     */
    public function __construct(LoggerInterface $logger, $shopName, $key, $secret, $establishment=null, $user=null, $format = 'json') {
        parent::__construct($logger, $shopName, $key, $secret, $establishment, $user, $format);
    }
    
    public function getInventory($productId) {
        return $this->request($this->endpoint.$productId.'/');
    }
    
    public function getInventories() {
        return $this->requestAll($this->endpoint);
    }
    
    public function searchInventory(array $search) {
      
        # Special Date string required for Inventory
        # Check for a date and amend to the correct format
        foreach($search as $key=>$value) {
            if (DateTime::createFromFormat('Y-m-d\TH:i:s', $value['query']) !== FALSE) {
                $search[$key] = ['filter' => $value['filter'], 'query' => '__hour__minute__second='.$value['query']];
            }
            
        }
        return $this->requestAll($this->endpoint, $search);
    }   
    
    
}