<?php

/* 
 * Copyright Talisman Innovations Ltd. (2017). All rights reserved.
 */

namespace Revel;

use Revel\Call;
use Psr\Log\LoggerInterface;

class Customer extends Call {
    
    protected $endpoint = '/resources/Customer/';

    /**
     * Setup Customer
     * @param \Revel\LoggerInterface $logger
     * @param string $shopName
     * @param string $key
     * @param string $secret
     * @param int $establishment (Passing this in limits the results to a particular warehouse)
     * @param int $user
     */
    public function __construct(LoggerInterface $logger, $shopName, $key, $secret, $establishment=null, $user=null, $format = 'json') {
        parent::__construct($logger, $shopName, $key, $secret, $establishment, $user, $format);
    }
    
    public function getCustomer($orderId) {
        return $this->request($this->endpoint.$orderId.'/');
    }
    
    public function getCustomers() {
        return $this->requestAll($this->endpoint);
    }
    public function searchCustomers(array $search) {
        return $this->requestAll($this->endpoint, $search);
    }   
    
    public function getCustomerByEmail($email) {
        return $this->request($this->endpoint, null, ['email'=>$email]);
    }
   
    public function postCustomer($data) {
        return $this->post($this->endpoint, $data);
    }
    
}