<?php

/* 
 * Copyright Talisman Innovations Ltd. (2017). All rights reserved.
 */

namespace Talisman\Red61VIABundle\Red61VIA;

use Red61\Via\ApiRequest\ViaApiRequest;

class UpdateMerchandiseVariant extends ViaApiRequest 
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'updateMerchandiseVariant';


  protected $merchVariationRef; #string
  protected $code; #string
  protected $title; #string
  protected $description; #string
  protected $value; #big decimal
  protected $barcode; #string


  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }
  
  public function getMerchVariationRef() {
      return $this->merchVariationRef;
  }

  public function getCode() {
      return $this->code;
  }

  public function getTitle() {
      return $this->title;
  }

  public function getDescription() {
      return $this->description;
  }

  public function getValue() {
      return $this->value;
  }

  public function getBarcode() {
      return $this->barcode;
  }

  public function setMerchVariationRef($merchVariationRef) {
      $this->merchVariationRef = $merchVariationRef;
      return $this;
  }

  public function setCode($code) {
      $this->code = $code;
      return $this;
  }

  public function setTitle($title) {
      $this->title = $title;
      return $this;
  }

  public function setDescription($description) {
      $this->description = $description;
      return $this;
  }

  public function setValue($value) {
      $this->value = $value;
      return $this;
  }

  public function setBarcode($barcode) {
      $this->barcode = $barcode;
      return $this;
  }


  
}