<?php
/**
 * Copyright Talisman Innovations Ltd. (2020). All rights reserved.
 */

namespace Talisman\Red61VIABundle\Red61VIA;

use SoapClient;
use Psr\Log\LoggerInterface;

class SoapClientLogger extends SoapClient
{
    /** @var LoggerInterface */
    protected $logger;

    /**
     * @param string $request
     * @param string $location
     * @param string $action
     * @param int $version
     * @param int $one_way
     * @return string
     */
    function __doRequest($request, $location, $action, $version, $one_way = 0)
    {
        $response = parent::__doRequest($request, $location, $action, $version, $one_way);

        if (!$this->logger) {
            return $response;
        }

        $context['location'] = $location;
        $context['request_headers'] = parent::__getLastRequestHeaders();

        $xml = simplexml_load_string(parent::__getLastRequest());
        $context['request'] = $xml ? $xml->asXML() : parent::__getLastRequest();

        if ($one_way === 0)
        {
            $context['response_headers'] = parent::__getLastResponseHeaders();

            $xml = simplexml_load_string(parent::__getLastResponse());
            $context['response'] = $xml ? $xml->asXML() : parent::__getLastResponse();
        }

        $this->logger->info($action, $context);

        return $response;
    }

    /**
     * route all other method calls directly to soapClient
     *
     * @param string $method
     * @param array $args
     * @return mixed
     */
    public function __call($method, $args)
    {
        return call_user_func_array(array($this, $method), $args);
    }
}