<?php

/* 
 * Copyright Talisman Innovations Ltd. (2017). All rights reserved.
 */

namespace Talisman\Red61VIABundle\Red61VIA;
use Red61\Via\ApiRequest\ViaApiRequest;

class SetMerchandiseStockLevel extends ViaApiRequest 
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'setMerchandiseStockLevel';

  protected $merchVariationRef; #string
  protected $stockLevel; #int

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }
  
  
  public function setPerformance($perf) {
      $this->performance = $perf;
      return $this;
  }
  
  
   public function getPerformance() {
      return $this->performance;
  }
  
  public function getMerchVariationRef() {
      return $this->merchVariationRef;
  }

  public function getStockLevel() {
      return $this->stockLevel;
  }

  public function setMerchVariationRef($merchVariationRef) {
      $this->merchVariationRef = $merchVariationRef;
      return $this;
  }

  public function setStockLevel($stockLevel) {
      $this->stockLevel = $stockLevel;
      return $this;
  }


  
  
}