<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Talisman\Red61VIABundle\Red61VIA;

use Red61\Via\SoapClientFactory;
use Red61\Via\Exception\ViaExceptionMapper;
use Red61\Via\Plugin\ViaCorePluginManager;
use Red61\Via\Cache\ViaFilecacheDriver;
use Red61\Via\Cache\ViaCachePlugin;
use Red61\Via\Cache\ViaCacheKeyGenerator;
use Red61\Via\ViaApiClient;
use Red61\Via\ViaApiService;
use Red61\Via\ApiRequest\apiLoginRequest;
use Red61\Via\ApiRequest\apiGetCustomerDetailsRequest;
use Red61\Via\ApiRequest\apiGetOrderSummaryRequest;
use Red61\Via\ApiRequest\apiGetEventDetailsRequest;
use Red61\Via\ApiRequest\apiGetEventsRequest;
use Red61\Via\ApiRequest\apiGetEventTypesRequest;
use Red61\Via\ApiRequest\apiGetOrderTicketDetailsRequest;
use Red61\Via\ApiRequest\apiGetMerchandiseRequest;
use Red61\Via\ApiRequest\apiGetCardTypeFromBINRequest;
use Red61\Via\ApiRequest\apiGetCustomerGiftAidDeclarationsRequest;
use Red61\Via\ApiRequest\apiGetMerchandiseCategoriesRequest;
use Red61\Via\ApiRequest\apiGetMerchandiseByCategoryRequest;
use Red61\Via\ApiRequest\apiGetPerformanceDetailsRequest;
use Red61\Via\ApiRequest\apiGetPerformancePricesRequest;
use Psr\Log\LoggerInterface;
use Exception;

class Service {
    
    protected $wsdl;
    protected $logger;
    /**
     * @var array
     */
    protected static $defaultOptions = array(
        'exceptions'         => true,
        'connection_timeout' => 15,
        'keep_alive'         => true,
        'compression'        => true,
        'features'           => SOAP_SINGLE_ELEMENT_ARRAYS,
    );
    protected $options;
    protected $service;
    protected $session;


    public function __construct(LoggerInterface $logger) {
        $this->logger = $logger;
    }
    
    public function service($wsdl, $webKey, $options = null) {
        
        $this->wsdl    = $wsdl;
        $this->webKey = $webKey;

        $this->setOptions($options);
        
        // Responsible for creating a SoapClient just before the first request is sent
        $soapFactory     = new SoapClientFactory($this->getOptions());
        // Converts generic SoapFault to ViaException classes
        $exceptionMapper = new ViaExceptionMapper();
        // Manages the list of plugins and dispatches event notifications
        $pluginManager   = new ViaCorePluginManager;
        // Caches VIA responses on disk for subsequent reuse
        //$cacheDriver     = new ViaFilecacheDriver(sys_get_temp_dir().'/via');
        // Manages the caching, using the $cache_driver backen interface
        //$cachePlugin = new ViaCachePlugin($cacheDriver, new ViaCacheKeyGenerator);
        //$pluginManager->registerPlugin($cachePlugin);
        // Actually sends requests to VIA and processes the responses
        $apiClient       = new ViaApiClient($soapFactory, $exceptionMapper, $pluginManager, $wsdl, $webKey);
        // Thin wrapper around $api_client with a method for each API method to allow typehinting of response types
        $this->service  = new ViaApiService($apiClient);
        
        return $this->service;
    }
    
    public function client($wsdl, $webKey, $options = null) {
          // Responsible for creating a SoapClient just before the first request is sent
        $soapFactory     = new SoapClientFactory($this->getOptions());
        // Converts generic SoapFault to ViaException classes
        $exceptionMapper = new ViaExceptionMapper();
        // Manages the list of plugins and dispatches event notifications
        $pluginManager   = new ViaCorePluginManager;
        // Caches VIA responses on disk for subsequent reuse
        //$cacheDriver     = new ViaFilecacheDriver(sys_get_temp_dir().'/via');
        // Manages the caching, using the $cache_driver backen interface
        //$cachePlugin = new ViaCachePlugin($cacheDriver, new ViaCacheKeyGenerator);
        //$pluginManager->registerPlugin($cachePlugin);
        // Actually sends requests to VIA and processes the responses
        $apiClient       = new ViaApiClient($soapFactory, $exceptionMapper, $pluginManager, $wsdl, $webKey);
        return $apiClient;
        
        
    }
    
    public function __destruct() {
        unset($this->options);
        unset($this->sessionId);
        unset($this->service);
    }
    
    public function getOptions() {
        return $this->options;
    }


    public function setOptions($options)  {
       if(!is_array($options)) {
          $options = []; 
       }
        $this->options = array_merge(self::$defaultOptions, $options);
        return $this;
    }
    
    public function login($email, $password) {
        $loginRequest  = apiLoginRequest::create()->setEmail($email)->setPassword($password);
         dump($this->service);
        try {
            $this->session = $this->service->login($loginRequest);
           
            
        } catch (Exception $ex) {
            dump($ex);
            
        }
        return;
    }
    
    
    public function getCustomerDetails($customerId) {
        return $this->service->getCustomerDetails(apiGetCustomerDetailsRequest::create()->setCustomerId($customerId));
    }
    
    
    public function getOrderSummaryRequest($orderId) {
    
        return $this->service->getOrderSummary(apiGetOrderSummaryRequest::create()->setOrderId($orderId));
    }
    
    public function getEventDetails($eventId) {
        return $this->service->getEventDetails(apiGetEventDetailsRequest::create()->setEventRef($eventId));
    }
    
    public function getEvents() {
        return $this->service->getEvents(apiGetEventsRequest::create());
    }
    
    public function getEventTypes() {
        return $this->service->getEventTypes(apiGetEventTypesRequest::create());
    }
    
    public function getOrderTicketDetails() {
        return $this->service->getOrderTicketDetails(apiGetOrderTicketDetailsRequest::create());
    }
    
    public function getMerchandise($ref) {
        return $this->service->getMerchandise(apiGetMerchandiseRequest::create()->setMerchandiseRef($ref));
    }
    
    public function getMerchandiseByCategory($ref) {
        return $this->service->getMerchandiseByCategory(apiGetMerchandiseByCategoryRequest::create()->setMerchandiseCategoryRef($ref));
    }
    
    public function getMerchandiseCategories() {
        return $this->service->getMerchandiseCategories(apiGetMerchandiseCategoriesRequest::create());
    }
    
    public function getCustomerGiftAidDeclarations($id) {
        return $this->service->getCustomerGiftAidDeclarations(apiGetCustomerGiftAidDeclarationsRequest::create()->setCustomerId($id));
    }
    
    public function getPerformanceDetails($id) {
        return $this->service->getPerformanceDetails(apiGetPerformanceDetailsRequest::create()->setPerformanceRef($id));
    }
    
    public function getPerformancePrices($id) {
        return $this->service->getPerformancePrices(apiGetPerformancePricesRequest::create()->setPerformanceRef($id));
    }
    
   
}