<?php
/**
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */


namespace Quickbooks;

use League\OAuth2\Client\Provider\AbstractProvider;
use League\OAuth2\Client\Token\AccessToken;
use League\OAuth2\Client\Tool\BearerAuthorizationTrait;
use Psr\Http\Message\ResponseInterface;

class QuickbooksProvider extends AbstractProvider
{
    use BearerAuthorizationTrait;

    public function getBaseUrl()
    {
        return 'https://oauth.platform.intuit.com/';
    }

    public function getBaseAuthorizationUrl()
    {
        return 'https://appcenter.intuit.com/connect/oauth2';
    }

    public function getBaseAccessTokenUrl(array $params)
    {
        return 'https://oauth.platform.intuit.com/oauth2/v1/tokens/bearer';
    }

    public function getResourceOwnerDetailsUrl(AccessToken $token)
    {
        return '????';
    }

    protected function getDefaultScopes()
    {
        return [
            'com.intuit.quickbooks.accounting'
        ];
    }

    public function getScopeSeparator()
    {
        return ' ';
    }

    protected function checkResponse(ResponseInterface $response, $data)
    {
        return;
    }

    protected function createResourceOwner(array $response, AccessToken $token)
    {
        return $token;
    }

    protected function getAllowedClientOptions(array $options)
    {
        $client_options = ['timeout', 'proxy', 'handler'];

        // Only allow turning off ssl verification if it's for a proxy
        if (!empty($options['proxy'])) {
            $client_options[] = 'verify';
        }

        return $client_options;
    }
}