<?php
/**
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace Quickbooks;

use Exception;

class Examples extends \PHPUnit_Framework_TestCase
{
    // need to set these constants
    const CLIENT_ID = '';
    const CLIENT_SECRET = '';
    const REALM_ID = ''; // this needs to be stored in the settings by the code that handles the redirect
    const REDIRECT_URI = 'http://localhost:8000/test_auth';
    const SCOPE = 'com.intuit.quickbooks.accounting';
    const ENVIRONMENT = 'development';

    // this is just sample code, you will need to duplicate this in the symfony project. here we don't have access to the tenant id, the settings or the logger.
    // Look in the src\_Samples directory of the official library for more examples.

    public function testXXX()
    {
        try {

            $this->tenantManager->setTenantId(1);

            $token = new AccessToken($this->sm, 'quickbooks');

            $dataService = ClientBuilder::getClient(
                self::CLIENT_ID,
                self::CLIENT_SECRET,
                self::ENVIRONMENT,
                self::REALM_ID,
                $token,
                $this->lockFactory,
                $this->apiLogger
            );

            $allCompanies = $dataService->FindAll('CompanyInfo');

            foreach ($allCompanies as $oneCompany) {

                /** @var IPPCompanyInfo $oneCompanyReLookedUp */
                $oneCompanyReLookedUp = $dataService->FindById($oneCompany);

                echo "Company Name: {$oneCompanyReLookedUp->CompanyName}\n";

            }

        } catch (Exception $exception) {

            $error = $exception->getMessage();

        }
    }

    // Sample controller code in order to create the authorisation url and then get the access token.

    /**
     * @Route("/test_login", name="test_login")
     */
    public function test_login(Request $request)
    {
        try {

            $url = ClientBuilder::getAuthorizationUrl(
                self::CLIENT_ID,
                self::CLIENT_SECRET,
                self::REDIRECT_URI,
                self::SCOPE,
                self::ENVIRONMENT
            );

            return $this->redirect($url);

        } catch (Exception $exception) {

            $error = $exception->getMessage();

        }
    }

    /**
     * @Route("/test_auth", name="test_auth")
     */
    public function test_auth(Request $request)
    {
        try {

            $authCode = $request->query->get('code');
            $realmId = $request->query->get('realmId');
            $state = $request->query->get('state');

            $this->tenantManager->setTenantId(1);

            $token = new AccessToken($this->settingsManager, 'quickbooks');

            ClientBuilder::getAccessToken(
                self::CLIENT_ID,
                self::CLIENT_SECRET,
                self::REDIRECT_URI,
                self::SCOPE,
                self::ENVIRONMENT,
                $authCode,
                $realmId,
                $token,
                $this->logger
            );

        } catch (Exception $exception) {

            $error = $exception->getMessage();

        }

        exit;
    }
}