<?php
/**
 * ProductAssociations
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Prestashop
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * prestashop
 *
 * https://devdocs.prestashop-project.org/8/webservice/
 *
 * The version of the OpenAPI document: 1.0
 * Contact: admin@tideconnetcs.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Prestashop\Model;

use \ArrayAccess;
use \Prestashop\ObjectSerializer;

/**
 * ProductAssociations Class Doc Comment
 *
 * @category Class
 * @package  Prestashop
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProductAssociations implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'product_associations';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'categories' => '\Prestashop\Model\Id[]',
        'images' => '\Prestashop\Model\Id[]',
        'combinations' => '\Prestashop\Model\Id[]',
        'product_option_values' => '\Prestashop\Model\Id[]',
        'product_features' => '\Prestashop\Model\ProductFeature[]',
        'stock_availables' => '\Prestashop\Model\StockAvailable[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'categories' => null,
        'images' => null,
        'combinations' => null,
        'product_option_values' => null,
        'product_features' => null,
        'stock_availables' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'categories' => false,
		'images' => false,
		'combinations' => false,
		'product_option_values' => false,
		'product_features' => false,
		'stock_availables' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'categories' => 'categories',
        'images' => 'images',
        'combinations' => 'combinations',
        'product_option_values' => 'product_option_values',
        'product_features' => 'product_features',
        'stock_availables' => 'stock_availables'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'categories' => 'setCategories',
        'images' => 'setImages',
        'combinations' => 'setCombinations',
        'product_option_values' => 'setProductOptionValues',
        'product_features' => 'setProductFeatures',
        'stock_availables' => 'setStockAvailables'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'categories' => 'getCategories',
        'images' => 'getImages',
        'combinations' => 'getCombinations',
        'product_option_values' => 'getProductOptionValues',
        'product_features' => 'getProductFeatures',
        'stock_availables' => 'getStockAvailables'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('categories', $data ?? [], null);
        $this->setIfExists('images', $data ?? [], null);
        $this->setIfExists('combinations', $data ?? [], null);
        $this->setIfExists('product_option_values', $data ?? [], null);
        $this->setIfExists('product_features', $data ?? [], null);
        $this->setIfExists('stock_availables', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets categories
     *
     * @return \Prestashop\Model\Id[]|null
     */
    public function getCategories()
    {
        return $this->container['categories'];
    }

    /**
     * Sets categories
     *
     * @param \Prestashop\Model\Id[]|null $categories categories
     *
     * @return self
     */
    public function setCategories($categories)
    {
        if (is_null($categories)) {
            throw new \InvalidArgumentException('non-nullable categories cannot be null');
        }
        $this->container['categories'] = $categories;

        return $this;
    }

    /**
     * Gets images
     *
     * @return \Prestashop\Model\Id[]|null
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     *
     * @param \Prestashop\Model\Id[]|null $images images
     *
     * @return self
     */
    public function setImages($images)
    {
        if (is_null($images)) {
            throw new \InvalidArgumentException('non-nullable images cannot be null');
        }
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets combinations
     *
     * @return \Prestashop\Model\Id[]|null
     */
    public function getCombinations()
    {
        return $this->container['combinations'];
    }

    /**
     * Sets combinations
     *
     * @param \Prestashop\Model\Id[]|null $combinations combinations
     *
     * @return self
     */
    public function setCombinations($combinations)
    {
        if (is_null($combinations)) {
            throw new \InvalidArgumentException('non-nullable combinations cannot be null');
        }
        $this->container['combinations'] = $combinations;

        return $this;
    }

    /**
     * Gets product_option_values
     *
     * @return \Prestashop\Model\Id[]|null
     */
    public function getProductOptionValues()
    {
        return $this->container['product_option_values'];
    }

    /**
     * Sets product_option_values
     *
     * @param \Prestashop\Model\Id[]|null $product_option_values product_option_values
     *
     * @return self
     */
    public function setProductOptionValues($product_option_values)
    {
        if (is_null($product_option_values)) {
            throw new \InvalidArgumentException('non-nullable product_option_values cannot be null');
        }
        $this->container['product_option_values'] = $product_option_values;

        return $this;
    }

    /**
     * Gets product_features
     *
     * @return \Prestashop\Model\ProductFeature[]|null
     */
    public function getProductFeatures()
    {
        return $this->container['product_features'];
    }

    /**
     * Sets product_features
     *
     * @param \Prestashop\Model\ProductFeature[]|null $product_features product_features
     *
     * @return self
     */
    public function setProductFeatures($product_features)
    {
        if (is_null($product_features)) {
            throw new \InvalidArgumentException('non-nullable product_features cannot be null');
        }
        $this->container['product_features'] = $product_features;

        return $this;
    }

    /**
     * Gets stock_availables
     *
     * @return \Prestashop\Model\StockAvailable[]|null
     */
    public function getStockAvailables()
    {
        return $this->container['stock_availables'];
    }

    /**
     * Sets stock_availables
     *
     * @param \Prestashop\Model\StockAvailable[]|null $stock_availables stock_availables
     *
     * @return self
     */
    public function setStockAvailables($stock_availables)
    {
        if (is_null($stock_availables)) {
            throw new \InvalidArgumentException('non-nullable stock_availables cannot be null');
        }
        $this->container['stock_availables'] = $stock_availables;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


