<?php
/**
 * Product
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Prestashop
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * prestashop
 *
 * https://devdocs.prestashop-project.org/8/webservice/
 *
 * The version of the OpenAPI document: 1.0
 * Contact: admin@tideconnetcs.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Prestashop\Model;

use \ArrayAccess;
use \Prestashop\ObjectSerializer;

/**
 * Product Class Doc Comment
 *
 * @category Class
 * @package  Prestashop
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Product implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'product';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'id_manufacturer' => 'int',
        'id_supplier' => 'int',
        'id_category_default' => 'int',
        'cache_default_attribute' => 'int',
        'id_default_image' => 'int',
        'id_default_combination' => 'int',
        'id_tax_rules_group' => 'int',
        'position_in_category' => 'int',
        'manufacturer_name' => 'string',
        'type' => 'string',
        'id_shop_default' => 'int',
        'reference' => 'string',
        'width' => 'string',
        'height' => 'string',
        'depth' => 'string',
        'weight' => 'string',
        'state' => 'int',
        'additional_delivery_times' => 'int',
        'delivery_in_stock' => '\Prestashop\Model\ProductDeliveryInStockInner[]',
        'delivery_out_stock' => '\Prestashop\Model\ProductDeliveryInStockInner[]',
        'product_type' => 'string',
        'ecotax' => 'string',
        'minimal_quantity' => 'int',
        'price' => 'string',
        'wholesale_price' => 'string',
        'unit_price' => 'string',
        'unit_price_ratio' => 'string',
        'additional_shipping_cost' => 'string',
        'active' => 'string',
        'redirect_type' => 'string',
        'available_for_order' => 'string',
        'available_date' => 'string',
        'condition' => 'string',
        'show_price' => 'string',
        'indexed' => 'string',
        'visibility' => 'string',
        'date_add' => 'string',
        'date_upd' => 'string',
        'pack_stock_type' => 'int',
        'meta_description' => '\Prestashop\Model\Value[]',
        'meta_keywords' => '\Prestashop\Model\Value[]',
        'meta_title' => '\Prestashop\Model\Value[]',
        'link_rewrite' => '\Prestashop\Model\Value[]',
        'name' => '\Prestashop\Model\Value[]',
        'description' => '\Prestashop\Model\Value[]',
        'description_short' => '\Prestashop\Model\Value[]',
        'available_now' => '\Prestashop\Model\Value[]',
        'available_later' => '\Prestashop\Model\Value[]',
        'associations' => '\Prestashop\Model\ProductAssociations'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'id_manufacturer' => null,
        'id_supplier' => null,
        'id_category_default' => null,
        'cache_default_attribute' => null,
        'id_default_image' => null,
        'id_default_combination' => null,
        'id_tax_rules_group' => null,
        'position_in_category' => null,
        'manufacturer_name' => null,
        'type' => null,
        'id_shop_default' => null,
        'reference' => null,
        'width' => null,
        'height' => null,
        'depth' => null,
        'weight' => null,
        'state' => null,
        'additional_delivery_times' => null,
        'delivery_in_stock' => null,
        'delivery_out_stock' => null,
        'product_type' => null,
        'ecotax' => null,
        'minimal_quantity' => null,
        'price' => null,
        'wholesale_price' => null,
        'unit_price' => null,
        'unit_price_ratio' => null,
        'additional_shipping_cost' => null,
        'active' => null,
        'redirect_type' => null,
        'available_for_order' => null,
        'available_date' => null,
        'condition' => null,
        'show_price' => null,
        'indexed' => null,
        'visibility' => null,
        'date_add' => null,
        'date_upd' => null,
        'pack_stock_type' => null,
        'meta_description' => null,
        'meta_keywords' => null,
        'meta_title' => null,
        'link_rewrite' => null,
        'name' => null,
        'description' => null,
        'description_short' => null,
        'available_now' => null,
        'available_later' => null,
        'associations' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
		'id_manufacturer' => false,
		'id_supplier' => false,
		'id_category_default' => false,
		'cache_default_attribute' => false,
		'id_default_image' => false,
		'id_default_combination' => false,
		'id_tax_rules_group' => false,
		'position_in_category' => false,
		'manufacturer_name' => false,
		'type' => false,
		'id_shop_default' => false,
		'reference' => false,
		'width' => false,
		'height' => false,
		'depth' => false,
		'weight' => false,
		'state' => false,
		'additional_delivery_times' => false,
		'delivery_in_stock' => false,
		'delivery_out_stock' => false,
		'product_type' => false,
		'ecotax' => false,
		'minimal_quantity' => false,
		'price' => false,
		'wholesale_price' => false,
		'unit_price' => false,
		'unit_price_ratio' => false,
		'additional_shipping_cost' => false,
		'active' => false,
		'redirect_type' => false,
		'available_for_order' => false,
		'available_date' => false,
		'condition' => false,
		'show_price' => false,
		'indexed' => false,
		'visibility' => false,
		'date_add' => false,
		'date_upd' => false,
		'pack_stock_type' => false,
		'meta_description' => false,
		'meta_keywords' => false,
		'meta_title' => false,
		'link_rewrite' => false,
		'name' => false,
		'description' => false,
		'description_short' => false,
		'available_now' => false,
		'available_later' => false,
		'associations' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'id_manufacturer' => 'id_manufacturer',
        'id_supplier' => 'id_supplier',
        'id_category_default' => 'id_category_default',
        'cache_default_attribute' => 'cache_default_attribute',
        'id_default_image' => 'id_default_image',
        'id_default_combination' => 'id_default_combination',
        'id_tax_rules_group' => 'id_tax_rules_group',
        'position_in_category' => 'position_in_category',
        'manufacturer_name' => 'manufacturer_name',
        'type' => 'type',
        'id_shop_default' => 'id_shop_default',
        'reference' => 'reference',
        'width' => 'width',
        'height' => 'height',
        'depth' => 'depth',
        'weight' => 'weight',
        'state' => 'state',
        'additional_delivery_times' => 'additional_delivery_times',
        'delivery_in_stock' => 'delivery_in_stock',
        'delivery_out_stock' => 'delivery_out_stock',
        'product_type' => 'product_type',
        'ecotax' => 'ecotax',
        'minimal_quantity' => 'minimal_quantity',
        'price' => 'price',
        'wholesale_price' => 'wholesale_price',
        'unit_price' => 'unit_price',
        'unit_price_ratio' => 'unit_price_ratio',
        'additional_shipping_cost' => 'additional_shipping_cost',
        'active' => 'active',
        'redirect_type' => 'redirect_type',
        'available_for_order' => 'available_for_order',
        'available_date' => 'available_date',
        'condition' => 'condition',
        'show_price' => 'show_price',
        'indexed' => 'indexed',
        'visibility' => 'visibility',
        'date_add' => 'date_add',
        'date_upd' => 'date_upd',
        'pack_stock_type' => 'pack_stock_type',
        'meta_description' => 'meta_description',
        'meta_keywords' => 'meta_keywords',
        'meta_title' => 'meta_title',
        'link_rewrite' => 'link_rewrite',
        'name' => 'name',
        'description' => 'description',
        'description_short' => 'description_short',
        'available_now' => 'available_now',
        'available_later' => 'available_later',
        'associations' => 'associations'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'id_manufacturer' => 'setIdManufacturer',
        'id_supplier' => 'setIdSupplier',
        'id_category_default' => 'setIdCategoryDefault',
        'cache_default_attribute' => 'setCacheDefaultAttribute',
        'id_default_image' => 'setIdDefaultImage',
        'id_default_combination' => 'setIdDefaultCombination',
        'id_tax_rules_group' => 'setIdTaxRulesGroup',
        'position_in_category' => 'setPositionInCategory',
        'manufacturer_name' => 'setManufacturerName',
        'type' => 'setType',
        'id_shop_default' => 'setIdShopDefault',
        'reference' => 'setReference',
        'width' => 'setWidth',
        'height' => 'setHeight',
        'depth' => 'setDepth',
        'weight' => 'setWeight',
        'state' => 'setState',
        'additional_delivery_times' => 'setAdditionalDeliveryTimes',
        'delivery_in_stock' => 'setDeliveryInStock',
        'delivery_out_stock' => 'setDeliveryOutStock',
        'product_type' => 'setProductType',
        'ecotax' => 'setEcotax',
        'minimal_quantity' => 'setMinimalQuantity',
        'price' => 'setPrice',
        'wholesale_price' => 'setWholesalePrice',
        'unit_price' => 'setUnitPrice',
        'unit_price_ratio' => 'setUnitPriceRatio',
        'additional_shipping_cost' => 'setAdditionalShippingCost',
        'active' => 'setActive',
        'redirect_type' => 'setRedirectType',
        'available_for_order' => 'setAvailableForOrder',
        'available_date' => 'setAvailableDate',
        'condition' => 'setCondition',
        'show_price' => 'setShowPrice',
        'indexed' => 'setIndexed',
        'visibility' => 'setVisibility',
        'date_add' => 'setDateAdd',
        'date_upd' => 'setDateUpd',
        'pack_stock_type' => 'setPackStockType',
        'meta_description' => 'setMetaDescription',
        'meta_keywords' => 'setMetaKeywords',
        'meta_title' => 'setMetaTitle',
        'link_rewrite' => 'setLinkRewrite',
        'name' => 'setName',
        'description' => 'setDescription',
        'description_short' => 'setDescriptionShort',
        'available_now' => 'setAvailableNow',
        'available_later' => 'setAvailableLater',
        'associations' => 'setAssociations'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'id_manufacturer' => 'getIdManufacturer',
        'id_supplier' => 'getIdSupplier',
        'id_category_default' => 'getIdCategoryDefault',
        'cache_default_attribute' => 'getCacheDefaultAttribute',
        'id_default_image' => 'getIdDefaultImage',
        'id_default_combination' => 'getIdDefaultCombination',
        'id_tax_rules_group' => 'getIdTaxRulesGroup',
        'position_in_category' => 'getPositionInCategory',
        'manufacturer_name' => 'getManufacturerName',
        'type' => 'getType',
        'id_shop_default' => 'getIdShopDefault',
        'reference' => 'getReference',
        'width' => 'getWidth',
        'height' => 'getHeight',
        'depth' => 'getDepth',
        'weight' => 'getWeight',
        'state' => 'getState',
        'additional_delivery_times' => 'getAdditionalDeliveryTimes',
        'delivery_in_stock' => 'getDeliveryInStock',
        'delivery_out_stock' => 'getDeliveryOutStock',
        'product_type' => 'getProductType',
        'ecotax' => 'getEcotax',
        'minimal_quantity' => 'getMinimalQuantity',
        'price' => 'getPrice',
        'wholesale_price' => 'getWholesalePrice',
        'unit_price' => 'getUnitPrice',
        'unit_price_ratio' => 'getUnitPriceRatio',
        'additional_shipping_cost' => 'getAdditionalShippingCost',
        'active' => 'getActive',
        'redirect_type' => 'getRedirectType',
        'available_for_order' => 'getAvailableForOrder',
        'available_date' => 'getAvailableDate',
        'condition' => 'getCondition',
        'show_price' => 'getShowPrice',
        'indexed' => 'getIndexed',
        'visibility' => 'getVisibility',
        'date_add' => 'getDateAdd',
        'date_upd' => 'getDateUpd',
        'pack_stock_type' => 'getPackStockType',
        'meta_description' => 'getMetaDescription',
        'meta_keywords' => 'getMetaKeywords',
        'meta_title' => 'getMetaTitle',
        'link_rewrite' => 'getLinkRewrite',
        'name' => 'getName',
        'description' => 'getDescription',
        'description_short' => 'getDescriptionShort',
        'available_now' => 'getAvailableNow',
        'available_later' => 'getAvailableLater',
        'associations' => 'getAssociations'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('id_manufacturer', $data ?? [], null);
        $this->setIfExists('id_supplier', $data ?? [], null);
        $this->setIfExists('id_category_default', $data ?? [], null);
        $this->setIfExists('cache_default_attribute', $data ?? [], null);
        $this->setIfExists('id_default_image', $data ?? [], null);
        $this->setIfExists('id_default_combination', $data ?? [], null);
        $this->setIfExists('id_tax_rules_group', $data ?? [], null);
        $this->setIfExists('position_in_category', $data ?? [], null);
        $this->setIfExists('manufacturer_name', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('id_shop_default', $data ?? [], null);
        $this->setIfExists('reference', $data ?? [], null);
        $this->setIfExists('width', $data ?? [], null);
        $this->setIfExists('height', $data ?? [], null);
        $this->setIfExists('depth', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('state', $data ?? [], null);
        $this->setIfExists('additional_delivery_times', $data ?? [], null);
        $this->setIfExists('delivery_in_stock', $data ?? [], null);
        $this->setIfExists('delivery_out_stock', $data ?? [], null);
        $this->setIfExists('product_type', $data ?? [], null);
        $this->setIfExists('ecotax', $data ?? [], null);
        $this->setIfExists('minimal_quantity', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('wholesale_price', $data ?? [], null);
        $this->setIfExists('unit_price', $data ?? [], null);
        $this->setIfExists('unit_price_ratio', $data ?? [], null);
        $this->setIfExists('additional_shipping_cost', $data ?? [], null);
        $this->setIfExists('active', $data ?? [], null);
        $this->setIfExists('redirect_type', $data ?? [], null);
        $this->setIfExists('available_for_order', $data ?? [], null);
        $this->setIfExists('available_date', $data ?? [], null);
        $this->setIfExists('condition', $data ?? [], null);
        $this->setIfExists('show_price', $data ?? [], null);
        $this->setIfExists('indexed', $data ?? [], null);
        $this->setIfExists('visibility', $data ?? [], null);
        $this->setIfExists('date_add', $data ?? [], null);
        $this->setIfExists('date_upd', $data ?? [], null);
        $this->setIfExists('pack_stock_type', $data ?? [], null);
        $this->setIfExists('meta_description', $data ?? [], null);
        $this->setIfExists('meta_keywords', $data ?? [], null);
        $this->setIfExists('meta_title', $data ?? [], null);
        $this->setIfExists('link_rewrite', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('description_short', $data ?? [], null);
        $this->setIfExists('available_now', $data ?? [], null);
        $this->setIfExists('available_later', $data ?? [], null);
        $this->setIfExists('associations', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets id_manufacturer
     *
     * @return int|null
     */
    public function getIdManufacturer()
    {
        return $this->container['id_manufacturer'];
    }

    /**
     * Sets id_manufacturer
     *
     * @param int|null $id_manufacturer id_manufacturer
     *
     * @return self
     */
    public function setIdManufacturer($id_manufacturer)
    {
        if (is_null($id_manufacturer)) {
            throw new \InvalidArgumentException('non-nullable id_manufacturer cannot be null');
        }
        $this->container['id_manufacturer'] = $id_manufacturer;

        return $this;
    }

    /**
     * Gets id_supplier
     *
     * @return int|null
     */
    public function getIdSupplier()
    {
        return $this->container['id_supplier'];
    }

    /**
     * Sets id_supplier
     *
     * @param int|null $id_supplier id_supplier
     *
     * @return self
     */
    public function setIdSupplier($id_supplier)
    {
        if (is_null($id_supplier)) {
            throw new \InvalidArgumentException('non-nullable id_supplier cannot be null');
        }
        $this->container['id_supplier'] = $id_supplier;

        return $this;
    }

    /**
     * Gets id_category_default
     *
     * @return int|null
     */
    public function getIdCategoryDefault()
    {
        return $this->container['id_category_default'];
    }

    /**
     * Sets id_category_default
     *
     * @param int|null $id_category_default id_category_default
     *
     * @return self
     */
    public function setIdCategoryDefault($id_category_default)
    {
        if (is_null($id_category_default)) {
            throw new \InvalidArgumentException('non-nullable id_category_default cannot be null');
        }
        $this->container['id_category_default'] = $id_category_default;

        return $this;
    }

    /**
     * Gets cache_default_attribute
     *
     * @return int|null
     */
    public function getCacheDefaultAttribute()
    {
        return $this->container['cache_default_attribute'];
    }

    /**
     * Sets cache_default_attribute
     *
     * @param int|null $cache_default_attribute cache_default_attribute
     *
     * @return self
     */
    public function setCacheDefaultAttribute($cache_default_attribute)
    {
        if (is_null($cache_default_attribute)) {
            throw new \InvalidArgumentException('non-nullable cache_default_attribute cannot be null');
        }
        $this->container['cache_default_attribute'] = $cache_default_attribute;

        return $this;
    }

    /**
     * Gets id_default_image
     *
     * @return int|null
     */
    public function getIdDefaultImage()
    {
        return $this->container['id_default_image'];
    }

    /**
     * Sets id_default_image
     *
     * @param int|null $id_default_image id_default_image
     *
     * @return self
     */
    public function setIdDefaultImage($id_default_image)
    {
        if (is_null($id_default_image)) {
            throw new \InvalidArgumentException('non-nullable id_default_image cannot be null');
        }
        $this->container['id_default_image'] = $id_default_image;

        return $this;
    }

    /**
     * Gets id_default_combination
     *
     * @return int|null
     */
    public function getIdDefaultCombination()
    {
        return $this->container['id_default_combination'];
    }

    /**
     * Sets id_default_combination
     *
     * @param int|null $id_default_combination id_default_combination
     *
     * @return self
     */
    public function setIdDefaultCombination($id_default_combination)
    {
        if (is_null($id_default_combination)) {
            throw new \InvalidArgumentException('non-nullable id_default_combination cannot be null');
        }
        $this->container['id_default_combination'] = $id_default_combination;

        return $this;
    }

    /**
     * Gets id_tax_rules_group
     *
     * @return int|null
     */
    public function getIdTaxRulesGroup()
    {
        return $this->container['id_tax_rules_group'];
    }

    /**
     * Sets id_tax_rules_group
     *
     * @param int|null $id_tax_rules_group id_tax_rules_group
     *
     * @return self
     */
    public function setIdTaxRulesGroup($id_tax_rules_group)
    {
        if (is_null($id_tax_rules_group)) {
            throw new \InvalidArgumentException('non-nullable id_tax_rules_group cannot be null');
        }
        $this->container['id_tax_rules_group'] = $id_tax_rules_group;

        return $this;
    }

    /**
     * Gets position_in_category
     *
     * @return int|null
     */
    public function getPositionInCategory()
    {
        return $this->container['position_in_category'];
    }

    /**
     * Sets position_in_category
     *
     * @param int|null $position_in_category position_in_category
     *
     * @return self
     */
    public function setPositionInCategory($position_in_category)
    {
        if (is_null($position_in_category)) {
            throw new \InvalidArgumentException('non-nullable position_in_category cannot be null');
        }
        $this->container['position_in_category'] = $position_in_category;

        return $this;
    }

    /**
     * Gets manufacturer_name
     *
     * @return string|null
     */
    public function getManufacturerName()
    {
        return $this->container['manufacturer_name'];
    }

    /**
     * Sets manufacturer_name
     *
     * @param string|null $manufacturer_name manufacturer_name
     *
     * @return self
     */
    public function setManufacturerName($manufacturer_name)
    {
        if (is_null($manufacturer_name)) {
            throw new \InvalidArgumentException('non-nullable manufacturer_name cannot be null');
        }
        $this->container['manufacturer_name'] = $manufacturer_name;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets id_shop_default
     *
     * @return int|null
     */
    public function getIdShopDefault()
    {
        return $this->container['id_shop_default'];
    }

    /**
     * Sets id_shop_default
     *
     * @param int|null $id_shop_default id_shop_default
     *
     * @return self
     */
    public function setIdShopDefault($id_shop_default)
    {
        if (is_null($id_shop_default)) {
            throw new \InvalidArgumentException('non-nullable id_shop_default cannot be null');
        }
        $this->container['id_shop_default'] = $id_shop_default;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference reference
     *
     * @return self
     */
    public function setReference($reference)
    {
        if (is_null($reference)) {
            throw new \InvalidArgumentException('non-nullable reference cannot be null');
        }
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets width
     *
     * @return string|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param string|null $width width
     *
     * @return self
     */
    public function setWidth($width)
    {
        if (is_null($width)) {
            throw new \InvalidArgumentException('non-nullable width cannot be null');
        }
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets height
     *
     * @return string|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param string|null $height height
     *
     * @return self
     */
    public function setHeight($height)
    {
        if (is_null($height)) {
            throw new \InvalidArgumentException('non-nullable height cannot be null');
        }
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets depth
     *
     * @return string|null
     */
    public function getDepth()
    {
        return $this->container['depth'];
    }

    /**
     * Sets depth
     *
     * @param string|null $depth depth
     *
     * @return self
     */
    public function setDepth($depth)
    {
        if (is_null($depth)) {
            throw new \InvalidArgumentException('non-nullable depth cannot be null');
        }
        $this->container['depth'] = $depth;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return string|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param string|null $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets state
     *
     * @return int|null
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     *
     * @param int|null $state state
     *
     * @return self
     */
    public function setState($state)
    {
        if (is_null($state)) {
            throw new \InvalidArgumentException('non-nullable state cannot be null');
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets additional_delivery_times
     *
     * @return int|null
     */
    public function getAdditionalDeliveryTimes()
    {
        return $this->container['additional_delivery_times'];
    }

    /**
     * Sets additional_delivery_times
     *
     * @param int|null $additional_delivery_times additional_delivery_times
     *
     * @return self
     */
    public function setAdditionalDeliveryTimes($additional_delivery_times)
    {
        if (is_null($additional_delivery_times)) {
            throw new \InvalidArgumentException('non-nullable additional_delivery_times cannot be null');
        }
        $this->container['additional_delivery_times'] = $additional_delivery_times;

        return $this;
    }

    /**
     * Gets delivery_in_stock
     *
     * @return \Prestashop\Model\ProductDeliveryInStockInner[]|null
     */
    public function getDeliveryInStock()
    {
        return $this->container['delivery_in_stock'];
    }

    /**
     * Sets delivery_in_stock
     *
     * @param \Prestashop\Model\ProductDeliveryInStockInner[]|null $delivery_in_stock delivery_in_stock
     *
     * @return self
     */
    public function setDeliveryInStock($delivery_in_stock)
    {
        if (is_null($delivery_in_stock)) {
            throw new \InvalidArgumentException('non-nullable delivery_in_stock cannot be null');
        }
        $this->container['delivery_in_stock'] = $delivery_in_stock;

        return $this;
    }

    /**
     * Gets delivery_out_stock
     *
     * @return \Prestashop\Model\ProductDeliveryInStockInner[]|null
     */
    public function getDeliveryOutStock()
    {
        return $this->container['delivery_out_stock'];
    }

    /**
     * Sets delivery_out_stock
     *
     * @param \Prestashop\Model\ProductDeliveryInStockInner[]|null $delivery_out_stock delivery_out_stock
     *
     * @return self
     */
    public function setDeliveryOutStock($delivery_out_stock)
    {
        if (is_null($delivery_out_stock)) {
            throw new \InvalidArgumentException('non-nullable delivery_out_stock cannot be null');
        }
        $this->container['delivery_out_stock'] = $delivery_out_stock;

        return $this;
    }

    /**
     * Gets product_type
     *
     * @return string|null
     */
    public function getProductType()
    {
        return $this->container['product_type'];
    }

    /**
     * Sets product_type
     *
     * @param string|null $product_type product_type
     *
     * @return self
     */
    public function setProductType($product_type)
    {
        if (is_null($product_type)) {
            throw new \InvalidArgumentException('non-nullable product_type cannot be null');
        }
        $this->container['product_type'] = $product_type;

        return $this;
    }

    /**
     * Gets ecotax
     *
     * @return string|null
     */
    public function getEcotax()
    {
        return $this->container['ecotax'];
    }

    /**
     * Sets ecotax
     *
     * @param string|null $ecotax ecotax
     *
     * @return self
     */
    public function setEcotax($ecotax)
    {
        if (is_null($ecotax)) {
            throw new \InvalidArgumentException('non-nullable ecotax cannot be null');
        }
        $this->container['ecotax'] = $ecotax;

        return $this;
    }

    /**
     * Gets minimal_quantity
     *
     * @return int|null
     */
    public function getMinimalQuantity()
    {
        return $this->container['minimal_quantity'];
    }

    /**
     * Sets minimal_quantity
     *
     * @param int|null $minimal_quantity minimal_quantity
     *
     * @return self
     */
    public function setMinimalQuantity($minimal_quantity)
    {
        if (is_null($minimal_quantity)) {
            throw new \InvalidArgumentException('non-nullable minimal_quantity cannot be null');
        }
        $this->container['minimal_quantity'] = $minimal_quantity;

        return $this;
    }

    /**
     * Gets price
     *
     * @return string|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param string|null $price price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets wholesale_price
     *
     * @return string|null
     */
    public function getWholesalePrice()
    {
        return $this->container['wholesale_price'];
    }

    /**
     * Sets wholesale_price
     *
     * @param string|null $wholesale_price wholesale_price
     *
     * @return self
     */
    public function setWholesalePrice($wholesale_price)
    {
        if (is_null($wholesale_price)) {
            throw new \InvalidArgumentException('non-nullable wholesale_price cannot be null');
        }
        $this->container['wholesale_price'] = $wholesale_price;

        return $this;
    }

    /**
     * Gets unit_price
     *
     * @return string|null
     */
    public function getUnitPrice()
    {
        return $this->container['unit_price'];
    }

    /**
     * Sets unit_price
     *
     * @param string|null $unit_price unit_price
     *
     * @return self
     */
    public function setUnitPrice($unit_price)
    {
        if (is_null($unit_price)) {
            throw new \InvalidArgumentException('non-nullable unit_price cannot be null');
        }
        $this->container['unit_price'] = $unit_price;

        return $this;
    }

    /**
     * Gets unit_price_ratio
     *
     * @return string|null
     */
    public function getUnitPriceRatio()
    {
        return $this->container['unit_price_ratio'];
    }

    /**
     * Sets unit_price_ratio
     *
     * @param string|null $unit_price_ratio unit_price_ratio
     *
     * @return self
     */
    public function setUnitPriceRatio($unit_price_ratio)
    {
        if (is_null($unit_price_ratio)) {
            throw new \InvalidArgumentException('non-nullable unit_price_ratio cannot be null');
        }
        $this->container['unit_price_ratio'] = $unit_price_ratio;

        return $this;
    }

    /**
     * Gets additional_shipping_cost
     *
     * @return string|null
     */
    public function getAdditionalShippingCost()
    {
        return $this->container['additional_shipping_cost'];
    }

    /**
     * Sets additional_shipping_cost
     *
     * @param string|null $additional_shipping_cost additional_shipping_cost
     *
     * @return self
     */
    public function setAdditionalShippingCost($additional_shipping_cost)
    {
        if (is_null($additional_shipping_cost)) {
            throw new \InvalidArgumentException('non-nullable additional_shipping_cost cannot be null');
        }
        $this->container['additional_shipping_cost'] = $additional_shipping_cost;

        return $this;
    }

    /**
     * Gets active
     *
     * @return string|null
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param string|null $active active
     *
     * @return self
     */
    public function setActive($active)
    {
        if (is_null($active)) {
            throw new \InvalidArgumentException('non-nullable active cannot be null');
        }
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets redirect_type
     *
     * @return string|null
     */
    public function getRedirectType()
    {
        return $this->container['redirect_type'];
    }

    /**
     * Sets redirect_type
     *
     * @param string|null $redirect_type redirect_type
     *
     * @return self
     */
    public function setRedirectType($redirect_type)
    {
        if (is_null($redirect_type)) {
            throw new \InvalidArgumentException('non-nullable redirect_type cannot be null');
        }
        $this->container['redirect_type'] = $redirect_type;

        return $this;
    }

    /**
     * Gets available_for_order
     *
     * @return string|null
     */
    public function getAvailableForOrder()
    {
        return $this->container['available_for_order'];
    }

    /**
     * Sets available_for_order
     *
     * @param string|null $available_for_order available_for_order
     *
     * @return self
     */
    public function setAvailableForOrder($available_for_order)
    {
        if (is_null($available_for_order)) {
            throw new \InvalidArgumentException('non-nullable available_for_order cannot be null');
        }
        $this->container['available_for_order'] = $available_for_order;

        return $this;
    }

    /**
     * Gets available_date
     *
     * @return string|null
     */
    public function getAvailableDate()
    {
        return $this->container['available_date'];
    }

    /**
     * Sets available_date
     *
     * @param string|null $available_date available_date
     *
     * @return self
     */
    public function setAvailableDate($available_date)
    {
        if (is_null($available_date)) {
            throw new \InvalidArgumentException('non-nullable available_date cannot be null');
        }
        $this->container['available_date'] = $available_date;

        return $this;
    }

    /**
     * Gets condition
     *
     * @return string|null
     */
    public function getCondition()
    {
        return $this->container['condition'];
    }

    /**
     * Sets condition
     *
     * @param string|null $condition condition
     *
     * @return self
     */
    public function setCondition($condition)
    {
        if (is_null($condition)) {
            throw new \InvalidArgumentException('non-nullable condition cannot be null');
        }
        $this->container['condition'] = $condition;

        return $this;
    }

    /**
     * Gets show_price
     *
     * @return string|null
     */
    public function getShowPrice()
    {
        return $this->container['show_price'];
    }

    /**
     * Sets show_price
     *
     * @param string|null $show_price show_price
     *
     * @return self
     */
    public function setShowPrice($show_price)
    {
        if (is_null($show_price)) {
            throw new \InvalidArgumentException('non-nullable show_price cannot be null');
        }
        $this->container['show_price'] = $show_price;

        return $this;
    }

    /**
     * Gets indexed
     *
     * @return string|null
     */
    public function getIndexed()
    {
        return $this->container['indexed'];
    }

    /**
     * Sets indexed
     *
     * @param string|null $indexed indexed
     *
     * @return self
     */
    public function setIndexed($indexed)
    {
        if (is_null($indexed)) {
            throw new \InvalidArgumentException('non-nullable indexed cannot be null');
        }
        $this->container['indexed'] = $indexed;

        return $this;
    }

    /**
     * Gets visibility
     *
     * @return string|null
     */
    public function getVisibility()
    {
        return $this->container['visibility'];
    }

    /**
     * Sets visibility
     *
     * @param string|null $visibility visibility
     *
     * @return self
     */
    public function setVisibility($visibility)
    {
        if (is_null($visibility)) {
            throw new \InvalidArgumentException('non-nullable visibility cannot be null');
        }
        $this->container['visibility'] = $visibility;

        return $this;
    }

    /**
     * Gets date_add
     *
     * @return string|null
     */
    public function getDateAdd()
    {
        return $this->container['date_add'];
    }

    /**
     * Sets date_add
     *
     * @param string|null $date_add date_add
     *
     * @return self
     */
    public function setDateAdd($date_add)
    {
        if (is_null($date_add)) {
            throw new \InvalidArgumentException('non-nullable date_add cannot be null');
        }
        $this->container['date_add'] = $date_add;

        return $this;
    }

    /**
     * Gets date_upd
     *
     * @return string|null
     */
    public function getDateUpd()
    {
        return $this->container['date_upd'];
    }

    /**
     * Sets date_upd
     *
     * @param string|null $date_upd date_upd
     *
     * @return self
     */
    public function setDateUpd($date_upd)
    {
        if (is_null($date_upd)) {
            throw new \InvalidArgumentException('non-nullable date_upd cannot be null');
        }
        $this->container['date_upd'] = $date_upd;

        return $this;
    }

    /**
     * Gets pack_stock_type
     *
     * @return int|null
     */
    public function getPackStockType()
    {
        return $this->container['pack_stock_type'];
    }

    /**
     * Sets pack_stock_type
     *
     * @param int|null $pack_stock_type pack_stock_type
     *
     * @return self
     */
    public function setPackStockType($pack_stock_type)
    {
        if (is_null($pack_stock_type)) {
            throw new \InvalidArgumentException('non-nullable pack_stock_type cannot be null');
        }
        $this->container['pack_stock_type'] = $pack_stock_type;

        return $this;
    }

    /**
     * Gets meta_description
     *
     * @return \Prestashop\Model\Value[]|null
     */
    public function getMetaDescription()
    {
        return $this->container['meta_description'];
    }

    /**
     * Sets meta_description
     *
     * @param \Prestashop\Model\Value[]|null $meta_description meta_description
     *
     * @return self
     */
    public function setMetaDescription($meta_description)
    {
        if (is_null($meta_description)) {
            throw new \InvalidArgumentException('non-nullable meta_description cannot be null');
        }
        $this->container['meta_description'] = $meta_description;

        return $this;
    }

    /**
     * Gets meta_keywords
     *
     * @return \Prestashop\Model\Value[]|null
     */
    public function getMetaKeywords()
    {
        return $this->container['meta_keywords'];
    }

    /**
     * Sets meta_keywords
     *
     * @param \Prestashop\Model\Value[]|null $meta_keywords meta_keywords
     *
     * @return self
     */
    public function setMetaKeywords($meta_keywords)
    {
        if (is_null($meta_keywords)) {
            throw new \InvalidArgumentException('non-nullable meta_keywords cannot be null');
        }
        $this->container['meta_keywords'] = $meta_keywords;

        return $this;
    }

    /**
     * Gets meta_title
     *
     * @return \Prestashop\Model\Value[]|null
     */
    public function getMetaTitle()
    {
        return $this->container['meta_title'];
    }

    /**
     * Sets meta_title
     *
     * @param \Prestashop\Model\Value[]|null $meta_title meta_title
     *
     * @return self
     */
    public function setMetaTitle($meta_title)
    {
        if (is_null($meta_title)) {
            throw new \InvalidArgumentException('non-nullable meta_title cannot be null');
        }
        $this->container['meta_title'] = $meta_title;

        return $this;
    }

    /**
     * Gets link_rewrite
     *
     * @return \Prestashop\Model\Value[]|null
     */
    public function getLinkRewrite()
    {
        return $this->container['link_rewrite'];
    }

    /**
     * Sets link_rewrite
     *
     * @param \Prestashop\Model\Value[]|null $link_rewrite link_rewrite
     *
     * @return self
     */
    public function setLinkRewrite($link_rewrite)
    {
        if (is_null($link_rewrite)) {
            throw new \InvalidArgumentException('non-nullable link_rewrite cannot be null');
        }
        $this->container['link_rewrite'] = $link_rewrite;

        return $this;
    }

    /**
     * Gets name
     *
     * @return \Prestashop\Model\Value[]|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param \Prestashop\Model\Value[]|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return \Prestashop\Model\Value[]|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param \Prestashop\Model\Value[]|null $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets description_short
     *
     * @return \Prestashop\Model\Value[]|null
     */
    public function getDescriptionShort()
    {
        return $this->container['description_short'];
    }

    /**
     * Sets description_short
     *
     * @param \Prestashop\Model\Value[]|null $description_short description_short
     *
     * @return self
     */
    public function setDescriptionShort($description_short)
    {
        if (is_null($description_short)) {
            throw new \InvalidArgumentException('non-nullable description_short cannot be null');
        }
        $this->container['description_short'] = $description_short;

        return $this;
    }

    /**
     * Gets available_now
     *
     * @return \Prestashop\Model\Value[]|null
     */
    public function getAvailableNow()
    {
        return $this->container['available_now'];
    }

    /**
     * Sets available_now
     *
     * @param \Prestashop\Model\Value[]|null $available_now available_now
     *
     * @return self
     */
    public function setAvailableNow($available_now)
    {
        if (is_null($available_now)) {
            throw new \InvalidArgumentException('non-nullable available_now cannot be null');
        }
        $this->container['available_now'] = $available_now;

        return $this;
    }

    /**
     * Gets available_later
     *
     * @return \Prestashop\Model\Value[]|null
     */
    public function getAvailableLater()
    {
        return $this->container['available_later'];
    }

    /**
     * Sets available_later
     *
     * @param \Prestashop\Model\Value[]|null $available_later available_later
     *
     * @return self
     */
    public function setAvailableLater($available_later)
    {
        if (is_null($available_later)) {
            throw new \InvalidArgumentException('non-nullable available_later cannot be null');
        }
        $this->container['available_later'] = $available_later;

        return $this;
    }

    /**
     * Gets associations
     *
     * @return \Prestashop\Model\ProductAssociations|null
     */
    public function getAssociations()
    {
        return $this->container['associations'];
    }

    /**
     * Sets associations
     *
     * @param \Prestashop\Model\ProductAssociations|null $associations associations
     *
     * @return self
     */
    public function setAssociations($associations)
    {
        if (is_null($associations)) {
            throw new \InvalidArgumentException('non-nullable associations cannot be null');
        }
        $this->container['associations'] = $associations;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


