<?php
/**
 * OrderRow
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Prestashop
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * prestashop
 *
 * https://devdocs.prestashop-project.org/8/webservice/
 *
 * The version of the OpenAPI document: 1.0
 * Contact: admin@tideconnetcs.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Prestashop\Model;

use \ArrayAccess;
use \Prestashop\ObjectSerializer;

/**
 * OrderRow Class Doc Comment
 *
 * @category Class
 * @package  Prestashop
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderRow implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'order_row';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'product_id' => 'int',
        'product_attribute_id' => 'int',
        'product_quantity' => 'int',
        'product_name' => 'string',
        'product_reference' => 'string',
        'product_ean13' => 'string',
        'product_isbn' => 'string',
        'product_upc' => 'string',
        'product_price' => 'string',
        'id_customization' => 'int',
        'unit_price_tax_incl' => 'string',
        'unit_price_tax_excl' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'product_id' => null,
        'product_attribute_id' => null,
        'product_quantity' => null,
        'product_name' => null,
        'product_reference' => null,
        'product_ean13' => null,
        'product_isbn' => null,
        'product_upc' => null,
        'product_price' => null,
        'id_customization' => null,
        'unit_price_tax_incl' => null,
        'unit_price_tax_excl' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
		'product_id' => false,
		'product_attribute_id' => false,
		'product_quantity' => false,
		'product_name' => false,
		'product_reference' => false,
		'product_ean13' => false,
		'product_isbn' => false,
		'product_upc' => false,
		'product_price' => false,
		'id_customization' => false,
		'unit_price_tax_incl' => false,
		'unit_price_tax_excl' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'product_id' => 'product_id',
        'product_attribute_id' => 'product_attribute_id',
        'product_quantity' => 'product_quantity',
        'product_name' => 'product_name',
        'product_reference' => 'product_reference',
        'product_ean13' => 'product_ean13',
        'product_isbn' => 'product_isbn',
        'product_upc' => 'product_upc',
        'product_price' => 'product_price',
        'id_customization' => 'id_customization',
        'unit_price_tax_incl' => 'unit_price_tax_incl',
        'unit_price_tax_excl' => 'unit_price_tax_excl'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'product_id' => 'setProductId',
        'product_attribute_id' => 'setProductAttributeId',
        'product_quantity' => 'setProductQuantity',
        'product_name' => 'setProductName',
        'product_reference' => 'setProductReference',
        'product_ean13' => 'setProductEan13',
        'product_isbn' => 'setProductIsbn',
        'product_upc' => 'setProductUpc',
        'product_price' => 'setProductPrice',
        'id_customization' => 'setIdCustomization',
        'unit_price_tax_incl' => 'setUnitPriceTaxIncl',
        'unit_price_tax_excl' => 'setUnitPriceTaxExcl'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'product_id' => 'getProductId',
        'product_attribute_id' => 'getProductAttributeId',
        'product_quantity' => 'getProductQuantity',
        'product_name' => 'getProductName',
        'product_reference' => 'getProductReference',
        'product_ean13' => 'getProductEan13',
        'product_isbn' => 'getProductIsbn',
        'product_upc' => 'getProductUpc',
        'product_price' => 'getProductPrice',
        'id_customization' => 'getIdCustomization',
        'unit_price_tax_incl' => 'getUnitPriceTaxIncl',
        'unit_price_tax_excl' => 'getUnitPriceTaxExcl'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('product_id', $data ?? [], null);
        $this->setIfExists('product_attribute_id', $data ?? [], null);
        $this->setIfExists('product_quantity', $data ?? [], null);
        $this->setIfExists('product_name', $data ?? [], null);
        $this->setIfExists('product_reference', $data ?? [], null);
        $this->setIfExists('product_ean13', $data ?? [], null);
        $this->setIfExists('product_isbn', $data ?? [], null);
        $this->setIfExists('product_upc', $data ?? [], null);
        $this->setIfExists('product_price', $data ?? [], null);
        $this->setIfExists('id_customization', $data ?? [], null);
        $this->setIfExists('unit_price_tax_incl', $data ?? [], null);
        $this->setIfExists('unit_price_tax_excl', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return int|null
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param int|null $product_id product_id
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        if (is_null($product_id)) {
            throw new \InvalidArgumentException('non-nullable product_id cannot be null');
        }
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets product_attribute_id
     *
     * @return int|null
     */
    public function getProductAttributeId()
    {
        return $this->container['product_attribute_id'];
    }

    /**
     * Sets product_attribute_id
     *
     * @param int|null $product_attribute_id product_attribute_id
     *
     * @return self
     */
    public function setProductAttributeId($product_attribute_id)
    {
        if (is_null($product_attribute_id)) {
            throw new \InvalidArgumentException('non-nullable product_attribute_id cannot be null');
        }
        $this->container['product_attribute_id'] = $product_attribute_id;

        return $this;
    }

    /**
     * Gets product_quantity
     *
     * @return int|null
     */
    public function getProductQuantity()
    {
        return $this->container['product_quantity'];
    }

    /**
     * Sets product_quantity
     *
     * @param int|null $product_quantity product_quantity
     *
     * @return self
     */
    public function setProductQuantity($product_quantity)
    {
        if (is_null($product_quantity)) {
            throw new \InvalidArgumentException('non-nullable product_quantity cannot be null');
        }
        $this->container['product_quantity'] = $product_quantity;

        return $this;
    }

    /**
     * Gets product_name
     *
     * @return string|null
     */
    public function getProductName()
    {
        return $this->container['product_name'];
    }

    /**
     * Sets product_name
     *
     * @param string|null $product_name product_name
     *
     * @return self
     */
    public function setProductName($product_name)
    {
        if (is_null($product_name)) {
            throw new \InvalidArgumentException('non-nullable product_name cannot be null');
        }
        $this->container['product_name'] = $product_name;

        return $this;
    }

    /**
     * Gets product_reference
     *
     * @return string|null
     */
    public function getProductReference()
    {
        return $this->container['product_reference'];
    }

    /**
     * Sets product_reference
     *
     * @param string|null $product_reference product_reference
     *
     * @return self
     */
    public function setProductReference($product_reference)
    {
        if (is_null($product_reference)) {
            throw new \InvalidArgumentException('non-nullable product_reference cannot be null');
        }
        $this->container['product_reference'] = $product_reference;

        return $this;
    }

    /**
     * Gets product_ean13
     *
     * @return string|null
     */
    public function getProductEan13()
    {
        return $this->container['product_ean13'];
    }

    /**
     * Sets product_ean13
     *
     * @param string|null $product_ean13 product_ean13
     *
     * @return self
     */
    public function setProductEan13($product_ean13)
    {
        if (is_null($product_ean13)) {
            throw new \InvalidArgumentException('non-nullable product_ean13 cannot be null');
        }
        $this->container['product_ean13'] = $product_ean13;

        return $this;
    }

    /**
     * Gets product_isbn
     *
     * @return string|null
     */
    public function getProductIsbn()
    {
        return $this->container['product_isbn'];
    }

    /**
     * Sets product_isbn
     *
     * @param string|null $product_isbn product_isbn
     *
     * @return self
     */
    public function setProductIsbn($product_isbn)
    {
        if (is_null($product_isbn)) {
            throw new \InvalidArgumentException('non-nullable product_isbn cannot be null');
        }
        $this->container['product_isbn'] = $product_isbn;

        return $this;
    }

    /**
     * Gets product_upc
     *
     * @return string|null
     */
    public function getProductUpc()
    {
        return $this->container['product_upc'];
    }

    /**
     * Sets product_upc
     *
     * @param string|null $product_upc product_upc
     *
     * @return self
     */
    public function setProductUpc($product_upc)
    {
        if (is_null($product_upc)) {
            throw new \InvalidArgumentException('non-nullable product_upc cannot be null');
        }
        $this->container['product_upc'] = $product_upc;

        return $this;
    }

    /**
     * Gets product_price
     *
     * @return string|null
     */
    public function getProductPrice()
    {
        return $this->container['product_price'];
    }

    /**
     * Sets product_price
     *
     * @param string|null $product_price product_price
     *
     * @return self
     */
    public function setProductPrice($product_price)
    {
        if (is_null($product_price)) {
            throw new \InvalidArgumentException('non-nullable product_price cannot be null');
        }
        $this->container['product_price'] = $product_price;

        return $this;
    }

    /**
     * Gets id_customization
     *
     * @return int|null
     */
    public function getIdCustomization()
    {
        return $this->container['id_customization'];
    }

    /**
     * Sets id_customization
     *
     * @param int|null $id_customization id_customization
     *
     * @return self
     */
    public function setIdCustomization($id_customization)
    {
        if (is_null($id_customization)) {
            throw new \InvalidArgumentException('non-nullable id_customization cannot be null');
        }
        $this->container['id_customization'] = $id_customization;

        return $this;
    }

    /**
     * Gets unit_price_tax_incl
     *
     * @return string|null
     */
    public function getUnitPriceTaxIncl()
    {
        return $this->container['unit_price_tax_incl'];
    }

    /**
     * Sets unit_price_tax_incl
     *
     * @param string|null $unit_price_tax_incl unit_price_tax_incl
     *
     * @return self
     */
    public function setUnitPriceTaxIncl($unit_price_tax_incl)
    {
        if (is_null($unit_price_tax_incl)) {
            throw new \InvalidArgumentException('non-nullable unit_price_tax_incl cannot be null');
        }
        $this->container['unit_price_tax_incl'] = $unit_price_tax_incl;

        return $this;
    }

    /**
     * Gets unit_price_tax_excl
     *
     * @return string|null
     */
    public function getUnitPriceTaxExcl()
    {
        return $this->container['unit_price_tax_excl'];
    }

    /**
     * Sets unit_price_tax_excl
     *
     * @param string|null $unit_price_tax_excl unit_price_tax_excl
     *
     * @return self
     */
    public function setUnitPriceTaxExcl($unit_price_tax_excl)
    {
        if (is_null($unit_price_tax_excl)) {
            throw new \InvalidArgumentException('non-nullable unit_price_tax_excl cannot be null');
        }
        $this->container['unit_price_tax_excl'] = $unit_price_tax_excl;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


