<?php
/**
 * Order
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Prestashop
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * prestashop
 *
 * https://devdocs.prestashop-project.org/8/webservice/
 *
 * The version of the OpenAPI document: 1.0
 * Contact: admin@tideconnetcs.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Prestashop\Model;

use \ArrayAccess;
use \Prestashop\ObjectSerializer;

/**
 * Order Class Doc Comment
 *
 * @category Class
 * @package  Prestashop
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Order implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'order';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'id_address_delivery' => 'int',
        'id_address_invoice' => 'int',
        'id_cart' => 'int',
        'id_currency' => 'int',
        'id_lang' => 'int',
        'id_customer' => 'int',
        'id_carrier' => 'int',
        'current_state' => 'int',
        'module' => 'string',
        'invoice_date' => 'string',
        'delivery_date' => 'string',
        'date_add' => 'string',
        'date_upd' => 'string',
        'note' => 'string',
        'id_shop_group' => 'int',
        'id_shop' => 'int',
        'secure_key' => 'string',
        'payment' => 'string',
        'total_discounts' => 'string',
        'total_discounts_tax_incl' => 'string',
        'total_discounts_tax_excl' => 'string',
        'total_paid' => 'string',
        'total_paid_tax_incl' => 'string',
        'total_paid_tax_excl' => 'string',
        'total_paid_real' => 'string',
        'total_products' => 'string',
        'total_products_wt' => 'string',
        'total_shipping' => 'string',
        'total_shipping_tax_incl' => 'string',
        'total_shipping_tax_excl' => 'string',
        'carrier_tax_rate' => 'string',
        'total_wrapping' => 'string',
        'total_wrapping_tax_incl' => 'string',
        'total_wrapping_tax_excl' => 'string',
        'conversion_rate' => 'string',
        'reference' => 'string',
        'associations' => '\Prestashop\Model\OrderAssociations'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'id_address_delivery' => null,
        'id_address_invoice' => null,
        'id_cart' => null,
        'id_currency' => null,
        'id_lang' => null,
        'id_customer' => null,
        'id_carrier' => null,
        'current_state' => null,
        'module' => null,
        'invoice_date' => null,
        'delivery_date' => null,
        'date_add' => null,
        'date_upd' => null,
        'note' => null,
        'id_shop_group' => null,
        'id_shop' => null,
        'secure_key' => null,
        'payment' => null,
        'total_discounts' => null,
        'total_discounts_tax_incl' => null,
        'total_discounts_tax_excl' => null,
        'total_paid' => null,
        'total_paid_tax_incl' => null,
        'total_paid_tax_excl' => null,
        'total_paid_real' => null,
        'total_products' => null,
        'total_products_wt' => null,
        'total_shipping' => null,
        'total_shipping_tax_incl' => null,
        'total_shipping_tax_excl' => null,
        'carrier_tax_rate' => null,
        'total_wrapping' => null,
        'total_wrapping_tax_incl' => null,
        'total_wrapping_tax_excl' => null,
        'conversion_rate' => null,
        'reference' => null,
        'associations' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
		'id_address_delivery' => false,
		'id_address_invoice' => false,
		'id_cart' => false,
		'id_currency' => false,
		'id_lang' => false,
		'id_customer' => false,
		'id_carrier' => false,
		'current_state' => false,
		'module' => false,
		'invoice_date' => false,
		'delivery_date' => false,
		'date_add' => false,
		'date_upd' => false,
		'note' => false,
		'id_shop_group' => false,
		'id_shop' => false,
		'secure_key' => false,
		'payment' => false,
		'total_discounts' => false,
		'total_discounts_tax_incl' => false,
		'total_discounts_tax_excl' => false,
		'total_paid' => false,
		'total_paid_tax_incl' => false,
		'total_paid_tax_excl' => false,
		'total_paid_real' => false,
		'total_products' => false,
		'total_products_wt' => false,
		'total_shipping' => false,
		'total_shipping_tax_incl' => false,
		'total_shipping_tax_excl' => false,
		'carrier_tax_rate' => false,
		'total_wrapping' => false,
		'total_wrapping_tax_incl' => false,
		'total_wrapping_tax_excl' => false,
		'conversion_rate' => false,
		'reference' => false,
		'associations' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'id_address_delivery' => 'id_address_delivery',
        'id_address_invoice' => 'id_address_invoice',
        'id_cart' => 'id_cart',
        'id_currency' => 'id_currency',
        'id_lang' => 'id_lang',
        'id_customer' => 'id_customer',
        'id_carrier' => 'id_carrier',
        'current_state' => 'current_state',
        'module' => 'module',
        'invoice_date' => 'invoice_date',
        'delivery_date' => 'delivery_date',
        'date_add' => 'date_add',
        'date_upd' => 'date_upd',
        'note' => 'note',
        'id_shop_group' => 'id_shop_group',
        'id_shop' => 'id_shop',
        'secure_key' => 'secure_key',
        'payment' => 'payment',
        'total_discounts' => 'total_discounts',
        'total_discounts_tax_incl' => 'total_discounts_tax_incl',
        'total_discounts_tax_excl' => 'total_discounts_tax_excl',
        'total_paid' => 'total_paid',
        'total_paid_tax_incl' => 'total_paid_tax_incl',
        'total_paid_tax_excl' => 'total_paid_tax_excl',
        'total_paid_real' => 'total_paid_real',
        'total_products' => 'total_products',
        'total_products_wt' => 'total_products_wt',
        'total_shipping' => 'total_shipping',
        'total_shipping_tax_incl' => 'total_shipping_tax_incl',
        'total_shipping_tax_excl' => 'total_shipping_tax_excl',
        'carrier_tax_rate' => 'carrier_tax_rate',
        'total_wrapping' => 'total_wrapping',
        'total_wrapping_tax_incl' => 'total_wrapping_tax_incl',
        'total_wrapping_tax_excl' => 'total_wrapping_tax_excl',
        'conversion_rate' => 'conversion_rate',
        'reference' => 'reference',
        'associations' => 'associations'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'id_address_delivery' => 'setIdAddressDelivery',
        'id_address_invoice' => 'setIdAddressInvoice',
        'id_cart' => 'setIdCart',
        'id_currency' => 'setIdCurrency',
        'id_lang' => 'setIdLang',
        'id_customer' => 'setIdCustomer',
        'id_carrier' => 'setIdCarrier',
        'current_state' => 'setCurrentState',
        'module' => 'setModule',
        'invoice_date' => 'setInvoiceDate',
        'delivery_date' => 'setDeliveryDate',
        'date_add' => 'setDateAdd',
        'date_upd' => 'setDateUpd',
        'note' => 'setNote',
        'id_shop_group' => 'setIdShopGroup',
        'id_shop' => 'setIdShop',
        'secure_key' => 'setSecureKey',
        'payment' => 'setPayment',
        'total_discounts' => 'setTotalDiscounts',
        'total_discounts_tax_incl' => 'setTotalDiscountsTaxIncl',
        'total_discounts_tax_excl' => 'setTotalDiscountsTaxExcl',
        'total_paid' => 'setTotalPaid',
        'total_paid_tax_incl' => 'setTotalPaidTaxIncl',
        'total_paid_tax_excl' => 'setTotalPaidTaxExcl',
        'total_paid_real' => 'setTotalPaidReal',
        'total_products' => 'setTotalProducts',
        'total_products_wt' => 'setTotalProductsWt',
        'total_shipping' => 'setTotalShipping',
        'total_shipping_tax_incl' => 'setTotalShippingTaxIncl',
        'total_shipping_tax_excl' => 'setTotalShippingTaxExcl',
        'carrier_tax_rate' => 'setCarrierTaxRate',
        'total_wrapping' => 'setTotalWrapping',
        'total_wrapping_tax_incl' => 'setTotalWrappingTaxIncl',
        'total_wrapping_tax_excl' => 'setTotalWrappingTaxExcl',
        'conversion_rate' => 'setConversionRate',
        'reference' => 'setReference',
        'associations' => 'setAssociations'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'id_address_delivery' => 'getIdAddressDelivery',
        'id_address_invoice' => 'getIdAddressInvoice',
        'id_cart' => 'getIdCart',
        'id_currency' => 'getIdCurrency',
        'id_lang' => 'getIdLang',
        'id_customer' => 'getIdCustomer',
        'id_carrier' => 'getIdCarrier',
        'current_state' => 'getCurrentState',
        'module' => 'getModule',
        'invoice_date' => 'getInvoiceDate',
        'delivery_date' => 'getDeliveryDate',
        'date_add' => 'getDateAdd',
        'date_upd' => 'getDateUpd',
        'note' => 'getNote',
        'id_shop_group' => 'getIdShopGroup',
        'id_shop' => 'getIdShop',
        'secure_key' => 'getSecureKey',
        'payment' => 'getPayment',
        'total_discounts' => 'getTotalDiscounts',
        'total_discounts_tax_incl' => 'getTotalDiscountsTaxIncl',
        'total_discounts_tax_excl' => 'getTotalDiscountsTaxExcl',
        'total_paid' => 'getTotalPaid',
        'total_paid_tax_incl' => 'getTotalPaidTaxIncl',
        'total_paid_tax_excl' => 'getTotalPaidTaxExcl',
        'total_paid_real' => 'getTotalPaidReal',
        'total_products' => 'getTotalProducts',
        'total_products_wt' => 'getTotalProductsWt',
        'total_shipping' => 'getTotalShipping',
        'total_shipping_tax_incl' => 'getTotalShippingTaxIncl',
        'total_shipping_tax_excl' => 'getTotalShippingTaxExcl',
        'carrier_tax_rate' => 'getCarrierTaxRate',
        'total_wrapping' => 'getTotalWrapping',
        'total_wrapping_tax_incl' => 'getTotalWrappingTaxIncl',
        'total_wrapping_tax_excl' => 'getTotalWrappingTaxExcl',
        'conversion_rate' => 'getConversionRate',
        'reference' => 'getReference',
        'associations' => 'getAssociations'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('id_address_delivery', $data ?? [], null);
        $this->setIfExists('id_address_invoice', $data ?? [], null);
        $this->setIfExists('id_cart', $data ?? [], null);
        $this->setIfExists('id_currency', $data ?? [], null);
        $this->setIfExists('id_lang', $data ?? [], null);
        $this->setIfExists('id_customer', $data ?? [], null);
        $this->setIfExists('id_carrier', $data ?? [], null);
        $this->setIfExists('current_state', $data ?? [], null);
        $this->setIfExists('module', $data ?? [], null);
        $this->setIfExists('invoice_date', $data ?? [], null);
        $this->setIfExists('delivery_date', $data ?? [], null);
        $this->setIfExists('date_add', $data ?? [], null);
        $this->setIfExists('date_upd', $data ?? [], null);
        $this->setIfExists('note', $data ?? [], null);
        $this->setIfExists('id_shop_group', $data ?? [], null);
        $this->setIfExists('id_shop', $data ?? [], null);
        $this->setIfExists('secure_key', $data ?? [], null);
        $this->setIfExists('payment', $data ?? [], null);
        $this->setIfExists('total_discounts', $data ?? [], null);
        $this->setIfExists('total_discounts_tax_incl', $data ?? [], null);
        $this->setIfExists('total_discounts_tax_excl', $data ?? [], null);
        $this->setIfExists('total_paid', $data ?? [], null);
        $this->setIfExists('total_paid_tax_incl', $data ?? [], null);
        $this->setIfExists('total_paid_tax_excl', $data ?? [], null);
        $this->setIfExists('total_paid_real', $data ?? [], null);
        $this->setIfExists('total_products', $data ?? [], null);
        $this->setIfExists('total_products_wt', $data ?? [], null);
        $this->setIfExists('total_shipping', $data ?? [], null);
        $this->setIfExists('total_shipping_tax_incl', $data ?? [], null);
        $this->setIfExists('total_shipping_tax_excl', $data ?? [], null);
        $this->setIfExists('carrier_tax_rate', $data ?? [], null);
        $this->setIfExists('total_wrapping', $data ?? [], null);
        $this->setIfExists('total_wrapping_tax_incl', $data ?? [], null);
        $this->setIfExists('total_wrapping_tax_excl', $data ?? [], null);
        $this->setIfExists('conversion_rate', $data ?? [], null);
        $this->setIfExists('reference', $data ?? [], null);
        $this->setIfExists('associations', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets id_address_delivery
     *
     * @return int|null
     */
    public function getIdAddressDelivery()
    {
        return $this->container['id_address_delivery'];
    }

    /**
     * Sets id_address_delivery
     *
     * @param int|null $id_address_delivery id_address_delivery
     *
     * @return self
     */
    public function setIdAddressDelivery($id_address_delivery)
    {
        if (is_null($id_address_delivery)) {
            throw new \InvalidArgumentException('non-nullable id_address_delivery cannot be null');
        }
        $this->container['id_address_delivery'] = $id_address_delivery;

        return $this;
    }

    /**
     * Gets id_address_invoice
     *
     * @return int|null
     */
    public function getIdAddressInvoice()
    {
        return $this->container['id_address_invoice'];
    }

    /**
     * Sets id_address_invoice
     *
     * @param int|null $id_address_invoice id_address_invoice
     *
     * @return self
     */
    public function setIdAddressInvoice($id_address_invoice)
    {
        if (is_null($id_address_invoice)) {
            throw new \InvalidArgumentException('non-nullable id_address_invoice cannot be null');
        }
        $this->container['id_address_invoice'] = $id_address_invoice;

        return $this;
    }

    /**
     * Gets id_cart
     *
     * @return int|null
     */
    public function getIdCart()
    {
        return $this->container['id_cart'];
    }

    /**
     * Sets id_cart
     *
     * @param int|null $id_cart id_cart
     *
     * @return self
     */
    public function setIdCart($id_cart)
    {
        if (is_null($id_cart)) {
            throw new \InvalidArgumentException('non-nullable id_cart cannot be null');
        }
        $this->container['id_cart'] = $id_cart;

        return $this;
    }

    /**
     * Gets id_currency
     *
     * @return int|null
     */
    public function getIdCurrency()
    {
        return $this->container['id_currency'];
    }

    /**
     * Sets id_currency
     *
     * @param int|null $id_currency id_currency
     *
     * @return self
     */
    public function setIdCurrency($id_currency)
    {
        if (is_null($id_currency)) {
            throw new \InvalidArgumentException('non-nullable id_currency cannot be null');
        }
        $this->container['id_currency'] = $id_currency;

        return $this;
    }

    /**
     * Gets id_lang
     *
     * @return int|null
     */
    public function getIdLang()
    {
        return $this->container['id_lang'];
    }

    /**
     * Sets id_lang
     *
     * @param int|null $id_lang id_lang
     *
     * @return self
     */
    public function setIdLang($id_lang)
    {
        if (is_null($id_lang)) {
            throw new \InvalidArgumentException('non-nullable id_lang cannot be null');
        }
        $this->container['id_lang'] = $id_lang;

        return $this;
    }

    /**
     * Gets id_customer
     *
     * @return int|null
     */
    public function getIdCustomer()
    {
        return $this->container['id_customer'];
    }

    /**
     * Sets id_customer
     *
     * @param int|null $id_customer id_customer
     *
     * @return self
     */
    public function setIdCustomer($id_customer)
    {
        if (is_null($id_customer)) {
            throw new \InvalidArgumentException('non-nullable id_customer cannot be null');
        }
        $this->container['id_customer'] = $id_customer;

        return $this;
    }

    /**
     * Gets id_carrier
     *
     * @return int|null
     */
    public function getIdCarrier()
    {
        return $this->container['id_carrier'];
    }

    /**
     * Sets id_carrier
     *
     * @param int|null $id_carrier id_carrier
     *
     * @return self
     */
    public function setIdCarrier($id_carrier)
    {
        if (is_null($id_carrier)) {
            throw new \InvalidArgumentException('non-nullable id_carrier cannot be null');
        }
        $this->container['id_carrier'] = $id_carrier;

        return $this;
    }

    /**
     * Gets current_state
     *
     * @return int|null
     */
    public function getCurrentState()
    {
        return $this->container['current_state'];
    }

    /**
     * Sets current_state
     *
     * @param int|null $current_state current_state
     *
     * @return self
     */
    public function setCurrentState($current_state)
    {
        if (is_null($current_state)) {
            throw new \InvalidArgumentException('non-nullable current_state cannot be null');
        }
        $this->container['current_state'] = $current_state;

        return $this;
    }

    /**
     * Gets module
     *
     * @return string|null
     */
    public function getModule()
    {
        return $this->container['module'];
    }

    /**
     * Sets module
     *
     * @param string|null $module module
     *
     * @return self
     */
    public function setModule($module)
    {
        if (is_null($module)) {
            throw new \InvalidArgumentException('non-nullable module cannot be null');
        }
        $this->container['module'] = $module;

        return $this;
    }

    /**
     * Gets invoice_date
     *
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->container['invoice_date'];
    }

    /**
     * Sets invoice_date
     *
     * @param string|null $invoice_date invoice_date
     *
     * @return self
     */
    public function setInvoiceDate($invoice_date)
    {
        if (is_null($invoice_date)) {
            throw new \InvalidArgumentException('non-nullable invoice_date cannot be null');
        }
        $this->container['invoice_date'] = $invoice_date;

        return $this;
    }

    /**
     * Gets delivery_date
     *
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->container['delivery_date'];
    }

    /**
     * Sets delivery_date
     *
     * @param string|null $delivery_date delivery_date
     *
     * @return self
     */
    public function setDeliveryDate($delivery_date)
    {
        if (is_null($delivery_date)) {
            throw new \InvalidArgumentException('non-nullable delivery_date cannot be null');
        }
        $this->container['delivery_date'] = $delivery_date;

        return $this;
    }

    /**
     * Gets date_add
     *
     * @return string|null
     */
    public function getDateAdd()
    {
        return $this->container['date_add'];
    }

    /**
     * Sets date_add
     *
     * @param string|null $date_add date_add
     *
     * @return self
     */
    public function setDateAdd($date_add)
    {
        if (is_null($date_add)) {
            throw new \InvalidArgumentException('non-nullable date_add cannot be null');
        }
        $this->container['date_add'] = $date_add;

        return $this;
    }

    /**
     * Gets date_upd
     *
     * @return string|null
     */
    public function getDateUpd()
    {
        return $this->container['date_upd'];
    }

    /**
     * Sets date_upd
     *
     * @param string|null $date_upd date_upd
     *
     * @return self
     */
    public function setDateUpd($date_upd)
    {
        if (is_null($date_upd)) {
            throw new \InvalidArgumentException('non-nullable date_upd cannot be null');
        }
        $this->container['date_upd'] = $date_upd;

        return $this;
    }

    /**
     * Gets note
     *
     * @return string|null
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     *
     * @param string|null $note note
     *
     * @return self
     */
    public function setNote($note)
    {
        if (is_null($note)) {
            throw new \InvalidArgumentException('non-nullable note cannot be null');
        }
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets id_shop_group
     *
     * @return int|null
     */
    public function getIdShopGroup()
    {
        return $this->container['id_shop_group'];
    }

    /**
     * Sets id_shop_group
     *
     * @param int|null $id_shop_group id_shop_group
     *
     * @return self
     */
    public function setIdShopGroup($id_shop_group)
    {
        if (is_null($id_shop_group)) {
            throw new \InvalidArgumentException('non-nullable id_shop_group cannot be null');
        }
        $this->container['id_shop_group'] = $id_shop_group;

        return $this;
    }

    /**
     * Gets id_shop
     *
     * @return int|null
     */
    public function getIdShop()
    {
        return $this->container['id_shop'];
    }

    /**
     * Sets id_shop
     *
     * @param int|null $id_shop id_shop
     *
     * @return self
     */
    public function setIdShop($id_shop)
    {
        if (is_null($id_shop)) {
            throw new \InvalidArgumentException('non-nullable id_shop cannot be null');
        }
        $this->container['id_shop'] = $id_shop;

        return $this;
    }

    /**
     * Gets secure_key
     *
     * @return string|null
     */
    public function getSecureKey()
    {
        return $this->container['secure_key'];
    }

    /**
     * Sets secure_key
     *
     * @param string|null $secure_key secure_key
     *
     * @return self
     */
    public function setSecureKey($secure_key)
    {
        if (is_null($secure_key)) {
            throw new \InvalidArgumentException('non-nullable secure_key cannot be null');
        }
        $this->container['secure_key'] = $secure_key;

        return $this;
    }

    /**
     * Gets payment
     *
     * @return string|null
     */
    public function getPayment()
    {
        return $this->container['payment'];
    }

    /**
     * Sets payment
     *
     * @param string|null $payment payment
     *
     * @return self
     */
    public function setPayment($payment)
    {
        if (is_null($payment)) {
            throw new \InvalidArgumentException('non-nullable payment cannot be null');
        }
        $this->container['payment'] = $payment;

        return $this;
    }

    /**
     * Gets total_discounts
     *
     * @return string|null
     */
    public function getTotalDiscounts()
    {
        return $this->container['total_discounts'];
    }

    /**
     * Sets total_discounts
     *
     * @param string|null $total_discounts total_discounts
     *
     * @return self
     */
    public function setTotalDiscounts($total_discounts)
    {
        if (is_null($total_discounts)) {
            throw new \InvalidArgumentException('non-nullable total_discounts cannot be null');
        }
        $this->container['total_discounts'] = $total_discounts;

        return $this;
    }

    /**
     * Gets total_discounts_tax_incl
     *
     * @return string|null
     */
    public function getTotalDiscountsTaxIncl()
    {
        return $this->container['total_discounts_tax_incl'];
    }

    /**
     * Sets total_discounts_tax_incl
     *
     * @param string|null $total_discounts_tax_incl total_discounts_tax_incl
     *
     * @return self
     */
    public function setTotalDiscountsTaxIncl($total_discounts_tax_incl)
    {
        if (is_null($total_discounts_tax_incl)) {
            throw new \InvalidArgumentException('non-nullable total_discounts_tax_incl cannot be null');
        }
        $this->container['total_discounts_tax_incl'] = $total_discounts_tax_incl;

        return $this;
    }

    /**
     * Gets total_discounts_tax_excl
     *
     * @return string|null
     */
    public function getTotalDiscountsTaxExcl()
    {
        return $this->container['total_discounts_tax_excl'];
    }

    /**
     * Sets total_discounts_tax_excl
     *
     * @param string|null $total_discounts_tax_excl total_discounts_tax_excl
     *
     * @return self
     */
    public function setTotalDiscountsTaxExcl($total_discounts_tax_excl)
    {
        if (is_null($total_discounts_tax_excl)) {
            throw new \InvalidArgumentException('non-nullable total_discounts_tax_excl cannot be null');
        }
        $this->container['total_discounts_tax_excl'] = $total_discounts_tax_excl;

        return $this;
    }

    /**
     * Gets total_paid
     *
     * @return string|null
     */
    public function getTotalPaid()
    {
        return $this->container['total_paid'];
    }

    /**
     * Sets total_paid
     *
     * @param string|null $total_paid total_paid
     *
     * @return self
     */
    public function setTotalPaid($total_paid)
    {
        if (is_null($total_paid)) {
            throw new \InvalidArgumentException('non-nullable total_paid cannot be null');
        }
        $this->container['total_paid'] = $total_paid;

        return $this;
    }

    /**
     * Gets total_paid_tax_incl
     *
     * @return string|null
     */
    public function getTotalPaidTaxIncl()
    {
        return $this->container['total_paid_tax_incl'];
    }

    /**
     * Sets total_paid_tax_incl
     *
     * @param string|null $total_paid_tax_incl total_paid_tax_incl
     *
     * @return self
     */
    public function setTotalPaidTaxIncl($total_paid_tax_incl)
    {
        if (is_null($total_paid_tax_incl)) {
            throw new \InvalidArgumentException('non-nullable total_paid_tax_incl cannot be null');
        }
        $this->container['total_paid_tax_incl'] = $total_paid_tax_incl;

        return $this;
    }

    /**
     * Gets total_paid_tax_excl
     *
     * @return string|null
     */
    public function getTotalPaidTaxExcl()
    {
        return $this->container['total_paid_tax_excl'];
    }

    /**
     * Sets total_paid_tax_excl
     *
     * @param string|null $total_paid_tax_excl total_paid_tax_excl
     *
     * @return self
     */
    public function setTotalPaidTaxExcl($total_paid_tax_excl)
    {
        if (is_null($total_paid_tax_excl)) {
            throw new \InvalidArgumentException('non-nullable total_paid_tax_excl cannot be null');
        }
        $this->container['total_paid_tax_excl'] = $total_paid_tax_excl;

        return $this;
    }

    /**
     * Gets total_paid_real
     *
     * @return string|null
     */
    public function getTotalPaidReal()
    {
        return $this->container['total_paid_real'];
    }

    /**
     * Sets total_paid_real
     *
     * @param string|null $total_paid_real total_paid_real
     *
     * @return self
     */
    public function setTotalPaidReal($total_paid_real)
    {
        if (is_null($total_paid_real)) {
            throw new \InvalidArgumentException('non-nullable total_paid_real cannot be null');
        }
        $this->container['total_paid_real'] = $total_paid_real;

        return $this;
    }

    /**
     * Gets total_products
     *
     * @return string|null
     */
    public function getTotalProducts()
    {
        return $this->container['total_products'];
    }

    /**
     * Sets total_products
     *
     * @param string|null $total_products total_products
     *
     * @return self
     */
    public function setTotalProducts($total_products)
    {
        if (is_null($total_products)) {
            throw new \InvalidArgumentException('non-nullable total_products cannot be null');
        }
        $this->container['total_products'] = $total_products;

        return $this;
    }

    /**
     * Gets total_products_wt
     *
     * @return string|null
     */
    public function getTotalProductsWt()
    {
        return $this->container['total_products_wt'];
    }

    /**
     * Sets total_products_wt
     *
     * @param string|null $total_products_wt total_products_wt
     *
     * @return self
     */
    public function setTotalProductsWt($total_products_wt)
    {
        if (is_null($total_products_wt)) {
            throw new \InvalidArgumentException('non-nullable total_products_wt cannot be null');
        }
        $this->container['total_products_wt'] = $total_products_wt;

        return $this;
    }

    /**
     * Gets total_shipping
     *
     * @return string|null
     */
    public function getTotalShipping()
    {
        return $this->container['total_shipping'];
    }

    /**
     * Sets total_shipping
     *
     * @param string|null $total_shipping total_shipping
     *
     * @return self
     */
    public function setTotalShipping($total_shipping)
    {
        if (is_null($total_shipping)) {
            throw new \InvalidArgumentException('non-nullable total_shipping cannot be null');
        }
        $this->container['total_shipping'] = $total_shipping;

        return $this;
    }

    /**
     * Gets total_shipping_tax_incl
     *
     * @return string|null
     */
    public function getTotalShippingTaxIncl()
    {
        return $this->container['total_shipping_tax_incl'];
    }

    /**
     * Sets total_shipping_tax_incl
     *
     * @param string|null $total_shipping_tax_incl total_shipping_tax_incl
     *
     * @return self
     */
    public function setTotalShippingTaxIncl($total_shipping_tax_incl)
    {
        if (is_null($total_shipping_tax_incl)) {
            throw new \InvalidArgumentException('non-nullable total_shipping_tax_incl cannot be null');
        }
        $this->container['total_shipping_tax_incl'] = $total_shipping_tax_incl;

        return $this;
    }

    /**
     * Gets total_shipping_tax_excl
     *
     * @return string|null
     */
    public function getTotalShippingTaxExcl()
    {
        return $this->container['total_shipping_tax_excl'];
    }

    /**
     * Sets total_shipping_tax_excl
     *
     * @param string|null $total_shipping_tax_excl total_shipping_tax_excl
     *
     * @return self
     */
    public function setTotalShippingTaxExcl($total_shipping_tax_excl)
    {
        if (is_null($total_shipping_tax_excl)) {
            throw new \InvalidArgumentException('non-nullable total_shipping_tax_excl cannot be null');
        }
        $this->container['total_shipping_tax_excl'] = $total_shipping_tax_excl;

        return $this;
    }

    /**
     * Gets carrier_tax_rate
     *
     * @return string|null
     */
    public function getCarrierTaxRate()
    {
        return $this->container['carrier_tax_rate'];
    }

    /**
     * Sets carrier_tax_rate
     *
     * @param string|null $carrier_tax_rate carrier_tax_rate
     *
     * @return self
     */
    public function setCarrierTaxRate($carrier_tax_rate)
    {
        if (is_null($carrier_tax_rate)) {
            throw new \InvalidArgumentException('non-nullable carrier_tax_rate cannot be null');
        }
        $this->container['carrier_tax_rate'] = $carrier_tax_rate;

        return $this;
    }

    /**
     * Gets total_wrapping
     *
     * @return string|null
     */
    public function getTotalWrapping()
    {
        return $this->container['total_wrapping'];
    }

    /**
     * Sets total_wrapping
     *
     * @param string|null $total_wrapping total_wrapping
     *
     * @return self
     */
    public function setTotalWrapping($total_wrapping)
    {
        if (is_null($total_wrapping)) {
            throw new \InvalidArgumentException('non-nullable total_wrapping cannot be null');
        }
        $this->container['total_wrapping'] = $total_wrapping;

        return $this;
    }

    /**
     * Gets total_wrapping_tax_incl
     *
     * @return string|null
     */
    public function getTotalWrappingTaxIncl()
    {
        return $this->container['total_wrapping_tax_incl'];
    }

    /**
     * Sets total_wrapping_tax_incl
     *
     * @param string|null $total_wrapping_tax_incl total_wrapping_tax_incl
     *
     * @return self
     */
    public function setTotalWrappingTaxIncl($total_wrapping_tax_incl)
    {
        if (is_null($total_wrapping_tax_incl)) {
            throw new \InvalidArgumentException('non-nullable total_wrapping_tax_incl cannot be null');
        }
        $this->container['total_wrapping_tax_incl'] = $total_wrapping_tax_incl;

        return $this;
    }

    /**
     * Gets total_wrapping_tax_excl
     *
     * @return string|null
     */
    public function getTotalWrappingTaxExcl()
    {
        return $this->container['total_wrapping_tax_excl'];
    }

    /**
     * Sets total_wrapping_tax_excl
     *
     * @param string|null $total_wrapping_tax_excl total_wrapping_tax_excl
     *
     * @return self
     */
    public function setTotalWrappingTaxExcl($total_wrapping_tax_excl)
    {
        if (is_null($total_wrapping_tax_excl)) {
            throw new \InvalidArgumentException('non-nullable total_wrapping_tax_excl cannot be null');
        }
        $this->container['total_wrapping_tax_excl'] = $total_wrapping_tax_excl;

        return $this;
    }

    /**
     * Gets conversion_rate
     *
     * @return string|null
     */
    public function getConversionRate()
    {
        return $this->container['conversion_rate'];
    }

    /**
     * Sets conversion_rate
     *
     * @param string|null $conversion_rate conversion_rate
     *
     * @return self
     */
    public function setConversionRate($conversion_rate)
    {
        if (is_null($conversion_rate)) {
            throw new \InvalidArgumentException('non-nullable conversion_rate cannot be null');
        }
        $this->container['conversion_rate'] = $conversion_rate;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference reference
     *
     * @return self
     */
    public function setReference($reference)
    {
        if (is_null($reference)) {
            throw new \InvalidArgumentException('non-nullable reference cannot be null');
        }
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets associations
     *
     * @return \Prestashop\Model\OrderAssociations|null
     */
    public function getAssociations()
    {
        return $this->container['associations'];
    }

    /**
     * Sets associations
     *
     * @param \Prestashop\Model\OrderAssociations|null $associations associations
     *
     * @return self
     */
    public function setAssociations($associations)
    {
        if (is_null($associations)) {
            throw new \InvalidArgumentException('non-nullable associations cannot be null');
        }
        $this->container['associations'] = $associations;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


