# Prestashop\SupplierApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createSupplier()**](SupplierApi.md#createSupplier) | **POST** /suppliers |  |
| [**deleteSupplier()**](SupplierApi.md#deleteSupplier) | **DELETE** /suppliers/{id} |  |
| [**getSupplier()**](SupplierApi.md#getSupplier) | **GET** /suppliers/{id} | Your GET endpoint |
| [**getSuppliers()**](SupplierApi.md#getSuppliers) | **GET** /suppliers | Your GET endpoint |
| [**updateSupplier()**](SupplierApi.md#updateSupplier) | **PUT** /suppliers/{id} |  |


## `createSupplier()`

```php
createSupplier($suppliers): \Prestashop\Model\Supplier
```





### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Prestashop\Api\SupplierApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$suppliers = new \Prestashop\Model\Suppliers(); // \Prestashop\Model\Suppliers

try {
    $result = $apiInstance->createSupplier($suppliers);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SupplierApi->createSupplier: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **suppliers** | [**\Prestashop\Model\Suppliers**](../Model/Suppliers.md)|  | [optional] |

### Return type

[**\Prestashop\Model\Supplier**](../Model/Supplier.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteSupplier()`

```php
deleteSupplier($id)
```





### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Prestashop\Api\SupplierApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $apiInstance->deleteSupplier($id);
} catch (Exception $e) {
    echo 'Exception when calling SupplierApi->deleteSupplier: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSupplier()`

```php
getSupplier($id): \Prestashop\Model\GetSupplier200Response
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Prestashop\Api\SupplierApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->getSupplier($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SupplierApi->getSupplier: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Prestashop\Model\GetSupplier200Response**](../Model/GetSupplier200Response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSuppliers()`

```php
getSuppliers($display, $filter, $sort, $limit): \Prestashop\Model\Suppliers
```

Your GET endpoint



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Prestashop\Api\SupplierApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$display = 'display_example'; // string
$filter = 'filter_example'; // string
$sort = 'sort_example'; // string
$limit = 'limit_example'; // string

try {
    $result = $apiInstance->getSuppliers($display, $filter, $sort, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SupplierApi->getSuppliers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **display** | **string**|  | [optional] |
| **filter** | **string**|  | [optional] |
| **sort** | **string**|  | [optional] |
| **limit** | **string**|  | [optional] |

### Return type

[**\Prestashop\Model\Suppliers**](../Model/Suppliers.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateSupplier()`

```php
updateSupplier($id, $supplier): \Prestashop\Model\Supplier
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Prestashop\Api\SupplierApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$supplier = new \Prestashop\Model\Supplier(); // \Prestashop\Model\Supplier

try {
    $result = $apiInstance->updateSupplier($id, $supplier);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SupplierApi->updateSupplier: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **supplier** | [**\Prestashop\Model\Supplier**](../Model/Supplier.md)|  | [optional] |

### Return type

[**\Prestashop\Model\Supplier**](../Model/Supplier.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
