# Prestashop\ProductApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getProduct()**](ProductApi.md#getProduct) | **GET** /products/{id} | Your GET endpoint |
| [**getProducts()**](ProductApi.md#getProducts) | **GET** /products | Your GET endpoint |


## `getProduct()`

```php
getProduct($id): \Prestashop\Model\GetProduct200Response
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Prestashop\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->getProduct($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->getProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Prestashop\Model\GetProduct200Response**](../Model/GetProduct200Response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProducts()`

```php
getProducts($display, $filter, $sort, $limit, $id_shop, $id_group_shop): \Prestashop\Model\Products
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Prestashop\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$display = 'display_example'; // string
$filter = 'filter_example'; // string
$sort = 'sort_example'; // string
$limit = 'limit_example'; // string
$id_shop = 56; // int
$id_group_shop = 56; // int

try {
    $result = $apiInstance->getProducts($display, $filter, $sort, $limit, $id_shop, $id_group_shop);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->getProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **display** | **string**|  | [optional] |
| **filter** | **string**|  | [optional] |
| **sort** | **string**|  | [optional] |
| **limit** | **string**|  | [optional] |
| **id_shop** | **int**|  | [optional] |
| **id_group_shop** | **int**|  | [optional] |

### Return type

[**\Prestashop\Model\Products**](../Model/Products.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
