# Prestashop\OrderApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getOrder()**](OrderApi.md#getOrder) | **GET** /orders/{id} | Your GET endpoint |
| [**getOrders()**](OrderApi.md#getOrders) | **GET** /orders | Your GET endpoint |


## `getOrder()`

```php
getOrder($id): \Prestashop\Model\GetOrder200Response
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Prestashop\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->getOrder($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->getOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Prestashop\Model\GetOrder200Response**](../Model/GetOrder200Response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrders()`

```php
getOrders($display, $filter, $sort, $limit, $id_shop, $id_group_shop): \Prestashop\Model\Orders
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Prestashop\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$display = 'display_example'; // string
$filter = 'filter_example'; // string
$sort = 'sort_example'; // string
$limit = 'limit_example'; // string
$id_shop = 56; // int
$id_group_shop = 56; // int

try {
    $result = $apiInstance->getOrders($display, $filter, $sort, $limit, $id_shop, $id_group_shop);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->getOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **display** | **string**|  | [optional] |
| **filter** | **string**|  | [optional] |
| **sort** | **string**|  | [optional] |
| **limit** | **string**|  | [optional] |
| **id_shop** | **int**|  | [optional] |
| **id_group_shop** | **int**|  | [optional] |

### Return type

[**\Prestashop\Model\Orders**](../Model/Orders.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
