# OpenAPIClient-php

https://devdocs.prestashop-project.org/8/webservice/

For more information, please visit [https://tideconnects.com](https://tideconnects.com).

## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/prestashop.git"
    }
  ],
  "require": {
    "talisman/prestashop": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new Prestashop\Api\ConfigurationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->getConfiguration($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConfigurationApi->getConfiguration: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ConfigurationApi* | [**getConfiguration**](docs/Api/ConfigurationApi.md#getconfiguration) | **GET** /configurations/{id} | Your GET endpoint
*ConfigurationApi* | [**getConfigurations**](docs/Api/ConfigurationApi.md#getconfigurations) | **GET** /configurations | Your GET endpoint
*OrderApi* | [**getOrder**](docs/Api/OrderApi.md#getorder) | **GET** /orders/{id} | Your GET endpoint
*OrderApi* | [**getOrders**](docs/Api/OrderApi.md#getorders) | **GET** /orders | Your GET endpoint
*ProductApi* | [**getProduct**](docs/Api/ProductApi.md#getproduct) | **GET** /products/{id} | Your GET endpoint
*ProductApi* | [**getProducts**](docs/Api/ProductApi.md#getproducts) | **GET** /products | Your GET endpoint
*ShopApi* | [**getShop**](docs/Api/ShopApi.md#getshop) | **GET** /shops/{id} | Your GET endpoint
*ShopApi* | [**getShops**](docs/Api/ShopApi.md#getshops) | **GET** /shops | Your GET endpoint
*SupplierApi* | [**createSupplier**](docs/Api/SupplierApi.md#createsupplier) | **POST** /suppliers | 
*SupplierApi* | [**deleteSupplier**](docs/Api/SupplierApi.md#deletesupplier) | **DELETE** /suppliers/{id} | 
*SupplierApi* | [**getSupplier**](docs/Api/SupplierApi.md#getsupplier) | **GET** /suppliers/{id} | Your GET endpoint
*SupplierApi* | [**getSuppliers**](docs/Api/SupplierApi.md#getsuppliers) | **GET** /suppliers | Your GET endpoint
*SupplierApi* | [**updateSupplier**](docs/Api/SupplierApi.md#updatesupplier) | **PUT** /suppliers/{id} | 

## Models

- [Configuration](docs/Model/Configuration.md)
- [Configurations](docs/Model/Configurations.md)
- [GetConfiguration200Response](docs/Model/GetConfiguration200Response.md)
- [GetOrder200Response](docs/Model/GetOrder200Response.md)
- [GetProduct200Response](docs/Model/GetProduct200Response.md)
- [GetShop200Response](docs/Model/GetShop200Response.md)
- [GetSupplier200Response](docs/Model/GetSupplier200Response.md)
- [Id](docs/Model/Id.md)
- [Order](docs/Model/Order.md)
- [OrderAssociations](docs/Model/OrderAssociations.md)
- [OrderRow](docs/Model/OrderRow.md)
- [Orders](docs/Model/Orders.md)
- [Product](docs/Model/Product.md)
- [ProductAssociations](docs/Model/ProductAssociations.md)
- [ProductDeliveryInStockInner](docs/Model/ProductDeliveryInStockInner.md)
- [ProductFeature](docs/Model/ProductFeature.md)
- [Products](docs/Model/Products.md)
- [Shop](docs/Model/Shop.md)
- [Shops](docs/Model/Shops.md)
- [StockAvailable](docs/Model/StockAvailable.md)
- [Supplier](docs/Model/Supplier.md)
- [Suppliers](docs/Model/Suppliers.md)
- [Value](docs/Model/Value.md)

## Authorization
Endpoints do not require authorization.

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author

admin@tideconnetcs.com

## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `1.0`
    - Package version: `1.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
