<?php
/**
 * SalesOrdersApiTest
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the endpoint.
 */

namespace Opsuite2\Test\Api;

use \Opsuite2\Configuration;
use \Opsuite2\ApiException;
use \Opsuite2\ObjectSerializer;
use PHPUnit\Framework\TestCase;

/**
 * SalesOrdersApiTest Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SalesOrdersApiTest extends TestCase
{

    /**
     * Setup before running any test cases
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test case for apiV1SalesOrdersGet
     *
     * Returns an array of SalesOrders that match the specified search criteria..
     *
     */
    public function testApiV1SalesOrdersGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1SalesOrdersOrderIdClosedStatusGet
     *
     * Returns the closed status for the specified sales order..
     *
     */
    public function testApiV1SalesOrdersOrderIdClosedStatusGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1SalesOrdersUpdateTrackingNumberPatch
     *
     * Updates the shipping tracking number on the specified order.
     *
     */
    public function testApiV1SalesOrdersUpdateTrackingNumberPatch()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV2SalesOrdersGet
     *
     * Returns an array of SalesOrders that match the specified search criteria..
     *
     */
    public function testApiV2SalesOrdersGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for createMultiLocationSalesOrderFromBasket
     *
     * Creates a new sales order from a stored basket of goods,  converts the sales order to a retail transaction,  and creates a picking order for the specified stock location.
     *
     */
    public function testCreateMultiLocationSalesOrderFromBasket()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for createSalesOrderFromBasket
     *
     * Creates a new sales order from a stored basket of goods..
     *
     */
    public function testCreateSalesOrderFromBasket()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for getSalesOrderByOrderId
     *
     * Returns the specified sales order transaction..
     *
     */
    public function testGetSalesOrderByOrderId()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }
}
