<?php
/**
 * ItemLocationDetailsApiTest
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the endpoint.
 */

namespace Opsuite2\Test\Api;

use \Opsuite2\Configuration;
use \Opsuite2\ApiException;
use \Opsuite2\ObjectSerializer;
use PHPUnit\Framework\TestCase;

/**
 * ItemLocationDetailsApiTest Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ItemLocationDetailsApiTest extends TestCase
{

    /**
     * Setup before running any test cases
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test case for apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet
     *
     * Returns a single ItemLocationDetail with the specified LocationId and ItemMasterId.
     *
     */
    public function testApiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet
     *
     * Returns a single ItemLocationDetail with the specified LocationId and product code.
     *
     */
    public function testApiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet
     *
     * Returns a single ItemLocationDetail with the specified LocationId and sku.
     *
     */
    public function testApiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet
     *
     * Returns a list ItemLocationDetails with the specified LocationId and skus.
     *
     */
    public function testApiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1ItemLocationDetailsGetItemLocationDetailsGet
     *
     * Returns an array of ItemLocationDetails that match the specified search criteria  The last updated date and location id are required parameters.
     *
     */
    public function testApiV1ItemLocationDetailsGetItemLocationDetailsGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet
     *
     * Returns an array of ItemLocationDetails that have been modified since the specified date.
     *
     */
    public function testApiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet
     *
     * Returns an array of Questions associated with the specified ItemLocationDetail..
     *
     */
    public function testApiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch
     *
     * Updates specified properties of multiple ItemLocationDetails..
     *
     */
    public function testApiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost
     *
     * Creates multiple new item location details..
     *
     */
    public function testApiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }
}
