<?php
/**
 * CustomersApiTest
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the endpoint.
 */

namespace Opsuite2\Test\Api;

use \Opsuite2\Configuration;
use \Opsuite2\ApiException;
use \Opsuite2\ObjectSerializer;
use PHPUnit\Framework\TestCase;

/**
 * CustomersApiTest Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomersApiTest extends TestCase
{

    /**
     * Setup before running any test cases
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test case for apiV1CustomersCustomerIdAllContactsGet
     *
     * Returns an array of all contacts for the specified customer..
     *
     */
    public function testApiV1CustomersCustomerIdAllContactsGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersCustomerIdAlternativeShipToContactsGet
     *
     * Returns an array of alternative ship to contacts for the specified customer..
     *
     */
    public function testApiV1CustomersCustomerIdAlternativeShipToContactsGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersCustomerIdContactsGet
     *
     * Returns an array of other contacts for the specified customer..
     *
     */
    public function testApiV1CustomersCustomerIdContactsGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet
     *
     * Returns the customer loyalty fields for the specified customer..
     *
     */
    public function testApiV1CustomersCustomerIdCustomerLoyaltyFieldsGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersCustomerIdDiscountCouponsGet
     *
     * Returns an array of discount coupons for the specified customer..
     *
     */
    public function testApiV1CustomersCustomerIdDiscountCouponsGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersCustomerIdLoyaltyBalancesGet
     *
     * Returns an array of loyalty point balances for the specified customer..
     *
     */
    public function testApiV1CustomersCustomerIdLoyaltyBalancesGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersCustomerIdLoyaltyCardsGet
     *
     * Returns an array of loyalty cards for the specified customer..
     *
     */
    public function testApiV1CustomersCustomerIdLoyaltyCardsGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersCustomerIdLoyaltyTransactionsGet
     *
     * Returns an array of loyalty transactions for the specified customer..
     *
     */
    public function testApiV1CustomersCustomerIdLoyaltyTransactionsGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersCustomerIdPatch
     *
     * Updates specified properties of a customer..
     *
     */
    public function testApiV1CustomersCustomerIdPatch()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersCustomerIdPromotionCouponsGet
     *
     * Returns an array of promotion coupons for the specified customer..
     *
     */
    public function testApiV1CustomersCustomerIdPromotionCouponsGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersCustomerIdTransactionHeadersGet
     *
     * Returns an array of transaction headers for the specified customer..
     *
     */
    public function testApiV1CustomersCustomerIdTransactionHeadersGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersExpiringLoyaltyTransactionsGet
     *
     * Returns an array of expiring loyalty transactions for the specified customers..
     *
     */
    public function testApiV1CustomersExpiringLoyaltyTransactionsGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersExpiryingLoyaltyTransactionsGet
     *
     * Returns an array of expiring loyalty transactions for the specified customers..
     *
     */
    public function testApiV1CustomersExpiryingLoyaltyTransactionsGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersGet
     *
     * Returns an array of Customers that match the specified search criteria..
     *
     */
    public function testApiV1CustomersGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersGetCustomerByAccountNumberGet
     *
     * Returns a single Customer with the specified account number or loyalty card number..
     *
     */
    public function testApiV1CustomersGetCustomerByAccountNumberGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersGetCustomerByAddressGet
     *
     * Returns a single Customer with the specified physical address..
     *
     */
    public function testApiV1CustomersGetCustomerByAddressGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersGetCustomerByEmailAddressGet
     *
     * Returns a single Customer with the specified email address..
     *
     */
    public function testApiV1CustomersGetCustomerByEmailAddressGet()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersPost
     *
     * Creates a new customer..
     *
     */
    public function testApiV1CustomersPost()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for apiV1CustomersPut
     *
     * Updates a batch of customers..
     *
     */
    public function testApiV1CustomersPut()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test case for getCustomerById
     *
     * Returns a single Customer with the specified id..
     *
     */
    public function testGetCustomerById()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }
}
