<?php
/**
 * TransferDetails
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * TransferDetails Class Doc Comment
 *
 * @category Class
 * @description Details of a transfer for picking
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class TransferDetails implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TransferDetails';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'transfer_type_name' => 'string',
        'location_id' => 'int',
        'status_id' => 'int',
        'status_name' => 'string',
        'reference_number' => 'string',
        'title' => 'string',
        'placed' => 'bool',
        'destination_location_id' => 'int',
        'destination_location' => '\Opsuite2\Model\Location',
        'source_location_id' => 'int',
        'source_location' => '\Opsuite2\Model\Location',
        'supplier_id' => 'int',
        'supplier' => '\Opsuite2\Model\Supplier',
        'transfer_value' => 'float',
        'order_shipping' => 'float',
        'order_tax' => 'float',
        'date_created' => '\DateTime',
        'last_updated' => '\DateTime',
        'confirming_to' => 'string',
        'created_by' => 'string',
        'date_placed' => '\DateTime',
        'required_date' => '\DateTime',
        'fob_point' => 'string',
        'freight' => 'string',
        'transfer_lines' => '\Opsuite2\Model\TransferDetailsLine[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int32',
        'transfer_type_name' => null,
        'location_id' => 'int32',
        'status_id' => 'int32',
        'status_name' => null,
        'reference_number' => null,
        'title' => null,
        'placed' => null,
        'destination_location_id' => 'int32',
        'destination_location' => null,
        'source_location_id' => 'int32',
        'source_location' => null,
        'supplier_id' => 'int32',
        'supplier' => null,
        'transfer_value' => 'double',
        'order_shipping' => 'double',
        'order_tax' => 'double',
        'date_created' => 'date-time',
        'last_updated' => 'date-time',
        'confirming_to' => null,
        'created_by' => null,
        'date_placed' => 'date-time',
        'required_date' => 'date-time',
        'fob_point' => null,
        'freight' => null,
        'transfer_lines' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'transfer_type_name' => true,
        'location_id' => false,
        'status_id' => true,
        'status_name' => true,
        'reference_number' => true,
        'title' => true,
        'placed' => false,
        'destination_location_id' => true,
        'destination_location' => false,
        'source_location_id' => true,
        'source_location' => false,
        'supplier_id' => true,
        'supplier' => false,
        'transfer_value' => false,
        'order_shipping' => false,
        'order_tax' => false,
        'date_created' => false,
        'last_updated' => false,
        'confirming_to' => true,
        'created_by' => true,
        'date_placed' => true,
        'required_date' => false,
        'fob_point' => true,
        'freight' => true,
        'transfer_lines' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'transfer_type_name' => 'transferTypeName',
        'location_id' => 'locationId',
        'status_id' => 'statusId',
        'status_name' => 'statusName',
        'reference_number' => 'referenceNumber',
        'title' => 'title',
        'placed' => 'placed',
        'destination_location_id' => 'destinationLocationId',
        'destination_location' => 'destinationLocation',
        'source_location_id' => 'sourceLocationId',
        'source_location' => 'sourceLocation',
        'supplier_id' => 'supplierId',
        'supplier' => 'supplier',
        'transfer_value' => 'transferValue',
        'order_shipping' => 'orderShipping',
        'order_tax' => 'orderTax',
        'date_created' => 'dateCreated',
        'last_updated' => 'lastUpdated',
        'confirming_to' => 'confirmingTo',
        'created_by' => 'createdBy',
        'date_placed' => 'datePlaced',
        'required_date' => 'requiredDate',
        'fob_point' => 'fobPoint',
        'freight' => 'freight',
        'transfer_lines' => 'transferLines'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'transfer_type_name' => 'setTransferTypeName',
        'location_id' => 'setLocationId',
        'status_id' => 'setStatusId',
        'status_name' => 'setStatusName',
        'reference_number' => 'setReferenceNumber',
        'title' => 'setTitle',
        'placed' => 'setPlaced',
        'destination_location_id' => 'setDestinationLocationId',
        'destination_location' => 'setDestinationLocation',
        'source_location_id' => 'setSourceLocationId',
        'source_location' => 'setSourceLocation',
        'supplier_id' => 'setSupplierId',
        'supplier' => 'setSupplier',
        'transfer_value' => 'setTransferValue',
        'order_shipping' => 'setOrderShipping',
        'order_tax' => 'setOrderTax',
        'date_created' => 'setDateCreated',
        'last_updated' => 'setLastUpdated',
        'confirming_to' => 'setConfirmingTo',
        'created_by' => 'setCreatedBy',
        'date_placed' => 'setDatePlaced',
        'required_date' => 'setRequiredDate',
        'fob_point' => 'setFobPoint',
        'freight' => 'setFreight',
        'transfer_lines' => 'setTransferLines'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'transfer_type_name' => 'getTransferTypeName',
        'location_id' => 'getLocationId',
        'status_id' => 'getStatusId',
        'status_name' => 'getStatusName',
        'reference_number' => 'getReferenceNumber',
        'title' => 'getTitle',
        'placed' => 'getPlaced',
        'destination_location_id' => 'getDestinationLocationId',
        'destination_location' => 'getDestinationLocation',
        'source_location_id' => 'getSourceLocationId',
        'source_location' => 'getSourceLocation',
        'supplier_id' => 'getSupplierId',
        'supplier' => 'getSupplier',
        'transfer_value' => 'getTransferValue',
        'order_shipping' => 'getOrderShipping',
        'order_tax' => 'getOrderTax',
        'date_created' => 'getDateCreated',
        'last_updated' => 'getLastUpdated',
        'confirming_to' => 'getConfirmingTo',
        'created_by' => 'getCreatedBy',
        'date_placed' => 'getDatePlaced',
        'required_date' => 'getRequiredDate',
        'fob_point' => 'getFobPoint',
        'freight' => 'getFreight',
        'transfer_lines' => 'getTransferLines'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('transfer_type_name', $data ?? [], null);
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('status_id', $data ?? [], null);
        $this->setIfExists('status_name', $data ?? [], null);
        $this->setIfExists('reference_number', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('placed', $data ?? [], null);
        $this->setIfExists('destination_location_id', $data ?? [], null);
        $this->setIfExists('destination_location', $data ?? [], null);
        $this->setIfExists('source_location_id', $data ?? [], null);
        $this->setIfExists('source_location', $data ?? [], null);
        $this->setIfExists('supplier_id', $data ?? [], null);
        $this->setIfExists('supplier', $data ?? [], null);
        $this->setIfExists('transfer_value', $data ?? [], null);
        $this->setIfExists('order_shipping', $data ?? [], null);
        $this->setIfExists('order_tax', $data ?? [], null);
        $this->setIfExists('date_created', $data ?? [], null);
        $this->setIfExists('last_updated', $data ?? [], null);
        $this->setIfExists('confirming_to', $data ?? [], null);
        $this->setIfExists('created_by', $data ?? [], null);
        $this->setIfExists('date_placed', $data ?? [], null);
        $this->setIfExists('required_date', $data ?? [], null);
        $this->setIfExists('fob_point', $data ?? [], null);
        $this->setIfExists('freight', $data ?? [], null);
        $this->setIfExists('transfer_lines', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id The transfer id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets transfer_type_name
     *
     * @return string|null
     */
    public function getTransferTypeName()
    {
        return $this->container['transfer_type_name'];
    }

    /**
     * Sets transfer_type_name
     *
     * @param string|null $transfer_type_name The transfer type, this is one of:<br />      1 Inter-Store<br />      2 Supplier<br />      3 Transfer In<br />      4 Transfer Out
     *
     * @return self
     */
    public function setTransferTypeName($transfer_type_name)
    {
        if (is_null($transfer_type_name)) {
            array_push($this->openAPINullablesSetToNull, 'transfer_type_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('transfer_type_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['transfer_type_name'] = $transfer_type_name;

        return $this;
    }

    /**
     * Gets location_id
     *
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param int|null $location_id The originating location of the transfer
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets status_id
     *
     * @return int|null
     */
    public function getStatusId()
    {
        return $this->container['status_id'];
    }

    /**
     * Sets status_id
     *
     * @param int|null $status_id The transfer status id
     *
     * @return self
     */
    public function setStatusId($status_id)
    {
        if (is_null($status_id)) {
            array_push($this->openAPINullablesSetToNull, 'status_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('status_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['status_id'] = $status_id;

        return $this;
    }

    /**
     * Gets status_name
     *
     * @return string|null
     */
    public function getStatusName()
    {
        return $this->container['status_name'];
    }

    /**
     * Sets status_name
     *
     * @param string|null $status_name The transfer status name, this is one of:<br />      Open<br />      Back Ordered (Partial)<br />      Closed<br />      Deleted
     *
     * @return self
     */
    public function setStatusName($status_name)
    {
        if (is_null($status_name)) {
            array_push($this->openAPINullablesSetToNull, 'status_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('status_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['status_name'] = $status_name;

        return $this;
    }

    /**
     * Gets reference_number
     *
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->container['reference_number'];
    }

    /**
     * Sets reference_number
     *
     * @param string|null $reference_number Reference number
     *
     * @return self
     */
    public function setReferenceNumber($reference_number)
    {
        if (is_null($reference_number)) {
            array_push($this->openAPINullablesSetToNull, 'reference_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('reference_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['reference_number'] = $reference_number;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title Transfer title
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            array_push($this->openAPINullablesSetToNull, 'title');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('title', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets placed
     *
     * @return bool|null
     */
    public function getPlaced()
    {
        return $this->container['placed'];
    }

    /**
     * Sets placed
     *
     * @param bool|null $placed Whether the transfer is placed or not
     *
     * @return self
     */
    public function setPlaced($placed)
    {
        if (is_null($placed)) {
            throw new \InvalidArgumentException('non-nullable placed cannot be null');
        }
        $this->container['placed'] = $placed;

        return $this;
    }

    /**
     * Gets destination_location_id
     *
     * @return int|null
     */
    public function getDestinationLocationId()
    {
        return $this->container['destination_location_id'];
    }

    /**
     * Sets destination_location_id
     *
     * @param int|null $destination_location_id The destination location id
     *
     * @return self
     */
    public function setDestinationLocationId($destination_location_id)
    {
        if (is_null($destination_location_id)) {
            array_push($this->openAPINullablesSetToNull, 'destination_location_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('destination_location_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['destination_location_id'] = $destination_location_id;

        return $this;
    }

    /**
     * Gets destination_location
     *
     * @return \Opsuite2\Model\Location|null
     */
    public function getDestinationLocation()
    {
        return $this->container['destination_location'];
    }

    /**
     * Sets destination_location
     *
     * @param \Opsuite2\Model\Location|null $destination_location destination_location
     *
     * @return self
     */
    public function setDestinationLocation($destination_location)
    {
        if (is_null($destination_location)) {
            throw new \InvalidArgumentException('non-nullable destination_location cannot be null');
        }
        $this->container['destination_location'] = $destination_location;

        return $this;
    }

    /**
     * Gets source_location_id
     *
     * @return int|null
     */
    public function getSourceLocationId()
    {
        return $this->container['source_location_id'];
    }

    /**
     * Sets source_location_id
     *
     * @param int|null $source_location_id The source location id
     *
     * @return self
     */
    public function setSourceLocationId($source_location_id)
    {
        if (is_null($source_location_id)) {
            array_push($this->openAPINullablesSetToNull, 'source_location_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('source_location_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['source_location_id'] = $source_location_id;

        return $this;
    }

    /**
     * Gets source_location
     *
     * @return \Opsuite2\Model\Location|null
     */
    public function getSourceLocation()
    {
        return $this->container['source_location'];
    }

    /**
     * Sets source_location
     *
     * @param \Opsuite2\Model\Location|null $source_location source_location
     *
     * @return self
     */
    public function setSourceLocation($source_location)
    {
        if (is_null($source_location)) {
            throw new \InvalidArgumentException('non-nullable source_location cannot be null');
        }
        $this->container['source_location'] = $source_location;

        return $this;
    }

    /**
     * Gets supplier_id
     *
     * @return int|null
     */
    public function getSupplierId()
    {
        return $this->container['supplier_id'];
    }

    /**
     * Sets supplier_id
     *
     * @param int|null $supplier_id The supplier id - only set for supplier transfers
     *
     * @return self
     */
    public function setSupplierId($supplier_id)
    {
        if (is_null($supplier_id)) {
            array_push($this->openAPINullablesSetToNull, 'supplier_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('supplier_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['supplier_id'] = $supplier_id;

        return $this;
    }

    /**
     * Gets supplier
     *
     * @return \Opsuite2\Model\Supplier|null
     */
    public function getSupplier()
    {
        return $this->container['supplier'];
    }

    /**
     * Sets supplier
     *
     * @param \Opsuite2\Model\Supplier|null $supplier supplier
     *
     * @return self
     */
    public function setSupplier($supplier)
    {
        if (is_null($supplier)) {
            throw new \InvalidArgumentException('non-nullable supplier cannot be null');
        }
        $this->container['supplier'] = $supplier;

        return $this;
    }

    /**
     * Gets transfer_value
     *
     * @return float|null
     */
    public function getTransferValue()
    {
        return $this->container['transfer_value'];
    }

    /**
     * Sets transfer_value
     *
     * @param float|null $transfer_value The value of the transfer
     *
     * @return self
     */
    public function setTransferValue($transfer_value)
    {
        if (is_null($transfer_value)) {
            throw new \InvalidArgumentException('non-nullable transfer_value cannot be null');
        }
        $this->container['transfer_value'] = $transfer_value;

        return $this;
    }

    /**
     * Gets order_shipping
     *
     * @return float|null
     */
    public function getOrderShipping()
    {
        return $this->container['order_shipping'];
    }

    /**
     * Sets order_shipping
     *
     * @param float|null $order_shipping The value of the shipping for the transfer
     *
     * @return self
     */
    public function setOrderShipping($order_shipping)
    {
        if (is_null($order_shipping)) {
            throw new \InvalidArgumentException('non-nullable order_shipping cannot be null');
        }
        $this->container['order_shipping'] = $order_shipping;

        return $this;
    }

    /**
     * Gets order_tax
     *
     * @return float|null
     */
    public function getOrderTax()
    {
        return $this->container['order_tax'];
    }

    /**
     * Sets order_tax
     *
     * @param float|null $order_tax The tax payable on the transfer
     *
     * @return self
     */
    public function setOrderTax($order_tax)
    {
        if (is_null($order_tax)) {
            throw new \InvalidArgumentException('non-nullable order_tax cannot be null');
        }
        $this->container['order_tax'] = $order_tax;

        return $this;
    }

    /**
     * Gets date_created
     *
     * @return \DateTime|null
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     *
     * @param \DateTime|null $date_created The date the transfer was created
     *
     * @return self
     */
    public function setDateCreated($date_created)
    {
        if (is_null($date_created)) {
            throw new \InvalidArgumentException('non-nullable date_created cannot be null');
        }
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets last_updated
     *
     * @return \DateTime|null
     */
    public function getLastUpdated()
    {
        return $this->container['last_updated'];
    }

    /**
     * Sets last_updated
     *
     * @param \DateTime|null $last_updated The date the transfer was last updated
     *
     * @return self
     */
    public function setLastUpdated($last_updated)
    {
        if (is_null($last_updated)) {
            throw new \InvalidArgumentException('non-nullable last_updated cannot be null');
        }
        $this->container['last_updated'] = $last_updated;

        return $this;
    }

    /**
     * Gets confirming_to
     *
     * @return string|null
     */
    public function getConfirmingTo()
    {
        return $this->container['confirming_to'];
    }

    /**
     * Sets confirming_to
     *
     * @param string|null $confirming_to The confirming to details
     *
     * @return self
     */
    public function setConfirmingTo($confirming_to)
    {
        if (is_null($confirming_to)) {
            array_push($this->openAPINullablesSetToNull, 'confirming_to');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('confirming_to', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['confirming_to'] = $confirming_to;

        return $this;
    }

    /**
     * Gets created_by
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     *
     * @param string|null $created_by The user who created the transfer
     *
     * @return self
     */
    public function setCreatedBy($created_by)
    {
        if (is_null($created_by)) {
            array_push($this->openAPINullablesSetToNull, 'created_by');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('created_by', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets date_placed
     *
     * @return \DateTime|null
     */
    public function getDatePlaced()
    {
        return $this->container['date_placed'];
    }

    /**
     * Sets date_placed
     *
     * @param \DateTime|null $date_placed If placed, the date the transfer was placed
     *
     * @return self
     */
    public function setDatePlaced($date_placed)
    {
        if (is_null($date_placed)) {
            array_push($this->openAPINullablesSetToNull, 'date_placed');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_placed', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_placed'] = $date_placed;

        return $this;
    }

    /**
     * Gets required_date
     *
     * @return \DateTime|null
     */
    public function getRequiredDate()
    {
        return $this->container['required_date'];
    }

    /**
     * Sets required_date
     *
     * @param \DateTime|null $required_date The date the transfer is required
     *
     * @return self
     */
    public function setRequiredDate($required_date)
    {
        if (is_null($required_date)) {
            throw new \InvalidArgumentException('non-nullable required_date cannot be null');
        }
        $this->container['required_date'] = $required_date;

        return $this;
    }

    /**
     * Gets fob_point
     *
     * @return string|null
     */
    public function getFobPoint()
    {
        return $this->container['fob_point'];
    }

    /**
     * Sets fob_point
     *
     * @param string|null $fob_point 
     *
     * @return self
     */
    public function setFobPoint($fob_point)
    {
        if (is_null($fob_point)) {
            array_push($this->openAPINullablesSetToNull, 'fob_point');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('fob_point', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['fob_point'] = $fob_point;

        return $this;
    }

    /**
     * Gets freight
     *
     * @return string|null
     */
    public function getFreight()
    {
        return $this->container['freight'];
    }

    /**
     * Sets freight
     *
     * @param string|null $freight 
     *
     * @return self
     */
    public function setFreight($freight)
    {
        if (is_null($freight)) {
            array_push($this->openAPINullablesSetToNull, 'freight');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('freight', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['freight'] = $freight;

        return $this;
    }

    /**
     * Gets transfer_lines
     *
     * @return \Opsuite2\Model\TransferDetailsLine[]|null
     */
    public function getTransferLines()
    {
        return $this->container['transfer_lines'];
    }

    /**
     * Sets transfer_lines
     *
     * @param \Opsuite2\Model\TransferDetailsLine[]|null $transfer_lines The items on the transfer
     *
     * @return self
     */
    public function setTransferLines($transfer_lines)
    {
        if (is_null($transfer_lines)) {
            array_push($this->openAPINullablesSetToNull, 'transfer_lines');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('transfer_lines', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['transfer_lines'] = $transfer_lines;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


