<?php
/**
 * TransactionLine
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * TransactionLine Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class TransactionLine implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TransactionLine';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'transaction_id' => 'int',
        'item_id' => 'int',
        'item_sku' => 'string',
        'department_id' => 'int',
        'category_id' => 'int',
        'supplier_id' => 'int',
        'item_description' => 'string',
        'unit_cost' => 'float',
        'regular_unit_price' => 'float',
        'actual_unit_price' => 'float',
        'profit' => 'float',
        'profit_margin' => 'float',
        'quantity' => 'float',
        'extended_cost' => 'float',
        'extended_price' => 'float',
        'sales_tax' => 'float',
        'tax_group_id' => 'int',
        'tax_group_name' => 'string',
        'tax_percentage' => 'float',
        'discount_reason_code_id' => 'int',
        'discount_reason_code' => 'string',
        'discount_reason_description' => 'string',
        'return_reason_code_id' => 'int',
        'return_reason_code' => 'string',
        'tax_change_reason_code_id' => 'int',
        'tax_change_reason_code' => 'string',
        'comment' => 'string',
        'serial_number' => 'string',
        'line_benefits' => '\Opsuite2\Model\TransactionLineBenefit[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int32',
        'transaction_id' => 'int32',
        'item_id' => 'int32',
        'item_sku' => null,
        'department_id' => 'int32',
        'category_id' => 'int32',
        'supplier_id' => 'int32',
        'item_description' => null,
        'unit_cost' => 'double',
        'regular_unit_price' => 'double',
        'actual_unit_price' => 'double',
        'profit' => 'double',
        'profit_margin' => 'double',
        'quantity' => 'double',
        'extended_cost' => 'double',
        'extended_price' => 'double',
        'sales_tax' => 'double',
        'tax_group_id' => 'int32',
        'tax_group_name' => null,
        'tax_percentage' => 'double',
        'discount_reason_code_id' => 'int32',
        'discount_reason_code' => null,
        'discount_reason_description' => null,
        'return_reason_code_id' => 'int32',
        'return_reason_code' => null,
        'tax_change_reason_code_id' => 'int32',
        'tax_change_reason_code' => null,
        'comment' => null,
        'serial_number' => null,
        'line_benefits' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'transaction_id' => false,
        'item_id' => false,
        'item_sku' => true,
        'department_id' => false,
        'category_id' => false,
        'supplier_id' => true,
        'item_description' => true,
        'unit_cost' => false,
        'regular_unit_price' => false,
        'actual_unit_price' => false,
        'profit' => false,
        'profit_margin' => false,
        'quantity' => false,
        'extended_cost' => false,
        'extended_price' => false,
        'sales_tax' => false,
        'tax_group_id' => true,
        'tax_group_name' => true,
        'tax_percentage' => true,
        'discount_reason_code_id' => true,
        'discount_reason_code' => true,
        'discount_reason_description' => true,
        'return_reason_code_id' => true,
        'return_reason_code' => true,
        'tax_change_reason_code_id' => true,
        'tax_change_reason_code' => true,
        'comment' => true,
        'serial_number' => true,
        'line_benefits' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'transaction_id' => 'transactionId',
        'item_id' => 'itemId',
        'item_sku' => 'itemSku',
        'department_id' => 'departmentId',
        'category_id' => 'categoryId',
        'supplier_id' => 'supplierId',
        'item_description' => 'itemDescription',
        'unit_cost' => 'unitCost',
        'regular_unit_price' => 'regularUnitPrice',
        'actual_unit_price' => 'actualUnitPrice',
        'profit' => 'profit',
        'profit_margin' => 'profitMargin',
        'quantity' => 'quantity',
        'extended_cost' => 'extendedCost',
        'extended_price' => 'extendedPrice',
        'sales_tax' => 'salesTax',
        'tax_group_id' => 'taxGroupId',
        'tax_group_name' => 'taxGroupName',
        'tax_percentage' => 'taxPercentage',
        'discount_reason_code_id' => 'discountReasonCodeId',
        'discount_reason_code' => 'discountReasonCode',
        'discount_reason_description' => 'discountReasonDescription',
        'return_reason_code_id' => 'returnReasonCodeId',
        'return_reason_code' => 'returnReasonCode',
        'tax_change_reason_code_id' => 'taxChangeReasonCodeId',
        'tax_change_reason_code' => 'taxChangeReasonCode',
        'comment' => 'comment',
        'serial_number' => 'serialNumber',
        'line_benefits' => 'lineBenefits'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'transaction_id' => 'setTransactionId',
        'item_id' => 'setItemId',
        'item_sku' => 'setItemSku',
        'department_id' => 'setDepartmentId',
        'category_id' => 'setCategoryId',
        'supplier_id' => 'setSupplierId',
        'item_description' => 'setItemDescription',
        'unit_cost' => 'setUnitCost',
        'regular_unit_price' => 'setRegularUnitPrice',
        'actual_unit_price' => 'setActualUnitPrice',
        'profit' => 'setProfit',
        'profit_margin' => 'setProfitMargin',
        'quantity' => 'setQuantity',
        'extended_cost' => 'setExtendedCost',
        'extended_price' => 'setExtendedPrice',
        'sales_tax' => 'setSalesTax',
        'tax_group_id' => 'setTaxGroupId',
        'tax_group_name' => 'setTaxGroupName',
        'tax_percentage' => 'setTaxPercentage',
        'discount_reason_code_id' => 'setDiscountReasonCodeId',
        'discount_reason_code' => 'setDiscountReasonCode',
        'discount_reason_description' => 'setDiscountReasonDescription',
        'return_reason_code_id' => 'setReturnReasonCodeId',
        'return_reason_code' => 'setReturnReasonCode',
        'tax_change_reason_code_id' => 'setTaxChangeReasonCodeId',
        'tax_change_reason_code' => 'setTaxChangeReasonCode',
        'comment' => 'setComment',
        'serial_number' => 'setSerialNumber',
        'line_benefits' => 'setLineBenefits'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'transaction_id' => 'getTransactionId',
        'item_id' => 'getItemId',
        'item_sku' => 'getItemSku',
        'department_id' => 'getDepartmentId',
        'category_id' => 'getCategoryId',
        'supplier_id' => 'getSupplierId',
        'item_description' => 'getItemDescription',
        'unit_cost' => 'getUnitCost',
        'regular_unit_price' => 'getRegularUnitPrice',
        'actual_unit_price' => 'getActualUnitPrice',
        'profit' => 'getProfit',
        'profit_margin' => 'getProfitMargin',
        'quantity' => 'getQuantity',
        'extended_cost' => 'getExtendedCost',
        'extended_price' => 'getExtendedPrice',
        'sales_tax' => 'getSalesTax',
        'tax_group_id' => 'getTaxGroupId',
        'tax_group_name' => 'getTaxGroupName',
        'tax_percentage' => 'getTaxPercentage',
        'discount_reason_code_id' => 'getDiscountReasonCodeId',
        'discount_reason_code' => 'getDiscountReasonCode',
        'discount_reason_description' => 'getDiscountReasonDescription',
        'return_reason_code_id' => 'getReturnReasonCodeId',
        'return_reason_code' => 'getReturnReasonCode',
        'tax_change_reason_code_id' => 'getTaxChangeReasonCodeId',
        'tax_change_reason_code' => 'getTaxChangeReasonCode',
        'comment' => 'getComment',
        'serial_number' => 'getSerialNumber',
        'line_benefits' => 'getLineBenefits'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('transaction_id', $data ?? [], null);
        $this->setIfExists('item_id', $data ?? [], null);
        $this->setIfExists('item_sku', $data ?? [], null);
        $this->setIfExists('department_id', $data ?? [], null);
        $this->setIfExists('category_id', $data ?? [], null);
        $this->setIfExists('supplier_id', $data ?? [], null);
        $this->setIfExists('item_description', $data ?? [], null);
        $this->setIfExists('unit_cost', $data ?? [], null);
        $this->setIfExists('regular_unit_price', $data ?? [], null);
        $this->setIfExists('actual_unit_price', $data ?? [], null);
        $this->setIfExists('profit', $data ?? [], null);
        $this->setIfExists('profit_margin', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('extended_cost', $data ?? [], null);
        $this->setIfExists('extended_price', $data ?? [], null);
        $this->setIfExists('sales_tax', $data ?? [], null);
        $this->setIfExists('tax_group_id', $data ?? [], null);
        $this->setIfExists('tax_group_name', $data ?? [], null);
        $this->setIfExists('tax_percentage', $data ?? [], null);
        $this->setIfExists('discount_reason_code_id', $data ?? [], null);
        $this->setIfExists('discount_reason_code', $data ?? [], null);
        $this->setIfExists('discount_reason_description', $data ?? [], null);
        $this->setIfExists('return_reason_code_id', $data ?? [], null);
        $this->setIfExists('return_reason_code', $data ?? [], null);
        $this->setIfExists('tax_change_reason_code_id', $data ?? [], null);
        $this->setIfExists('tax_change_reason_code', $data ?? [], null);
        $this->setIfExists('comment', $data ?? [], null);
        $this->setIfExists('serial_number', $data ?? [], null);
        $this->setIfExists('line_benefits', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['extended_price'] === null) {
            $invalidProperties[] = "'extended_price' can't be null";
        }
        if ($this->container['sales_tax'] === null) {
            $invalidProperties[] = "'sales_tax' can't be null";
        }
        if (!is_null($this->container['comment']) && (mb_strlen($this->container['comment']) > 255)) {
            $invalidProperties[] = "invalid value for 'comment', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['comment']) && (mb_strlen($this->container['comment']) < 0)) {
            $invalidProperties[] = "invalid value for 'comment', the character length must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id The transaction line id.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return int|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param int|null $transaction_id The id of the associated transaction.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        if (is_null($transaction_id)) {
            throw new \InvalidArgumentException('non-nullable transaction_id cannot be null');
        }
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets item_id
     *
     * @return int|null
     */
    public function getItemId()
    {
        return $this->container['item_id'];
    }

    /**
     * Sets item_id
     *
     * @param int|null $item_id The item id.
     *
     * @return self
     */
    public function setItemId($item_id)
    {
        if (is_null($item_id)) {
            throw new \InvalidArgumentException('non-nullable item_id cannot be null');
        }
        $this->container['item_id'] = $item_id;

        return $this;
    }

    /**
     * Gets item_sku
     *
     * @return string|null
     */
    public function getItemSku()
    {
        return $this->container['item_sku'];
    }

    /**
     * Sets item_sku
     *
     * @param string|null $item_sku The sku of the item.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setItemSku($item_sku)
    {
        if (is_null($item_sku)) {
            array_push($this->openAPINullablesSetToNull, 'item_sku');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('item_sku', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['item_sku'] = $item_sku;

        return $this;
    }

    /**
     * Gets department_id
     *
     * @return int|null
     */
    public function getDepartmentId()
    {
        return $this->container['department_id'];
    }

    /**
     * Sets department_id
     *
     * @param int|null $department_id The department id of the item.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setDepartmentId($department_id)
    {
        if (is_null($department_id)) {
            throw new \InvalidArgumentException('non-nullable department_id cannot be null');
        }
        $this->container['department_id'] = $department_id;

        return $this;
    }

    /**
     * Gets category_id
     *
     * @return int|null
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param int|null $category_id The category id of the item.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setCategoryId($category_id)
    {
        if (is_null($category_id)) {
            throw new \InvalidArgumentException('non-nullable category_id cannot be null');
        }
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets supplier_id
     *
     * @return int|null
     */
    public function getSupplierId()
    {
        return $this->container['supplier_id'];
    }

    /**
     * Sets supplier_id
     *
     * @param int|null $supplier_id The supplier id of the item.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setSupplierId($supplier_id)
    {
        if (is_null($supplier_id)) {
            array_push($this->openAPINullablesSetToNull, 'supplier_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('supplier_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['supplier_id'] = $supplier_id;

        return $this;
    }

    /**
     * Gets item_description
     *
     * @return string|null
     */
    public function getItemDescription()
    {
        return $this->container['item_description'];
    }

    /**
     * Sets item_description
     *
     * @param string|null $item_description The description of the item.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setItemDescription($item_description)
    {
        if (is_null($item_description)) {
            array_push($this->openAPINullablesSetToNull, 'item_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('item_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['item_description'] = $item_description;

        return $this;
    }

    /**
     * Gets unit_cost
     *
     * @return float|null
     */
    public function getUnitCost()
    {
        return $this->container['unit_cost'];
    }

    /**
     * Sets unit_cost
     *
     * @param float|null $unit_cost The unit cost of the item.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setUnitCost($unit_cost)
    {
        if (is_null($unit_cost)) {
            throw new \InvalidArgumentException('non-nullable unit_cost cannot be null');
        }
        $this->container['unit_cost'] = $unit_cost;

        return $this;
    }

    /**
     * Gets regular_unit_price
     *
     * @return float|null
     */
    public function getRegularUnitPrice()
    {
        return $this->container['regular_unit_price'];
    }

    /**
     * Sets regular_unit_price
     *
     * @param float|null $regular_unit_price The regular unit price of the item.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setRegularUnitPrice($regular_unit_price)
    {
        if (is_null($regular_unit_price)) {
            throw new \InvalidArgumentException('non-nullable regular_unit_price cannot be null');
        }
        $this->container['regular_unit_price'] = $regular_unit_price;

        return $this;
    }

    /**
     * Gets actual_unit_price
     *
     * @return float|null
     */
    public function getActualUnitPrice()
    {
        return $this->container['actual_unit_price'];
    }

    /**
     * Sets actual_unit_price
     *
     * @param float|null $actual_unit_price The actual unit price of the item in this transaction.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setActualUnitPrice($actual_unit_price)
    {
        if (is_null($actual_unit_price)) {
            throw new \InvalidArgumentException('non-nullable actual_unit_price cannot be null');
        }
        $this->container['actual_unit_price'] = $actual_unit_price;

        return $this;
    }

    /**
     * Gets profit
     *
     * @return float|null
     */
    public function getProfit()
    {
        return $this->container['profit'];
    }

    /**
     * Sets profit
     *
     * @param float|null $profit The profit on the item  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setProfit($profit)
    {
        if (is_null($profit)) {
            throw new \InvalidArgumentException('non-nullable profit cannot be null');
        }
        $this->container['profit'] = $profit;

        return $this;
    }

    /**
     * Gets profit_margin
     *
     * @return float|null
     */
    public function getProfitMargin()
    {
        return $this->container['profit_margin'];
    }

    /**
     * Sets profit_margin
     *
     * @param float|null $profit_margin The profit margin on the item  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setProfitMargin($profit_margin)
    {
        if (is_null($profit_margin)) {
            throw new \InvalidArgumentException('non-nullable profit_margin cannot be null');
        }
        $this->container['profit_margin'] = $profit_margin;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param float|null $quantity The quantity of the item sold.
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets extended_cost
     *
     * @return float|null
     */
    public function getExtendedCost()
    {
        return $this->container['extended_cost'];
    }

    /**
     * Sets extended_cost
     *
     * @param float|null $extended_cost The cost for the whole line.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setExtendedCost($extended_cost)
    {
        if (is_null($extended_cost)) {
            throw new \InvalidArgumentException('non-nullable extended_cost cannot be null');
        }
        $this->container['extended_cost'] = $extended_cost;

        return $this;
    }

    /**
     * Gets extended_price
     *
     * @return float
     */
    public function getExtendedPrice()
    {
        return $this->container['extended_price'];
    }

    /**
     * Sets extended_price
     *
     * @param float $extended_price The price for the whole line.
     *
     * @return self
     */
    public function setExtendedPrice($extended_price)
    {
        if (is_null($extended_price)) {
            throw new \InvalidArgumentException('non-nullable extended_price cannot be null');
        }
        $this->container['extended_price'] = $extended_price;

        return $this;
    }

    /**
     * Gets sales_tax
     *
     * @return float
     */
    public function getSalesTax()
    {
        return $this->container['sales_tax'];
    }

    /**
     * Sets sales_tax
     *
     * @param float $sales_tax The sales tax for the whole line.
     *
     * @return self
     */
    public function setSalesTax($sales_tax)
    {
        if (is_null($sales_tax)) {
            throw new \InvalidArgumentException('non-nullable sales_tax cannot be null');
        }
        $this->container['sales_tax'] = $sales_tax;

        return $this;
    }

    /**
     * Gets tax_group_id
     *
     * @return int|null
     */
    public function getTaxGroupId()
    {
        return $this->container['tax_group_id'];
    }

    /**
     * Sets tax_group_id
     *
     * @param int|null $tax_group_id The tax group id for the line  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setTaxGroupId($tax_group_id)
    {
        if (is_null($tax_group_id)) {
            array_push($this->openAPINullablesSetToNull, 'tax_group_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_group_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tax_group_id'] = $tax_group_id;

        return $this;
    }

    /**
     * Gets tax_group_name
     *
     * @return string|null
     */
    public function getTaxGroupName()
    {
        return $this->container['tax_group_name'];
    }

    /**
     * Sets tax_group_name
     *
     * @param string|null $tax_group_name The tax group name for the line  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setTaxGroupName($tax_group_name)
    {
        if (is_null($tax_group_name)) {
            array_push($this->openAPINullablesSetToNull, 'tax_group_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_group_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tax_group_name'] = $tax_group_name;

        return $this;
    }

    /**
     * Gets tax_percentage
     *
     * @return float|null
     */
    public function getTaxPercentage()
    {
        return $this->container['tax_percentage'];
    }

    /**
     * Sets tax_percentage
     *
     * @param float|null $tax_percentage The tax percentage for the line  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setTaxPercentage($tax_percentage)
    {
        if (is_null($tax_percentage)) {
            array_push($this->openAPINullablesSetToNull, 'tax_percentage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_percentage', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tax_percentage'] = $tax_percentage;

        return $this;
    }

    /**
     * Gets discount_reason_code_id
     *
     * @return int|null
     */
    public function getDiscountReasonCodeId()
    {
        return $this->container['discount_reason_code_id'];
    }

    /**
     * Sets discount_reason_code_id
     *
     * @param int|null $discount_reason_code_id The id of the associated discount reason code, if any.
     *
     * @return self
     */
    public function setDiscountReasonCodeId($discount_reason_code_id)
    {
        if (is_null($discount_reason_code_id)) {
            array_push($this->openAPINullablesSetToNull, 'discount_reason_code_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('discount_reason_code_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['discount_reason_code_id'] = $discount_reason_code_id;

        return $this;
    }

    /**
     * Gets discount_reason_code
     *
     * @return string|null
     */
    public function getDiscountReasonCode()
    {
        return $this->container['discount_reason_code'];
    }

    /**
     * Sets discount_reason_code
     *
     * @param string|null $discount_reason_code The associated discount reason code, if any.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setDiscountReasonCode($discount_reason_code)
    {
        if (is_null($discount_reason_code)) {
            array_push($this->openAPINullablesSetToNull, 'discount_reason_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('discount_reason_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['discount_reason_code'] = $discount_reason_code;

        return $this;
    }

    /**
     * Gets discount_reason_description
     *
     * @return string|null
     */
    public function getDiscountReasonDescription()
    {
        return $this->container['discount_reason_description'];
    }

    /**
     * Sets discount_reason_description
     *
     * @param string|null $discount_reason_description The description of the associated reason code.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setDiscountReasonDescription($discount_reason_description)
    {
        if (is_null($discount_reason_description)) {
            array_push($this->openAPINullablesSetToNull, 'discount_reason_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('discount_reason_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['discount_reason_description'] = $discount_reason_description;

        return $this;
    }

    /**
     * Gets return_reason_code_id
     *
     * @return int|null
     */
    public function getReturnReasonCodeId()
    {
        return $this->container['return_reason_code_id'];
    }

    /**
     * Sets return_reason_code_id
     *
     * @param int|null $return_reason_code_id The id of the associated return reason code, if any.
     *
     * @return self
     */
    public function setReturnReasonCodeId($return_reason_code_id)
    {
        if (is_null($return_reason_code_id)) {
            array_push($this->openAPINullablesSetToNull, 'return_reason_code_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('return_reason_code_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['return_reason_code_id'] = $return_reason_code_id;

        return $this;
    }

    /**
     * Gets return_reason_code
     *
     * @return string|null
     */
    public function getReturnReasonCode()
    {
        return $this->container['return_reason_code'];
    }

    /**
     * Sets return_reason_code
     *
     * @param string|null $return_reason_code The associated return reason code, if any.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setReturnReasonCode($return_reason_code)
    {
        if (is_null($return_reason_code)) {
            array_push($this->openAPINullablesSetToNull, 'return_reason_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('return_reason_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['return_reason_code'] = $return_reason_code;

        return $this;
    }

    /**
     * Gets tax_change_reason_code_id
     *
     * @return int|null
     */
    public function getTaxChangeReasonCodeId()
    {
        return $this->container['tax_change_reason_code_id'];
    }

    /**
     * Sets tax_change_reason_code_id
     *
     * @param int|null $tax_change_reason_code_id The id of the associated tax change reason code, if any.
     *
     * @return self
     */
    public function setTaxChangeReasonCodeId($tax_change_reason_code_id)
    {
        if (is_null($tax_change_reason_code_id)) {
            array_push($this->openAPINullablesSetToNull, 'tax_change_reason_code_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_change_reason_code_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tax_change_reason_code_id'] = $tax_change_reason_code_id;

        return $this;
    }

    /**
     * Gets tax_change_reason_code
     *
     * @return string|null
     */
    public function getTaxChangeReasonCode()
    {
        return $this->container['tax_change_reason_code'];
    }

    /**
     * Sets tax_change_reason_code
     *
     * @param string|null $tax_change_reason_code The associated tax change reason code, if any.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setTaxChangeReasonCode($tax_change_reason_code)
    {
        if (is_null($tax_change_reason_code)) {
            array_push($this->openAPINullablesSetToNull, 'tax_change_reason_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_change_reason_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tax_change_reason_code'] = $tax_change_reason_code;

        return $this;
    }

    /**
     * Gets comment
     *
     * @return string|null
     */
    public function getComment()
    {
        return $this->container['comment'];
    }

    /**
     * Sets comment
     *
     * @param string|null $comment Any comment associated with this line.
     *
     * @return self
     */
    public function setComment($comment)
    {
        if (is_null($comment)) {
            array_push($this->openAPINullablesSetToNull, 'comment');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('comment', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($comment) && (mb_strlen($comment) > 255)) {
            throw new \InvalidArgumentException('invalid length for $comment when calling TransactionLine., must be smaller than or equal to 255.');
        }
        if (!is_null($comment) && (mb_strlen($comment) < 0)) {
            throw new \InvalidArgumentException('invalid length for $comment when calling TransactionLine., must be bigger than or equal to 0.');
        }

        $this->container['comment'] = $comment;

        return $this;
    }

    /**
     * Gets serial_number
     *
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->container['serial_number'];
    }

    /**
     * Sets serial_number
     *
     * @param string|null $serial_number Any serial number associated with this line - e.g. the gift card number
     *
     * @return self
     */
    public function setSerialNumber($serial_number)
    {
        if (is_null($serial_number)) {
            array_push($this->openAPINullablesSetToNull, 'serial_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('serial_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['serial_number'] = $serial_number;

        return $this;
    }

    /**
     * Gets line_benefits
     *
     * @return \Opsuite2\Model\TransactionLineBenefit[]|null
     */
    public function getLineBenefits()
    {
        return $this->container['line_benefits'];
    }

    /**
     * Sets line_benefits
     *
     * @param \Opsuite2\Model\TransactionLineBenefit[]|null $line_benefits Any line benefits where promotions have been applied to the transaction.
     *
     * @return self
     */
    public function setLineBenefits($line_benefits)
    {
        if (is_null($line_benefits)) {
            array_push($this->openAPINullablesSetToNull, 'line_benefits');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('line_benefits', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['line_benefits'] = $line_benefits;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


