<?php
/**
 * TransactionHeader
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * TransactionHeader Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class TransactionHeader implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TransactionHeader';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'transaction_id' => 'int',
        'external_transaction_number' => 'int',
        'external_transaction_reference' => 'string',
        'receipt_number' => 'string',
        'barcode_number' => 'string',
        'receipt_date_time' => '\DateTime',
        'customer_id' => 'int',
        'ship_to_contact_id' => 'int',
        'comment' => 'string',
        'cashier_id' => 'int',
        'batch_summary_id' => 'int',
        'tax_total' => 'float',
        'transaction_total' => 'float',
        'recall_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'transaction_id' => 'int32',
        'external_transaction_number' => 'int32',
        'external_transaction_reference' => null,
        'receipt_number' => null,
        'barcode_number' => null,
        'receipt_date_time' => 'date-time',
        'customer_id' => 'int32',
        'ship_to_contact_id' => 'int32',
        'comment' => null,
        'cashier_id' => 'int32',
        'batch_summary_id' => 'int32',
        'tax_total' => 'double',
        'transaction_total' => 'double',
        'recall_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'transaction_id' => false,
        'external_transaction_number' => false,
        'external_transaction_reference' => true,
        'receipt_number' => true,
        'barcode_number' => true,
        'receipt_date_time' => false,
        'customer_id' => true,
        'ship_to_contact_id' => true,
        'comment' => true,
        'cashier_id' => true,
        'batch_summary_id' => false,
        'tax_total' => false,
        'transaction_total' => false,
        'recall_id' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'transaction_id' => 'transactionId',
        'external_transaction_number' => 'externalTransactionNumber',
        'external_transaction_reference' => 'externalTransactionReference',
        'receipt_number' => 'receiptNumber',
        'barcode_number' => 'barcodeNumber',
        'receipt_date_time' => 'receiptDateTime',
        'customer_id' => 'customerId',
        'ship_to_contact_id' => 'shipToContactId',
        'comment' => 'comment',
        'cashier_id' => 'cashierId',
        'batch_summary_id' => 'batchSummaryId',
        'tax_total' => 'taxTotal',
        'transaction_total' => 'transactionTotal',
        'recall_id' => 'recallId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'transaction_id' => 'setTransactionId',
        'external_transaction_number' => 'setExternalTransactionNumber',
        'external_transaction_reference' => 'setExternalTransactionReference',
        'receipt_number' => 'setReceiptNumber',
        'barcode_number' => 'setBarcodeNumber',
        'receipt_date_time' => 'setReceiptDateTime',
        'customer_id' => 'setCustomerId',
        'ship_to_contact_id' => 'setShipToContactId',
        'comment' => 'setComment',
        'cashier_id' => 'setCashierId',
        'batch_summary_id' => 'setBatchSummaryId',
        'tax_total' => 'setTaxTotal',
        'transaction_total' => 'setTransactionTotal',
        'recall_id' => 'setRecallId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'transaction_id' => 'getTransactionId',
        'external_transaction_number' => 'getExternalTransactionNumber',
        'external_transaction_reference' => 'getExternalTransactionReference',
        'receipt_number' => 'getReceiptNumber',
        'barcode_number' => 'getBarcodeNumber',
        'receipt_date_time' => 'getReceiptDateTime',
        'customer_id' => 'getCustomerId',
        'ship_to_contact_id' => 'getShipToContactId',
        'comment' => 'getComment',
        'cashier_id' => 'getCashierId',
        'batch_summary_id' => 'getBatchSummaryId',
        'tax_total' => 'getTaxTotal',
        'transaction_total' => 'getTransactionTotal',
        'recall_id' => 'getRecallId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('transaction_id', $data ?? [], null);
        $this->setIfExists('external_transaction_number', $data ?? [], null);
        $this->setIfExists('external_transaction_reference', $data ?? [], null);
        $this->setIfExists('receipt_number', $data ?? [], null);
        $this->setIfExists('barcode_number', $data ?? [], null);
        $this->setIfExists('receipt_date_time', $data ?? [], null);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('ship_to_contact_id', $data ?? [], null);
        $this->setIfExists('comment', $data ?? [], null);
        $this->setIfExists('cashier_id', $data ?? [], null);
        $this->setIfExists('batch_summary_id', $data ?? [], null);
        $this->setIfExists('tax_total', $data ?? [], null);
        $this->setIfExists('transaction_total', $data ?? [], null);
        $this->setIfExists('recall_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets transaction_id
     *
     * @return int|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param int|null $transaction_id transaction_id
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        if (is_null($transaction_id)) {
            throw new \InvalidArgumentException('non-nullable transaction_id cannot be null');
        }
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets external_transaction_number
     *
     * @return int|null
     */
    public function getExternalTransactionNumber()
    {
        return $this->container['external_transaction_number'];
    }

    /**
     * Sets external_transaction_number
     *
     * @param int|null $external_transaction_number external_transaction_number
     *
     * @return self
     */
    public function setExternalTransactionNumber($external_transaction_number)
    {
        if (is_null($external_transaction_number)) {
            throw new \InvalidArgumentException('non-nullable external_transaction_number cannot be null');
        }
        $this->container['external_transaction_number'] = $external_transaction_number;

        return $this;
    }

    /**
     * Gets external_transaction_reference
     *
     * @return string|null
     */
    public function getExternalTransactionReference()
    {
        return $this->container['external_transaction_reference'];
    }

    /**
     * Sets external_transaction_reference
     *
     * @param string|null $external_transaction_reference external_transaction_reference
     *
     * @return self
     */
    public function setExternalTransactionReference($external_transaction_reference)
    {
        if (is_null($external_transaction_reference)) {
            array_push($this->openAPINullablesSetToNull, 'external_transaction_reference');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('external_transaction_reference', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['external_transaction_reference'] = $external_transaction_reference;

        return $this;
    }

    /**
     * Gets receipt_number
     *
     * @return string|null
     */
    public function getReceiptNumber()
    {
        return $this->container['receipt_number'];
    }

    /**
     * Sets receipt_number
     *
     * @param string|null $receipt_number receipt_number
     *
     * @return self
     */
    public function setReceiptNumber($receipt_number)
    {
        if (is_null($receipt_number)) {
            array_push($this->openAPINullablesSetToNull, 'receipt_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('receipt_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['receipt_number'] = $receipt_number;

        return $this;
    }

    /**
     * Gets barcode_number
     *
     * @return string|null
     */
    public function getBarcodeNumber()
    {
        return $this->container['barcode_number'];
    }

    /**
     * Sets barcode_number
     *
     * @param string|null $barcode_number barcode_number
     *
     * @return self
     */
    public function setBarcodeNumber($barcode_number)
    {
        if (is_null($barcode_number)) {
            array_push($this->openAPINullablesSetToNull, 'barcode_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('barcode_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['barcode_number'] = $barcode_number;

        return $this;
    }

    /**
     * Gets receipt_date_time
     *
     * @return \DateTime|null
     */
    public function getReceiptDateTime()
    {
        return $this->container['receipt_date_time'];
    }

    /**
     * Sets receipt_date_time
     *
     * @param \DateTime|null $receipt_date_time receipt_date_time
     *
     * @return self
     */
    public function setReceiptDateTime($receipt_date_time)
    {
        if (is_null($receipt_date_time)) {
            throw new \InvalidArgumentException('non-nullable receipt_date_time cannot be null');
        }
        $this->container['receipt_date_time'] = $receipt_date_time;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int|null $customer_id customer_id
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            array_push($this->openAPINullablesSetToNull, 'customer_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customer_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets ship_to_contact_id
     *
     * @return int|null
     */
    public function getShipToContactId()
    {
        return $this->container['ship_to_contact_id'];
    }

    /**
     * Sets ship_to_contact_id
     *
     * @param int|null $ship_to_contact_id ship_to_contact_id
     *
     * @return self
     */
    public function setShipToContactId($ship_to_contact_id)
    {
        if (is_null($ship_to_contact_id)) {
            array_push($this->openAPINullablesSetToNull, 'ship_to_contact_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_to_contact_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ship_to_contact_id'] = $ship_to_contact_id;

        return $this;
    }

    /**
     * Gets comment
     *
     * @return string|null
     */
    public function getComment()
    {
        return $this->container['comment'];
    }

    /**
     * Sets comment
     *
     * @param string|null $comment comment
     *
     * @return self
     */
    public function setComment($comment)
    {
        if (is_null($comment)) {
            array_push($this->openAPINullablesSetToNull, 'comment');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('comment', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['comment'] = $comment;

        return $this;
    }

    /**
     * Gets cashier_id
     *
     * @return int|null
     */
    public function getCashierId()
    {
        return $this->container['cashier_id'];
    }

    /**
     * Sets cashier_id
     *
     * @param int|null $cashier_id cashier_id
     *
     * @return self
     */
    public function setCashierId($cashier_id)
    {
        if (is_null($cashier_id)) {
            array_push($this->openAPINullablesSetToNull, 'cashier_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cashier_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cashier_id'] = $cashier_id;

        return $this;
    }

    /**
     * Gets batch_summary_id
     *
     * @return int|null
     */
    public function getBatchSummaryId()
    {
        return $this->container['batch_summary_id'];
    }

    /**
     * Sets batch_summary_id
     *
     * @param int|null $batch_summary_id batch_summary_id
     *
     * @return self
     */
    public function setBatchSummaryId($batch_summary_id)
    {
        if (is_null($batch_summary_id)) {
            throw new \InvalidArgumentException('non-nullable batch_summary_id cannot be null');
        }
        $this->container['batch_summary_id'] = $batch_summary_id;

        return $this;
    }

    /**
     * Gets tax_total
     *
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->container['tax_total'];
    }

    /**
     * Sets tax_total
     *
     * @param float|null $tax_total tax_total
     *
     * @return self
     */
    public function setTaxTotal($tax_total)
    {
        if (is_null($tax_total)) {
            throw new \InvalidArgumentException('non-nullable tax_total cannot be null');
        }
        $this->container['tax_total'] = $tax_total;

        return $this;
    }

    /**
     * Gets transaction_total
     *
     * @return float|null
     */
    public function getTransactionTotal()
    {
        return $this->container['transaction_total'];
    }

    /**
     * Sets transaction_total
     *
     * @param float|null $transaction_total transaction_total
     *
     * @return self
     */
    public function setTransactionTotal($transaction_total)
    {
        if (is_null($transaction_total)) {
            throw new \InvalidArgumentException('non-nullable transaction_total cannot be null');
        }
        $this->container['transaction_total'] = $transaction_total;

        return $this;
    }

    /**
     * Gets recall_id
     *
     * @return int|null
     */
    public function getRecallId()
    {
        return $this->container['recall_id'];
    }

    /**
     * Sets recall_id
     *
     * @param int|null $recall_id recall_id
     *
     * @return self
     */
    public function setRecallId($recall_id)
    {
        if (is_null($recall_id)) {
            array_push($this->openAPINullablesSetToNull, 'recall_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('recall_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['recall_id'] = $recall_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


