<?php
/**
 * TransactionBenefit
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * TransactionBenefit Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class TransactionBenefit implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TransactionBenefit';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sequence_no' => 'int',
        'description' => 'string',
        'saving' => 'float',
        'discount_reason_code_id' => 'int',
        'discount_reason_code' => 'string',
        'discount_reason_description' => 'string',
        'benefit_key' => 'string',
        'benefit_type_id' => 'int',
        'benefit_type_description' => 'string',
        'promotion_id' => 'int',
        'promotion_code' => 'string',
        'promotion_description' => 'string',
        'promotion_last_updated' => '\DateTime',
        'redeemed_bounce_back_coupon_serial_numbers' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sequence_no' => 'int32',
        'description' => null,
        'saving' => 'double',
        'discount_reason_code_id' => 'int32',
        'discount_reason_code' => null,
        'discount_reason_description' => null,
        'benefit_key' => null,
        'benefit_type_id' => 'int32',
        'benefit_type_description' => null,
        'promotion_id' => 'int32',
        'promotion_code' => null,
        'promotion_description' => null,
        'promotion_last_updated' => 'date-time',
        'redeemed_bounce_back_coupon_serial_numbers' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'sequence_no' => false,
        'description' => false,
        'saving' => false,
        'discount_reason_code_id' => true,
        'discount_reason_code' => true,
        'discount_reason_description' => true,
        'benefit_key' => false,
        'benefit_type_id' => false,
        'benefit_type_description' => true,
        'promotion_id' => true,
        'promotion_code' => true,
        'promotion_description' => true,
        'promotion_last_updated' => true,
        'redeemed_bounce_back_coupon_serial_numbers' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sequence_no' => 'sequenceNo',
        'description' => 'description',
        'saving' => 'saving',
        'discount_reason_code_id' => 'discountReasonCodeId',
        'discount_reason_code' => 'discountReasonCode',
        'discount_reason_description' => 'discountReasonDescription',
        'benefit_key' => 'benefitKey',
        'benefit_type_id' => 'benefitTypeId',
        'benefit_type_description' => 'benefitTypeDescription',
        'promotion_id' => 'promotionId',
        'promotion_code' => 'promotionCode',
        'promotion_description' => 'promotionDescription',
        'promotion_last_updated' => 'promotionLastUpdated',
        'redeemed_bounce_back_coupon_serial_numbers' => 'redeemedBounceBackCouponSerialNumbers'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sequence_no' => 'setSequenceNo',
        'description' => 'setDescription',
        'saving' => 'setSaving',
        'discount_reason_code_id' => 'setDiscountReasonCodeId',
        'discount_reason_code' => 'setDiscountReasonCode',
        'discount_reason_description' => 'setDiscountReasonDescription',
        'benefit_key' => 'setBenefitKey',
        'benefit_type_id' => 'setBenefitTypeId',
        'benefit_type_description' => 'setBenefitTypeDescription',
        'promotion_id' => 'setPromotionId',
        'promotion_code' => 'setPromotionCode',
        'promotion_description' => 'setPromotionDescription',
        'promotion_last_updated' => 'setPromotionLastUpdated',
        'redeemed_bounce_back_coupon_serial_numbers' => 'setRedeemedBounceBackCouponSerialNumbers'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sequence_no' => 'getSequenceNo',
        'description' => 'getDescription',
        'saving' => 'getSaving',
        'discount_reason_code_id' => 'getDiscountReasonCodeId',
        'discount_reason_code' => 'getDiscountReasonCode',
        'discount_reason_description' => 'getDiscountReasonDescription',
        'benefit_key' => 'getBenefitKey',
        'benefit_type_id' => 'getBenefitTypeId',
        'benefit_type_description' => 'getBenefitTypeDescription',
        'promotion_id' => 'getPromotionId',
        'promotion_code' => 'getPromotionCode',
        'promotion_description' => 'getPromotionDescription',
        'promotion_last_updated' => 'getPromotionLastUpdated',
        'redeemed_bounce_back_coupon_serial_numbers' => 'getRedeemedBounceBackCouponSerialNumbers'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('sequence_no', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('saving', $data ?? [], null);
        $this->setIfExists('discount_reason_code_id', $data ?? [], null);
        $this->setIfExists('discount_reason_code', $data ?? [], null);
        $this->setIfExists('discount_reason_description', $data ?? [], null);
        $this->setIfExists('benefit_key', $data ?? [], null);
        $this->setIfExists('benefit_type_id', $data ?? [], null);
        $this->setIfExists('benefit_type_description', $data ?? [], null);
        $this->setIfExists('promotion_id', $data ?? [], null);
        $this->setIfExists('promotion_code', $data ?? [], null);
        $this->setIfExists('promotion_description', $data ?? [], null);
        $this->setIfExists('promotion_last_updated', $data ?? [], null);
        $this->setIfExists('redeemed_bounce_back_coupon_serial_numbers', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['sequence_no'] === null) {
            $invalidProperties[] = "'sequence_no' can't be null";
        }
        if ($this->container['description'] === null) {
            $invalidProperties[] = "'description' can't be null";
        }
        if ((mb_strlen($this->container['description']) < 1)) {
            $invalidProperties[] = "invalid value for 'description', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['saving'] === null) {
            $invalidProperties[] = "'saving' can't be null";
        }
        if ($this->container['benefit_key'] === null) {
            $invalidProperties[] = "'benefit_key' can't be null";
        }
        if ((mb_strlen($this->container['benefit_key']) < 1)) {
            $invalidProperties[] = "invalid value for 'benefit_key', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['benefit_type_id'] === null) {
            $invalidProperties[] = "'benefit_type_id' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sequence_no
     *
     * @return int
     */
    public function getSequenceNo()
    {
        return $this->container['sequence_no'];
    }

    /**
     * Sets sequence_no
     *
     * @param int $sequence_no The sequence number of the benfit in how it is applied to the transaction.
     *
     * @return self
     */
    public function setSequenceNo($sequence_no)
    {
        if (is_null($sequence_no)) {
            throw new \InvalidArgumentException('non-nullable sequence_no cannot be null');
        }
        $this->container['sequence_no'] = $sequence_no;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description The description of the benefit, e.g. the name of the applied promotion.
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }

        if ((mb_strlen($description) < 1)) {
            throw new \InvalidArgumentException('invalid length for $description when calling TransactionBenefit., must be bigger than or equal to 1.');
        }

        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets saving
     *
     * @return float
     */
    public function getSaving()
    {
        return $this->container['saving'];
    }

    /**
     * Sets saving
     *
     * @param float $saving The total saving from this benefit.
     *
     * @return self
     */
    public function setSaving($saving)
    {
        if (is_null($saving)) {
            throw new \InvalidArgumentException('non-nullable saving cannot be null');
        }
        $this->container['saving'] = $saving;

        return $this;
    }

    /**
     * Gets discount_reason_code_id
     *
     * @return int|null
     */
    public function getDiscountReasonCodeId()
    {
        return $this->container['discount_reason_code_id'];
    }

    /**
     * Sets discount_reason_code_id
     *
     * @param int|null $discount_reason_code_id The discount reason code id, if applicable.
     *
     * @return self
     */
    public function setDiscountReasonCodeId($discount_reason_code_id)
    {
        if (is_null($discount_reason_code_id)) {
            array_push($this->openAPINullablesSetToNull, 'discount_reason_code_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('discount_reason_code_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['discount_reason_code_id'] = $discount_reason_code_id;

        return $this;
    }

    /**
     * Gets discount_reason_code
     *
     * @return string|null
     */
    public function getDiscountReasonCode()
    {
        return $this->container['discount_reason_code'];
    }

    /**
     * Sets discount_reason_code
     *
     * @param string|null $discount_reason_code The code of the associated reason code.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setDiscountReasonCode($discount_reason_code)
    {
        if (is_null($discount_reason_code)) {
            array_push($this->openAPINullablesSetToNull, 'discount_reason_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('discount_reason_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['discount_reason_code'] = $discount_reason_code;

        return $this;
    }

    /**
     * Gets discount_reason_description
     *
     * @return string|null
     */
    public function getDiscountReasonDescription()
    {
        return $this->container['discount_reason_description'];
    }

    /**
     * Sets discount_reason_description
     *
     * @param string|null $discount_reason_description The description of the associated reason code.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setDiscountReasonDescription($discount_reason_description)
    {
        if (is_null($discount_reason_description)) {
            array_push($this->openAPINullablesSetToNull, 'discount_reason_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('discount_reason_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['discount_reason_description'] = $discount_reason_description;

        return $this;
    }

    /**
     * Gets benefit_key
     *
     * @return string
     */
    public function getBenefitKey()
    {
        return $this->container['benefit_key'];
    }

    /**
     * Sets benefit_key
     *
     * @param string $benefit_key The symbol that adjoins affected lines on the receipt.
     *
     * @return self
     */
    public function setBenefitKey($benefit_key)
    {
        if (is_null($benefit_key)) {
            throw new \InvalidArgumentException('non-nullable benefit_key cannot be null');
        }

        if ((mb_strlen($benefit_key) < 1)) {
            throw new \InvalidArgumentException('invalid length for $benefit_key when calling TransactionBenefit., must be bigger than or equal to 1.');
        }

        $this->container['benefit_key'] = $benefit_key;

        return $this;
    }

    /**
     * Gets benefit_type_id
     *
     * @return int
     */
    public function getBenefitTypeId()
    {
        return $this->container['benefit_type_id'];
    }

    /**
     * Sets benefit_type_id
     *
     * @param int $benefit_type_id The benefit type id.
     *
     * @return self
     */
    public function setBenefitTypeId($benefit_type_id)
    {
        if (is_null($benefit_type_id)) {
            throw new \InvalidArgumentException('non-nullable benefit_type_id cannot be null');
        }
        $this->container['benefit_type_id'] = $benefit_type_id;

        return $this;
    }

    /**
     * Gets benefit_type_description
     *
     * @return string|null
     */
    public function getBenefitTypeDescription()
    {
        return $this->container['benefit_type_description'];
    }

    /**
     * Sets benefit_type_description
     *
     * @param string|null $benefit_type_description The benefit type description.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setBenefitTypeDescription($benefit_type_description)
    {
        if (is_null($benefit_type_description)) {
            array_push($this->openAPINullablesSetToNull, 'benefit_type_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('benefit_type_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['benefit_type_description'] = $benefit_type_description;

        return $this;
    }

    /**
     * Gets promotion_id
     *
     * @return int|null
     */
    public function getPromotionId()
    {
        return $this->container['promotion_id'];
    }

    /**
     * Sets promotion_id
     *
     * @param int|null $promotion_id The id of the promotion, if the benefit is associated with a promotion.
     *
     * @return self
     */
    public function setPromotionId($promotion_id)
    {
        if (is_null($promotion_id)) {
            array_push($this->openAPINullablesSetToNull, 'promotion_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('promotion_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['promotion_id'] = $promotion_id;

        return $this;
    }

    /**
     * Gets promotion_code
     *
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->container['promotion_code'];
    }

    /**
     * Sets promotion_code
     *
     * @param string|null $promotion_code The code of the promotion, if the benefit is associated with a promotion.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setPromotionCode($promotion_code)
    {
        if (is_null($promotion_code)) {
            array_push($this->openAPINullablesSetToNull, 'promotion_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('promotion_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['promotion_code'] = $promotion_code;

        return $this;
    }

    /**
     * Gets promotion_description
     *
     * @return string|null
     */
    public function getPromotionDescription()
    {
        return $this->container['promotion_description'];
    }

    /**
     * Sets promotion_description
     *
     * @param string|null $promotion_description The description of the promotion, if the benefit is associated with a promotion.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setPromotionDescription($promotion_description)
    {
        if (is_null($promotion_description)) {
            array_push($this->openAPINullablesSetToNull, 'promotion_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('promotion_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['promotion_description'] = $promotion_description;

        return $this;
    }

    /**
     * Gets promotion_last_updated
     *
     * @return \DateTime|null
     */
    public function getPromotionLastUpdated()
    {
        return $this->container['promotion_last_updated'];
    }

    /**
     * Sets promotion_last_updated
     *
     * @param \DateTime|null $promotion_last_updated The date that the promotion was last updated, if applicable.
     *
     * @return self
     */
    public function setPromotionLastUpdated($promotion_last_updated)
    {
        if (is_null($promotion_last_updated)) {
            array_push($this->openAPINullablesSetToNull, 'promotion_last_updated');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('promotion_last_updated', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['promotion_last_updated'] = $promotion_last_updated;

        return $this;
    }

    /**
     * Gets redeemed_bounce_back_coupon_serial_numbers
     *
     * @return string[]|null
     */
    public function getRedeemedBounceBackCouponSerialNumbers()
    {
        return $this->container['redeemed_bounce_back_coupon_serial_numbers'];
    }

    /**
     * Sets redeemed_bounce_back_coupon_serial_numbers
     *
     * @param string[]|null $redeemed_bounce_back_coupon_serial_numbers Serial numbers of any bounce back vouchers that have been redeemed  relating to this benefit.
     *
     * @return self
     */
    public function setRedeemedBounceBackCouponSerialNumbers($redeemed_bounce_back_coupon_serial_numbers)
    {
        if (is_null($redeemed_bounce_back_coupon_serial_numbers)) {
            array_push($this->openAPINullablesSetToNull, 'redeemed_bounce_back_coupon_serial_numbers');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('redeemed_bounce_back_coupon_serial_numbers', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['redeemed_bounce_back_coupon_serial_numbers'] = $redeemed_bounce_back_coupon_serial_numbers;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


