<?php
/**
 * Supplier
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * Supplier Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Supplier implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Supplier';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'supplier_code' => 'string',
        'supplier_name' => 'string',
        'account_number' => 'string',
        'main_contact' => 'string',
        'address_line1' => 'string',
        'address_line2' => 'string',
        'address_line3' => 'string',
        'address_line4' => 'string',
        'city' => 'string',
        'territory' => 'string',
        'zip' => 'string',
        'iso_country_code' => 'string',
        'telephone_number' => 'string',
        'fax_number' => 'string',
        'email_address' => 'string',
        'terms' => 'string',
        'iso_currency_code' => 'string',
        'active' => 'bool',
        'accepted_currency' => 'string',
        'minimum_order_value' => 'float',
        'free_delivery_order_value' => 'float',
        'web' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int32',
        'supplier_code' => null,
        'supplier_name' => null,
        'account_number' => null,
        'main_contact' => null,
        'address_line1' => null,
        'address_line2' => null,
        'address_line3' => null,
        'address_line4' => null,
        'city' => null,
        'territory' => null,
        'zip' => null,
        'iso_country_code' => null,
        'telephone_number' => null,
        'fax_number' => null,
        'email_address' => null,
        'terms' => null,
        'iso_currency_code' => null,
        'active' => null,
        'accepted_currency' => null,
        'minimum_order_value' => 'double',
        'free_delivery_order_value' => 'double',
        'web' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'supplier_code' => false,
        'supplier_name' => false,
        'account_number' => true,
        'main_contact' => true,
        'address_line1' => true,
        'address_line2' => true,
        'address_line3' => true,
        'address_line4' => true,
        'city' => true,
        'territory' => true,
        'zip' => true,
        'iso_country_code' => true,
        'telephone_number' => true,
        'fax_number' => true,
        'email_address' => true,
        'terms' => true,
        'iso_currency_code' => true,
        'active' => false,
        'accepted_currency' => true,
        'minimum_order_value' => true,
        'free_delivery_order_value' => true,
        'web' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'supplier_code' => 'supplierCode',
        'supplier_name' => 'supplierName',
        'account_number' => 'accountNumber',
        'main_contact' => 'mainContact',
        'address_line1' => 'addressLine1',
        'address_line2' => 'addressLine2',
        'address_line3' => 'addressLine3',
        'address_line4' => 'addressLine4',
        'city' => 'city',
        'territory' => 'territory',
        'zip' => 'zip',
        'iso_country_code' => 'isoCountryCode',
        'telephone_number' => 'telephoneNumber',
        'fax_number' => 'faxNumber',
        'email_address' => 'emailAddress',
        'terms' => 'terms',
        'iso_currency_code' => 'isoCurrencyCode',
        'active' => 'active',
        'accepted_currency' => 'acceptedCurrency',
        'minimum_order_value' => 'minimumOrderValue',
        'free_delivery_order_value' => 'freeDeliveryOrderValue',
        'web' => 'web'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'supplier_code' => 'setSupplierCode',
        'supplier_name' => 'setSupplierName',
        'account_number' => 'setAccountNumber',
        'main_contact' => 'setMainContact',
        'address_line1' => 'setAddressLine1',
        'address_line2' => 'setAddressLine2',
        'address_line3' => 'setAddressLine3',
        'address_line4' => 'setAddressLine4',
        'city' => 'setCity',
        'territory' => 'setTerritory',
        'zip' => 'setZip',
        'iso_country_code' => 'setIsoCountryCode',
        'telephone_number' => 'setTelephoneNumber',
        'fax_number' => 'setFaxNumber',
        'email_address' => 'setEmailAddress',
        'terms' => 'setTerms',
        'iso_currency_code' => 'setIsoCurrencyCode',
        'active' => 'setActive',
        'accepted_currency' => 'setAcceptedCurrency',
        'minimum_order_value' => 'setMinimumOrderValue',
        'free_delivery_order_value' => 'setFreeDeliveryOrderValue',
        'web' => 'setWeb'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'supplier_code' => 'getSupplierCode',
        'supplier_name' => 'getSupplierName',
        'account_number' => 'getAccountNumber',
        'main_contact' => 'getMainContact',
        'address_line1' => 'getAddressLine1',
        'address_line2' => 'getAddressLine2',
        'address_line3' => 'getAddressLine3',
        'address_line4' => 'getAddressLine4',
        'city' => 'getCity',
        'territory' => 'getTerritory',
        'zip' => 'getZip',
        'iso_country_code' => 'getIsoCountryCode',
        'telephone_number' => 'getTelephoneNumber',
        'fax_number' => 'getFaxNumber',
        'email_address' => 'getEmailAddress',
        'terms' => 'getTerms',
        'iso_currency_code' => 'getIsoCurrencyCode',
        'active' => 'getActive',
        'accepted_currency' => 'getAcceptedCurrency',
        'minimum_order_value' => 'getMinimumOrderValue',
        'free_delivery_order_value' => 'getFreeDeliveryOrderValue',
        'web' => 'getWeb'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('supplier_code', $data ?? [], null);
        $this->setIfExists('supplier_name', $data ?? [], null);
        $this->setIfExists('account_number', $data ?? [], null);
        $this->setIfExists('main_contact', $data ?? [], null);
        $this->setIfExists('address_line1', $data ?? [], null);
        $this->setIfExists('address_line2', $data ?? [], null);
        $this->setIfExists('address_line3', $data ?? [], null);
        $this->setIfExists('address_line4', $data ?? [], null);
        $this->setIfExists('city', $data ?? [], null);
        $this->setIfExists('territory', $data ?? [], null);
        $this->setIfExists('zip', $data ?? [], null);
        $this->setIfExists('iso_country_code', $data ?? [], null);
        $this->setIfExists('telephone_number', $data ?? [], null);
        $this->setIfExists('fax_number', $data ?? [], null);
        $this->setIfExists('email_address', $data ?? [], null);
        $this->setIfExists('terms', $data ?? [], null);
        $this->setIfExists('iso_currency_code', $data ?? [], null);
        $this->setIfExists('active', $data ?? [], null);
        $this->setIfExists('accepted_currency', $data ?? [], null);
        $this->setIfExists('minimum_order_value', $data ?? [], null);
        $this->setIfExists('free_delivery_order_value', $data ?? [], null);
        $this->setIfExists('web', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['supplier_code'] === null) {
            $invalidProperties[] = "'supplier_code' can't be null";
        }
        if ((mb_strlen($this->container['supplier_code']) > 17)) {
            $invalidProperties[] = "invalid value for 'supplier_code', the character length must be smaller than or equal to 17.";
        }

        if ((mb_strlen($this->container['supplier_code']) < 0)) {
            $invalidProperties[] = "invalid value for 'supplier_code', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['supplier_name'] === null) {
            $invalidProperties[] = "'supplier_name' can't be null";
        }
        if ((mb_strlen($this->container['supplier_name']) > 30)) {
            $invalidProperties[] = "invalid value for 'supplier_name', the character length must be smaller than or equal to 30.";
        }

        if ((mb_strlen($this->container['supplier_name']) < 0)) {
            $invalidProperties[] = "invalid value for 'supplier_name', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['account_number']) && (mb_strlen($this->container['account_number']) > 20)) {
            $invalidProperties[] = "invalid value for 'account_number', the character length must be smaller than or equal to 20.";
        }

        if (!is_null($this->container['account_number']) && (mb_strlen($this->container['account_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'account_number', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['main_contact']) && (mb_strlen($this->container['main_contact']) > 101)) {
            $invalidProperties[] = "invalid value for 'main_contact', the character length must be smaller than or equal to 101.";
        }

        if (!is_null($this->container['main_contact']) && (mb_strlen($this->container['main_contact']) < 0)) {
            $invalidProperties[] = "invalid value for 'main_contact', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['address_line1']) && (mb_strlen($this->container['address_line1']) > 50)) {
            $invalidProperties[] = "invalid value for 'address_line1', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['address_line1']) && (mb_strlen($this->container['address_line1']) < 0)) {
            $invalidProperties[] = "invalid value for 'address_line1', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['address_line2']) && (mb_strlen($this->container['address_line2']) > 50)) {
            $invalidProperties[] = "invalid value for 'address_line2', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['address_line2']) && (mb_strlen($this->container['address_line2']) < 0)) {
            $invalidProperties[] = "invalid value for 'address_line2', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['address_line3']) && (mb_strlen($this->container['address_line3']) > 50)) {
            $invalidProperties[] = "invalid value for 'address_line3', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['address_line3']) && (mb_strlen($this->container['address_line3']) < 0)) {
            $invalidProperties[] = "invalid value for 'address_line3', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['address_line4']) && (mb_strlen($this->container['address_line4']) > 50)) {
            $invalidProperties[] = "invalid value for 'address_line4', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['address_line4']) && (mb_strlen($this->container['address_line4']) < 0)) {
            $invalidProperties[] = "invalid value for 'address_line4', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['city']) && (mb_strlen($this->container['city']) > 50)) {
            $invalidProperties[] = "invalid value for 'city', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['city']) && (mb_strlen($this->container['city']) < 0)) {
            $invalidProperties[] = "invalid value for 'city', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['zip']) && (mb_strlen($this->container['zip']) > 50)) {
            $invalidProperties[] = "invalid value for 'zip', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['zip']) && (mb_strlen($this->container['zip']) < 0)) {
            $invalidProperties[] = "invalid value for 'zip', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['iso_country_code']) && (mb_strlen($this->container['iso_country_code']) > 4)) {
            $invalidProperties[] = "invalid value for 'iso_country_code', the character length must be smaller than or equal to 4.";
        }

        if (!is_null($this->container['iso_country_code']) && (mb_strlen($this->container['iso_country_code']) < 0)) {
            $invalidProperties[] = "invalid value for 'iso_country_code', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['telephone_number']) && (mb_strlen($this->container['telephone_number']) > 50)) {
            $invalidProperties[] = "invalid value for 'telephone_number', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['telephone_number']) && (mb_strlen($this->container['telephone_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'telephone_number', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['fax_number']) && (mb_strlen($this->container['fax_number']) > 50)) {
            $invalidProperties[] = "invalid value for 'fax_number', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['fax_number']) && (mb_strlen($this->container['fax_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'fax_number', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['email_address']) && (mb_strlen($this->container['email_address']) > 255)) {
            $invalidProperties[] = "invalid value for 'email_address', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['email_address']) && (mb_strlen($this->container['email_address']) < 0)) {
            $invalidProperties[] = "invalid value for 'email_address', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['terms']) && (mb_strlen($this->container['terms']) > 50)) {
            $invalidProperties[] = "invalid value for 'terms', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['terms']) && (mb_strlen($this->container['terms']) < 0)) {
            $invalidProperties[] = "invalid value for 'terms', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['iso_currency_code']) && (mb_strlen($this->container['iso_currency_code']) > 3)) {
            $invalidProperties[] = "invalid value for 'iso_currency_code', the character length must be smaller than or equal to 3.";
        }

        if (!is_null($this->container['iso_currency_code']) && (mb_strlen($this->container['iso_currency_code']) < 0)) {
            $invalidProperties[] = "invalid value for 'iso_currency_code', the character length must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id Primary key.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets supplier_code
     *
     * @return string
     */
    public function getSupplierCode()
    {
        return $this->container['supplier_code'];
    }

    /**
     * Sets supplier_code
     *
     * @param string $supplier_code Supplier code. Required when submitting a supplier to OpSuite.
     *
     * @return self
     */
    public function setSupplierCode($supplier_code)
    {
        if (is_null($supplier_code)) {
            throw new \InvalidArgumentException('non-nullable supplier_code cannot be null');
        }
        if ((mb_strlen($supplier_code) > 17)) {
            throw new \InvalidArgumentException('invalid length for $supplier_code when calling Supplier., must be smaller than or equal to 17.');
        }
        if ((mb_strlen($supplier_code) < 0)) {
            throw new \InvalidArgumentException('invalid length for $supplier_code when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['supplier_code'] = $supplier_code;

        return $this;
    }

    /**
     * Gets supplier_name
     *
     * @return string
     */
    public function getSupplierName()
    {
        return $this->container['supplier_name'];
    }

    /**
     * Sets supplier_name
     *
     * @param string $supplier_name Supplier name.
     *
     * @return self
     */
    public function setSupplierName($supplier_name)
    {
        if (is_null($supplier_name)) {
            throw new \InvalidArgumentException('non-nullable supplier_name cannot be null');
        }
        if ((mb_strlen($supplier_name) > 30)) {
            throw new \InvalidArgumentException('invalid length for $supplier_name when calling Supplier., must be smaller than or equal to 30.');
        }
        if ((mb_strlen($supplier_name) < 0)) {
            throw new \InvalidArgumentException('invalid length for $supplier_name when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['supplier_name'] = $supplier_name;

        return $this;
    }

    /**
     * Gets account_number
     *
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->container['account_number'];
    }

    /**
     * Sets account_number
     *
     * @param string|null $account_number account_number
     *
     * @return self
     */
    public function setAccountNumber($account_number)
    {
        if (is_null($account_number)) {
            array_push($this->openAPINullablesSetToNull, 'account_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('account_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($account_number) && (mb_strlen($account_number) > 20)) {
            throw new \InvalidArgumentException('invalid length for $account_number when calling Supplier., must be smaller than or equal to 20.');
        }
        if (!is_null($account_number) && (mb_strlen($account_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $account_number when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['account_number'] = $account_number;

        return $this;
    }

    /**
     * Gets main_contact
     *
     * @return string|null
     */
    public function getMainContact()
    {
        return $this->container['main_contact'];
    }

    /**
     * Sets main_contact
     *
     * @param string|null $main_contact main_contact
     *
     * @return self
     */
    public function setMainContact($main_contact)
    {
        if (is_null($main_contact)) {
            array_push($this->openAPINullablesSetToNull, 'main_contact');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('main_contact', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($main_contact) && (mb_strlen($main_contact) > 101)) {
            throw new \InvalidArgumentException('invalid length for $main_contact when calling Supplier., must be smaller than or equal to 101.');
        }
        if (!is_null($main_contact) && (mb_strlen($main_contact) < 0)) {
            throw new \InvalidArgumentException('invalid length for $main_contact when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['main_contact'] = $main_contact;

        return $this;
    }

    /**
     * Gets address_line1
     *
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->container['address_line1'];
    }

    /**
     * Sets address_line1
     *
     * @param string|null $address_line1 Supplier address line 1.
     *
     * @return self
     */
    public function setAddressLine1($address_line1)
    {
        if (is_null($address_line1)) {
            array_push($this->openAPINullablesSetToNull, 'address_line1');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('address_line1', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($address_line1) && (mb_strlen($address_line1) > 50)) {
            throw new \InvalidArgumentException('invalid length for $address_line1 when calling Supplier., must be smaller than or equal to 50.');
        }
        if (!is_null($address_line1) && (mb_strlen($address_line1) < 0)) {
            throw new \InvalidArgumentException('invalid length for $address_line1 when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['address_line1'] = $address_line1;

        return $this;
    }

    /**
     * Gets address_line2
     *
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->container['address_line2'];
    }

    /**
     * Sets address_line2
     *
     * @param string|null $address_line2 Supplier address line 2.
     *
     * @return self
     */
    public function setAddressLine2($address_line2)
    {
        if (is_null($address_line2)) {
            array_push($this->openAPINullablesSetToNull, 'address_line2');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('address_line2', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($address_line2) && (mb_strlen($address_line2) > 50)) {
            throw new \InvalidArgumentException('invalid length for $address_line2 when calling Supplier., must be smaller than or equal to 50.');
        }
        if (!is_null($address_line2) && (mb_strlen($address_line2) < 0)) {
            throw new \InvalidArgumentException('invalid length for $address_line2 when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['address_line2'] = $address_line2;

        return $this;
    }

    /**
     * Gets address_line3
     *
     * @return string|null
     */
    public function getAddressLine3()
    {
        return $this->container['address_line3'];
    }

    /**
     * Sets address_line3
     *
     * @param string|null $address_line3 Supplier address line 3.
     *
     * @return self
     */
    public function setAddressLine3($address_line3)
    {
        if (is_null($address_line3)) {
            array_push($this->openAPINullablesSetToNull, 'address_line3');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('address_line3', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($address_line3) && (mb_strlen($address_line3) > 50)) {
            throw new \InvalidArgumentException('invalid length for $address_line3 when calling Supplier., must be smaller than or equal to 50.');
        }
        if (!is_null($address_line3) && (mb_strlen($address_line3) < 0)) {
            throw new \InvalidArgumentException('invalid length for $address_line3 when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['address_line3'] = $address_line3;

        return $this;
    }

    /**
     * Gets address_line4
     *
     * @return string|null
     */
    public function getAddressLine4()
    {
        return $this->container['address_line4'];
    }

    /**
     * Sets address_line4
     *
     * @param string|null $address_line4 Supplier address line 4.
     *
     * @return self
     */
    public function setAddressLine4($address_line4)
    {
        if (is_null($address_line4)) {
            array_push($this->openAPINullablesSetToNull, 'address_line4');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('address_line4', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($address_line4) && (mb_strlen($address_line4) > 50)) {
            throw new \InvalidArgumentException('invalid length for $address_line4 when calling Supplier., must be smaller than or equal to 50.');
        }
        if (!is_null($address_line4) && (mb_strlen($address_line4) < 0)) {
            throw new \InvalidArgumentException('invalid length for $address_line4 when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['address_line4'] = $address_line4;

        return $this;
    }

    /**
     * Gets city
     *
     * @return string|null
     */
    public function getCity()
    {
        return $this->container['city'];
    }

    /**
     * Sets city
     *
     * @param string|null $city Supplier address city or town.
     *
     * @return self
     */
    public function setCity($city)
    {
        if (is_null($city)) {
            array_push($this->openAPINullablesSetToNull, 'city');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('city', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($city) && (mb_strlen($city) > 50)) {
            throw new \InvalidArgumentException('invalid length for $city when calling Supplier., must be smaller than or equal to 50.');
        }
        if (!is_null($city) && (mb_strlen($city) < 0)) {
            throw new \InvalidArgumentException('invalid length for $city when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets territory
     *
     * @return string|null
     */
    public function getTerritory()
    {
        return $this->container['territory'];
    }

    /**
     * Sets territory
     *
     * @param string|null $territory Supplier address territory or county
     *
     * @return self
     */
    public function setTerritory($territory)
    {
        if (is_null($territory)) {
            array_push($this->openAPINullablesSetToNull, 'territory');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('territory', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['territory'] = $territory;

        return $this;
    }

    /**
     * Gets zip
     *
     * @return string|null
     */
    public function getZip()
    {
        return $this->container['zip'];
    }

    /**
     * Sets zip
     *
     * @param string|null $zip Supplier address postal code (e.g. zip code, postcode, PLZ etc.)
     *
     * @return self
     */
    public function setZip($zip)
    {
        if (is_null($zip)) {
            array_push($this->openAPINullablesSetToNull, 'zip');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('zip', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($zip) && (mb_strlen($zip) > 50)) {
            throw new \InvalidArgumentException('invalid length for $zip when calling Supplier., must be smaller than or equal to 50.');
        }
        if (!is_null($zip) && (mb_strlen($zip) < 0)) {
            throw new \InvalidArgumentException('invalid length for $zip when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['zip'] = $zip;

        return $this;
    }

    /**
     * Gets iso_country_code
     *
     * @return string|null
     */
    public function getIsoCountryCode()
    {
        return $this->container['iso_country_code'];
    }

    /**
     * Sets iso_country_code
     *
     * @param string|null $iso_country_code Supplier address country code.  A 3 character ISO 3166-1 alpha-3 string.  http://http://en.wikipedia.org/wiki/ISO_3166-1_alpha-3
     *
     * @return self
     */
    public function setIsoCountryCode($iso_country_code)
    {
        if (is_null($iso_country_code)) {
            array_push($this->openAPINullablesSetToNull, 'iso_country_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('iso_country_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($iso_country_code) && (mb_strlen($iso_country_code) > 4)) {
            throw new \InvalidArgumentException('invalid length for $iso_country_code when calling Supplier., must be smaller than or equal to 4.');
        }
        if (!is_null($iso_country_code) && (mb_strlen($iso_country_code) < 0)) {
            throw new \InvalidArgumentException('invalid length for $iso_country_code when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['iso_country_code'] = $iso_country_code;

        return $this;
    }

    /**
     * Gets telephone_number
     *
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->container['telephone_number'];
    }

    /**
     * Sets telephone_number
     *
     * @param string|null $telephone_number Supplier phone number.
     *
     * @return self
     */
    public function setTelephoneNumber($telephone_number)
    {
        if (is_null($telephone_number)) {
            array_push($this->openAPINullablesSetToNull, 'telephone_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('telephone_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($telephone_number) && (mb_strlen($telephone_number) > 50)) {
            throw new \InvalidArgumentException('invalid length for $telephone_number when calling Supplier., must be smaller than or equal to 50.');
        }
        if (!is_null($telephone_number) && (mb_strlen($telephone_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $telephone_number when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['telephone_number'] = $telephone_number;

        return $this;
    }

    /**
     * Gets fax_number
     *
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->container['fax_number'];
    }

    /**
     * Sets fax_number
     *
     * @param string|null $fax_number Supplier fax number.
     *
     * @return self
     */
    public function setFaxNumber($fax_number)
    {
        if (is_null($fax_number)) {
            array_push($this->openAPINullablesSetToNull, 'fax_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('fax_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($fax_number) && (mb_strlen($fax_number) > 50)) {
            throw new \InvalidArgumentException('invalid length for $fax_number when calling Supplier., must be smaller than or equal to 50.');
        }
        if (!is_null($fax_number) && (mb_strlen($fax_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $fax_number when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['fax_number'] = $fax_number;

        return $this;
    }

    /**
     * Gets email_address
     *
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->container['email_address'];
    }

    /**
     * Sets email_address
     *
     * @param string|null $email_address Supplier email address.
     *
     * @return self
     */
    public function setEmailAddress($email_address)
    {
        if (is_null($email_address)) {
            array_push($this->openAPINullablesSetToNull, 'email_address');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('email_address', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($email_address) && (mb_strlen($email_address) > 255)) {
            throw new \InvalidArgumentException('invalid length for $email_address when calling Supplier., must be smaller than or equal to 255.');
        }
        if (!is_null($email_address) && (mb_strlen($email_address) < 0)) {
            throw new \InvalidArgumentException('invalid length for $email_address when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['email_address'] = $email_address;

        return $this;
    }

    /**
     * Gets terms
     *
     * @return string|null
     */
    public function getTerms()
    {
        return $this->container['terms'];
    }

    /**
     * Sets terms
     *
     * @param string|null $terms Credit terms.
     *
     * @return self
     */
    public function setTerms($terms)
    {
        if (is_null($terms)) {
            array_push($this->openAPINullablesSetToNull, 'terms');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('terms', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($terms) && (mb_strlen($terms) > 50)) {
            throw new \InvalidArgumentException('invalid length for $terms when calling Supplier., must be smaller than or equal to 50.');
        }
        if (!is_null($terms) && (mb_strlen($terms) < 0)) {
            throw new \InvalidArgumentException('invalid length for $terms when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['terms'] = $terms;

        return $this;
    }

    /**
     * Gets iso_currency_code
     *
     * @return string|null
     */
    public function getIsoCurrencyCode()
    {
        return $this->container['iso_currency_code'];
    }

    /**
     * Sets iso_currency_code
     *
     * @param string|null $iso_currency_code Supplier currency code. A 3 character ISO 3166-1 alpha-3 string.  http://http://en.wikipedia.org/wiki/ISO_3166-1_alpha-3
     *
     * @return self
     */
    public function setIsoCurrencyCode($iso_currency_code)
    {
        if (is_null($iso_currency_code)) {
            array_push($this->openAPINullablesSetToNull, 'iso_currency_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('iso_currency_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($iso_currency_code) && (mb_strlen($iso_currency_code) > 3)) {
            throw new \InvalidArgumentException('invalid length for $iso_currency_code when calling Supplier., must be smaller than or equal to 3.');
        }
        if (!is_null($iso_currency_code) && (mb_strlen($iso_currency_code) < 0)) {
            throw new \InvalidArgumentException('invalid length for $iso_currency_code when calling Supplier., must be bigger than or equal to 0.');
        }

        $this->container['iso_currency_code'] = $iso_currency_code;

        return $this;
    }

    /**
     * Gets active
     *
     * @return bool|null
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param bool|null $active Indicates whether the supplier is active.
     *
     * @return self
     */
    public function setActive($active)
    {
        if (is_null($active)) {
            throw new \InvalidArgumentException('non-nullable active cannot be null');
        }
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets accepted_currency
     *
     * @return string|null
     */
    public function getAcceptedCurrency()
    {
        return $this->container['accepted_currency'];
    }

    /**
     * Sets accepted_currency
     *
     * @param string|null $accepted_currency The currency name
     *
     * @return self
     */
    public function setAcceptedCurrency($accepted_currency)
    {
        if (is_null($accepted_currency)) {
            array_push($this->openAPINullablesSetToNull, 'accepted_currency');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('accepted_currency', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['accepted_currency'] = $accepted_currency;

        return $this;
    }

    /**
     * Gets minimum_order_value
     *
     * @return float|null
     */
    public function getMinimumOrderValue()
    {
        return $this->container['minimum_order_value'];
    }

    /**
     * Sets minimum_order_value
     *
     * @param float|null $minimum_order_value The supplier's minimum order value, null if not set
     *
     * @return self
     */
    public function setMinimumOrderValue($minimum_order_value)
    {
        if (is_null($minimum_order_value)) {
            array_push($this->openAPINullablesSetToNull, 'minimum_order_value');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('minimum_order_value', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['minimum_order_value'] = $minimum_order_value;

        return $this;
    }

    /**
     * Gets free_delivery_order_value
     *
     * @return float|null
     */
    public function getFreeDeliveryOrderValue()
    {
        return $this->container['free_delivery_order_value'];
    }

    /**
     * Sets free_delivery_order_value
     *
     * @param float|null $free_delivery_order_value The supplier's free deliver order value, null if not set
     *
     * @return self
     */
    public function setFreeDeliveryOrderValue($free_delivery_order_value)
    {
        if (is_null($free_delivery_order_value)) {
            array_push($this->openAPINullablesSetToNull, 'free_delivery_order_value');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('free_delivery_order_value', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['free_delivery_order_value'] = $free_delivery_order_value;

        return $this;
    }

    /**
     * Gets web
     *
     * @return string|null
     */
    public function getWeb()
    {
        return $this->container['web'];
    }

    /**
     * Sets web
     *
     * @param string|null $web The supplier's web site
     *
     * @return self
     */
    public function setWeb($web)
    {
        if (is_null($web)) {
            array_push($this->openAPINullablesSetToNull, 'web');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('web', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['web'] = $web;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


