<?php
/**
 * RetailTransaction
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * RetailTransaction Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class RetailTransaction implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'RetailTransaction';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'transaction_id' => 'int',
        'location_id' => 'int',
        'external_batch_number' => 'int',
        'external_transaction_number' => 'int',
        'receipt_number' => 'string',
        'receipt_date_time' => '\DateTime',
        'transaction_comment' => 'string',
        'transaction_reference' => 'string',
        'customer_id' => 'int',
        'customer_account_number' => 'string',
        'cashier_id' => 'int',
        'cashier_number' => 'string',
        'register_id' => 'int',
        'register_number' => 'int',
        'is_tax_inclusive_prices' => 'bool',
        'tax_total' => 'float',
        'transaction_total' => 'float',
        'lines' => '\Opsuite2\Model\TransactionLine[]',
        'tender_lines' => '\Opsuite2\Model\TenderLine[]',
        'transaction_benefits' => '\Opsuite2\Model\TransactionBenefit[]',
        'redeemed_discount_coupon_serial_numbers' => 'string[]',
        'redeemed_promotion_coupon_serial_numbers' => 'string[]',
        'redeemed_bounce_back_coupon_serial_numbers' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'transaction_id' => 'int32',
        'location_id' => 'int32',
        'external_batch_number' => 'int32',
        'external_transaction_number' => 'int32',
        'receipt_number' => null,
        'receipt_date_time' => 'date-time',
        'transaction_comment' => null,
        'transaction_reference' => null,
        'customer_id' => 'int32',
        'customer_account_number' => null,
        'cashier_id' => 'int32',
        'cashier_number' => null,
        'register_id' => 'int32',
        'register_number' => 'int32',
        'is_tax_inclusive_prices' => null,
        'tax_total' => 'double',
        'transaction_total' => 'double',
        'lines' => null,
        'tender_lines' => null,
        'transaction_benefits' => null,
        'redeemed_discount_coupon_serial_numbers' => null,
        'redeemed_promotion_coupon_serial_numbers' => null,
        'redeemed_bounce_back_coupon_serial_numbers' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'transaction_id' => false,
        'location_id' => false,
        'external_batch_number' => false,
        'external_transaction_number' => false,
        'receipt_number' => true,
        'receipt_date_time' => false,
        'transaction_comment' => true,
        'transaction_reference' => true,
        'customer_id' => true,
        'customer_account_number' => true,
        'cashier_id' => false,
        'cashier_number' => true,
        'register_id' => false,
        'register_number' => true,
        'is_tax_inclusive_prices' => false,
        'tax_total' => false,
        'transaction_total' => false,
        'lines' => false,
        'tender_lines' => false,
        'transaction_benefits' => true,
        'redeemed_discount_coupon_serial_numbers' => true,
        'redeemed_promotion_coupon_serial_numbers' => true,
        'redeemed_bounce_back_coupon_serial_numbers' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'transaction_id' => 'transactionId',
        'location_id' => 'locationId',
        'external_batch_number' => 'externalBatchNumber',
        'external_transaction_number' => 'externalTransactionNumber',
        'receipt_number' => 'receiptNumber',
        'receipt_date_time' => 'receiptDateTime',
        'transaction_comment' => 'transactionComment',
        'transaction_reference' => 'transactionReference',
        'customer_id' => 'customerId',
        'customer_account_number' => 'customerAccountNumber',
        'cashier_id' => 'cashierId',
        'cashier_number' => 'cashierNumber',
        'register_id' => 'registerId',
        'register_number' => 'registerNumber',
        'is_tax_inclusive_prices' => 'isTaxInclusivePrices',
        'tax_total' => 'taxTotal',
        'transaction_total' => 'transactionTotal',
        'lines' => 'lines',
        'tender_lines' => 'tenderLines',
        'transaction_benefits' => 'transactionBenefits',
        'redeemed_discount_coupon_serial_numbers' => 'redeemedDiscountCouponSerialNumbers',
        'redeemed_promotion_coupon_serial_numbers' => 'redeemedPromotionCouponSerialNumbers',
        'redeemed_bounce_back_coupon_serial_numbers' => 'redeemedBounceBackCouponSerialNumbers'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'transaction_id' => 'setTransactionId',
        'location_id' => 'setLocationId',
        'external_batch_number' => 'setExternalBatchNumber',
        'external_transaction_number' => 'setExternalTransactionNumber',
        'receipt_number' => 'setReceiptNumber',
        'receipt_date_time' => 'setReceiptDateTime',
        'transaction_comment' => 'setTransactionComment',
        'transaction_reference' => 'setTransactionReference',
        'customer_id' => 'setCustomerId',
        'customer_account_number' => 'setCustomerAccountNumber',
        'cashier_id' => 'setCashierId',
        'cashier_number' => 'setCashierNumber',
        'register_id' => 'setRegisterId',
        'register_number' => 'setRegisterNumber',
        'is_tax_inclusive_prices' => 'setIsTaxInclusivePrices',
        'tax_total' => 'setTaxTotal',
        'transaction_total' => 'setTransactionTotal',
        'lines' => 'setLines',
        'tender_lines' => 'setTenderLines',
        'transaction_benefits' => 'setTransactionBenefits',
        'redeemed_discount_coupon_serial_numbers' => 'setRedeemedDiscountCouponSerialNumbers',
        'redeemed_promotion_coupon_serial_numbers' => 'setRedeemedPromotionCouponSerialNumbers',
        'redeemed_bounce_back_coupon_serial_numbers' => 'setRedeemedBounceBackCouponSerialNumbers'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'transaction_id' => 'getTransactionId',
        'location_id' => 'getLocationId',
        'external_batch_number' => 'getExternalBatchNumber',
        'external_transaction_number' => 'getExternalTransactionNumber',
        'receipt_number' => 'getReceiptNumber',
        'receipt_date_time' => 'getReceiptDateTime',
        'transaction_comment' => 'getTransactionComment',
        'transaction_reference' => 'getTransactionReference',
        'customer_id' => 'getCustomerId',
        'customer_account_number' => 'getCustomerAccountNumber',
        'cashier_id' => 'getCashierId',
        'cashier_number' => 'getCashierNumber',
        'register_id' => 'getRegisterId',
        'register_number' => 'getRegisterNumber',
        'is_tax_inclusive_prices' => 'getIsTaxInclusivePrices',
        'tax_total' => 'getTaxTotal',
        'transaction_total' => 'getTransactionTotal',
        'lines' => 'getLines',
        'tender_lines' => 'getTenderLines',
        'transaction_benefits' => 'getTransactionBenefits',
        'redeemed_discount_coupon_serial_numbers' => 'getRedeemedDiscountCouponSerialNumbers',
        'redeemed_promotion_coupon_serial_numbers' => 'getRedeemedPromotionCouponSerialNumbers',
        'redeemed_bounce_back_coupon_serial_numbers' => 'getRedeemedBounceBackCouponSerialNumbers'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('transaction_id', $data ?? [], null);
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('external_batch_number', $data ?? [], null);
        $this->setIfExists('external_transaction_number', $data ?? [], null);
        $this->setIfExists('receipt_number', $data ?? [], null);
        $this->setIfExists('receipt_date_time', $data ?? [], null);
        $this->setIfExists('transaction_comment', $data ?? [], null);
        $this->setIfExists('transaction_reference', $data ?? [], null);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('customer_account_number', $data ?? [], null);
        $this->setIfExists('cashier_id', $data ?? [], null);
        $this->setIfExists('cashier_number', $data ?? [], null);
        $this->setIfExists('register_id', $data ?? [], null);
        $this->setIfExists('register_number', $data ?? [], null);
        $this->setIfExists('is_tax_inclusive_prices', $data ?? [], null);
        $this->setIfExists('tax_total', $data ?? [], null);
        $this->setIfExists('transaction_total', $data ?? [], null);
        $this->setIfExists('lines', $data ?? [], null);
        $this->setIfExists('tender_lines', $data ?? [], null);
        $this->setIfExists('transaction_benefits', $data ?? [], null);
        $this->setIfExists('redeemed_discount_coupon_serial_numbers', $data ?? [], null);
        $this->setIfExists('redeemed_promotion_coupon_serial_numbers', $data ?? [], null);
        $this->setIfExists('redeemed_bounce_back_coupon_serial_numbers', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['receipt_date_time'] === null) {
            $invalidProperties[] = "'receipt_date_time' can't be null";
        }
        if ($this->container['cashier_id'] === null) {
            $invalidProperties[] = "'cashier_id' can't be null";
        }
        if ($this->container['is_tax_inclusive_prices'] === null) {
            $invalidProperties[] = "'is_tax_inclusive_prices' can't be null";
        }
        if ($this->container['lines'] === null) {
            $invalidProperties[] = "'lines' can't be null";
        }
        if ($this->container['tender_lines'] === null) {
            $invalidProperties[] = "'tender_lines' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets transaction_id
     *
     * @return int|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param int|null $transaction_id The id of the transaction.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        if (is_null($transaction_id)) {
            throw new \InvalidArgumentException('non-nullable transaction_id cannot be null');
        }
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets location_id
     *
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param int|null $location_id The id of the POS location.
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets external_batch_number
     *
     * @return int|null
     */
    public function getExternalBatchNumber()
    {
        return $this->container['external_batch_number'];
    }

    /**
     * Sets external_batch_number
     *
     * @param int|null $external_batch_number The batch number of the client system, if applicable.
     *
     * @return self
     */
    public function setExternalBatchNumber($external_batch_number)
    {
        if (is_null($external_batch_number)) {
            throw new \InvalidArgumentException('non-nullable external_batch_number cannot be null');
        }
        $this->container['external_batch_number'] = $external_batch_number;

        return $this;
    }

    /**
     * Gets external_transaction_number
     *
     * @return int|null
     */
    public function getExternalTransactionNumber()
    {
        return $this->container['external_transaction_number'];
    }

    /**
     * Sets external_transaction_number
     *
     * @param int|null $external_transaction_number The transaction number of the client system, required when creating a new transaction.  This must be unique within the location and register context.
     *
     * @return self
     */
    public function setExternalTransactionNumber($external_transaction_number)
    {
        if (is_null($external_transaction_number)) {
            throw new \InvalidArgumentException('non-nullable external_transaction_number cannot be null');
        }
        $this->container['external_transaction_number'] = $external_transaction_number;

        return $this;
    }

    /**
     * Gets receipt_number
     *
     * @return string|null
     */
    public function getReceiptNumber()
    {
        return $this->container['receipt_number'];
    }

    /**
     * Sets receipt_number
     *
     * @param string|null $receipt_number The receipt number generated when the transaction is created.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setReceiptNumber($receipt_number)
    {
        if (is_null($receipt_number)) {
            array_push($this->openAPINullablesSetToNull, 'receipt_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('receipt_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['receipt_number'] = $receipt_number;

        return $this;
    }

    /**
     * Gets receipt_date_time
     *
     * @return \DateTime
     */
    public function getReceiptDateTime()
    {
        return $this->container['receipt_date_time'];
    }

    /**
     * Sets receipt_date_time
     *
     * @param \DateTime $receipt_date_time The date and time of the transaction.
     *
     * @return self
     */
    public function setReceiptDateTime($receipt_date_time)
    {
        if (is_null($receipt_date_time)) {
            throw new \InvalidArgumentException('non-nullable receipt_date_time cannot be null');
        }
        $this->container['receipt_date_time'] = $receipt_date_time;

        return $this;
    }

    /**
     * Gets transaction_comment
     *
     * @return string|null
     */
    public function getTransactionComment()
    {
        return $this->container['transaction_comment'];
    }

    /**
     * Sets transaction_comment
     *
     * @param string|null $transaction_comment The comment on the transaction
     *
     * @return self
     */
    public function setTransactionComment($transaction_comment)
    {
        if (is_null($transaction_comment)) {
            array_push($this->openAPINullablesSetToNull, 'transaction_comment');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('transaction_comment', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['transaction_comment'] = $transaction_comment;

        return $this;
    }

    /**
     * Gets transaction_reference
     *
     * @return string|null
     */
    public function getTransactionReference()
    {
        return $this->container['transaction_reference'];
    }

    /**
     * Sets transaction_reference
     *
     * @param string|null $transaction_reference The transaction reference
     *
     * @return self
     */
    public function setTransactionReference($transaction_reference)
    {
        if (is_null($transaction_reference)) {
            array_push($this->openAPINullablesSetToNull, 'transaction_reference');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('transaction_reference', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['transaction_reference'] = $transaction_reference;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int|null $customer_id The id of the customer, if an account sale.
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            array_push($this->openAPINullablesSetToNull, 'customer_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customer_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets customer_account_number
     *
     * @return string|null
     */
    public function getCustomerAccountNumber()
    {
        return $this->container['customer_account_number'];
    }

    /**
     * Sets customer_account_number
     *
     * @param string|null $customer_account_number The account number of the customer, if an account sale.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setCustomerAccountNumber($customer_account_number)
    {
        if (is_null($customer_account_number)) {
            array_push($this->openAPINullablesSetToNull, 'customer_account_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customer_account_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customer_account_number'] = $customer_account_number;

        return $this;
    }

    /**
     * Gets cashier_id
     *
     * @return int
     */
    public function getCashierId()
    {
        return $this->container['cashier_id'];
    }

    /**
     * Sets cashier_id
     *
     * @param int $cashier_id The id of the cashier.
     *
     * @return self
     */
    public function setCashierId($cashier_id)
    {
        if (is_null($cashier_id)) {
            throw new \InvalidArgumentException('non-nullable cashier_id cannot be null');
        }
        $this->container['cashier_id'] = $cashier_id;

        return $this;
    }

    /**
     * Gets cashier_number
     *
     * @return string|null
     */
    public function getCashierNumber()
    {
        return $this->container['cashier_number'];
    }

    /**
     * Sets cashier_number
     *
     * @param string|null $cashier_number The number of the cashier.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setCashierNumber($cashier_number)
    {
        if (is_null($cashier_number)) {
            array_push($this->openAPINullablesSetToNull, 'cashier_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cashier_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cashier_number'] = $cashier_number;

        return $this;
    }

    /**
     * Gets register_id
     *
     * @return int|null
     */
    public function getRegisterId()
    {
        return $this->container['register_id'];
    }

    /**
     * Sets register_id
     *
     * @param int|null $register_id The id of the register the sale was made on.
     *
     * @return self
     */
    public function setRegisterId($register_id)
    {
        if (is_null($register_id)) {
            throw new \InvalidArgumentException('non-nullable register_id cannot be null');
        }
        $this->container['register_id'] = $register_id;

        return $this;
    }

    /**
     * Gets register_number
     *
     * @return int|null
     */
    public function getRegisterNumber()
    {
        return $this->container['register_number'];
    }

    /**
     * Sets register_number
     *
     * @param int|null $register_number The Register Number the sale was made on.  Read Only - not required when posting a new transaction.
     *
     * @return self
     */
    public function setRegisterNumber($register_number)
    {
        if (is_null($register_number)) {
            array_push($this->openAPINullablesSetToNull, 'register_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('register_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['register_number'] = $register_number;

        return $this;
    }

    /**
     * Gets is_tax_inclusive_prices
     *
     * @return bool
     */
    public function getIsTaxInclusivePrices()
    {
        return $this->container['is_tax_inclusive_prices'];
    }

    /**
     * Sets is_tax_inclusive_prices
     *
     * @param bool $is_tax_inclusive_prices Whether item prices and transaction totals include the tax element.
     *
     * @return self
     */
    public function setIsTaxInclusivePrices($is_tax_inclusive_prices)
    {
        if (is_null($is_tax_inclusive_prices)) {
            throw new \InvalidArgumentException('non-nullable is_tax_inclusive_prices cannot be null');
        }
        $this->container['is_tax_inclusive_prices'] = $is_tax_inclusive_prices;

        return $this;
    }

    /**
     * Gets tax_total
     *
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->container['tax_total'];
    }

    /**
     * Sets tax_total
     *
     * @param float|null $tax_total Transaction total tax.  Read Only - not required when posting a new transaction as this will be calculated from the lines.
     *
     * @return self
     */
    public function setTaxTotal($tax_total)
    {
        if (is_null($tax_total)) {
            throw new \InvalidArgumentException('non-nullable tax_total cannot be null');
        }
        $this->container['tax_total'] = $tax_total;

        return $this;
    }

    /**
     * Gets transaction_total
     *
     * @return float|null
     */
    public function getTransactionTotal()
    {
        return $this->container['transaction_total'];
    }

    /**
     * Sets transaction_total
     *
     * @param float|null $transaction_total Transaction total.  Read Only - not required when posting a new transaction as this will be calculated from the lines.
     *
     * @return self
     */
    public function setTransactionTotal($transaction_total)
    {
        if (is_null($transaction_total)) {
            throw new \InvalidArgumentException('non-nullable transaction_total cannot be null');
        }
        $this->container['transaction_total'] = $transaction_total;

        return $this;
    }

    /**
     * Gets lines
     *
     * @return \Opsuite2\Model\TransactionLine[]
     */
    public function getLines()
    {
        return $this->container['lines'];
    }

    /**
     * Sets lines
     *
     * @param \Opsuite2\Model\TransactionLine[] $lines The items in the transaction.
     *
     * @return self
     */
    public function setLines($lines)
    {
        if (is_null($lines)) {
            throw new \InvalidArgumentException('non-nullable lines cannot be null');
        }
        $this->container['lines'] = $lines;

        return $this;
    }

    /**
     * Gets tender_lines
     *
     * @return \Opsuite2\Model\TenderLine[]
     */
    public function getTenderLines()
    {
        return $this->container['tender_lines'];
    }

    /**
     * Sets tender_lines
     *
     * @param \Opsuite2\Model\TenderLine[] $tender_lines The tender lines for the transaction.
     *
     * @return self
     */
    public function setTenderLines($tender_lines)
    {
        if (is_null($tender_lines)) {
            throw new \InvalidArgumentException('non-nullable tender_lines cannot be null');
        }
        $this->container['tender_lines'] = $tender_lines;

        return $this;
    }

    /**
     * Gets transaction_benefits
     *
     * @return \Opsuite2\Model\TransactionBenefit[]|null
     */
    public function getTransactionBenefits()
    {
        return $this->container['transaction_benefits'];
    }

    /**
     * Sets transaction_benefits
     *
     * @param \Opsuite2\Model\TransactionBenefit[]|null $transaction_benefits Any transaction benefits where promotions have been applied to the transaction.
     *
     * @return self
     */
    public function setTransactionBenefits($transaction_benefits)
    {
        if (is_null($transaction_benefits)) {
            array_push($this->openAPINullablesSetToNull, 'transaction_benefits');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('transaction_benefits', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['transaction_benefits'] = $transaction_benefits;

        return $this;
    }

    /**
     * Gets redeemed_discount_coupon_serial_numbers
     *
     * @return string[]|null
     */
    public function getRedeemedDiscountCouponSerialNumbers()
    {
        return $this->container['redeemed_discount_coupon_serial_numbers'];
    }

    /**
     * Sets redeemed_discount_coupon_serial_numbers
     *
     * @param string[]|null $redeemed_discount_coupon_serial_numbers Serial numbers of any discount coupons that have been redeemed with this transaction.
     *
     * @return self
     */
    public function setRedeemedDiscountCouponSerialNumbers($redeemed_discount_coupon_serial_numbers)
    {
        if (is_null($redeemed_discount_coupon_serial_numbers)) {
            array_push($this->openAPINullablesSetToNull, 'redeemed_discount_coupon_serial_numbers');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('redeemed_discount_coupon_serial_numbers', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['redeemed_discount_coupon_serial_numbers'] = $redeemed_discount_coupon_serial_numbers;

        return $this;
    }

    /**
     * Gets redeemed_promotion_coupon_serial_numbers
     *
     * @return string[]|null
     */
    public function getRedeemedPromotionCouponSerialNumbers()
    {
        return $this->container['redeemed_promotion_coupon_serial_numbers'];
    }

    /**
     * Sets redeemed_promotion_coupon_serial_numbers
     *
     * @param string[]|null $redeemed_promotion_coupon_serial_numbers Serial numbers of any promotion coupons that have been redeemed with this transaction.
     *
     * @return self
     */
    public function setRedeemedPromotionCouponSerialNumbers($redeemed_promotion_coupon_serial_numbers)
    {
        if (is_null($redeemed_promotion_coupon_serial_numbers)) {
            array_push($this->openAPINullablesSetToNull, 'redeemed_promotion_coupon_serial_numbers');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('redeemed_promotion_coupon_serial_numbers', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['redeemed_promotion_coupon_serial_numbers'] = $redeemed_promotion_coupon_serial_numbers;

        return $this;
    }

    /**
     * Gets redeemed_bounce_back_coupon_serial_numbers
     *
     * @return string[]|null
     */
    public function getRedeemedBounceBackCouponSerialNumbers()
    {
        return $this->container['redeemed_bounce_back_coupon_serial_numbers'];
    }

    /**
     * Sets redeemed_bounce_back_coupon_serial_numbers
     *
     * @param string[]|null $redeemed_bounce_back_coupon_serial_numbers Serial numbers of any bounce back coupons that have been redeemed with this transaction.
     *
     * @return self
     */
    public function setRedeemedBounceBackCouponSerialNumbers($redeemed_bounce_back_coupon_serial_numbers)
    {
        if (is_null($redeemed_bounce_back_coupon_serial_numbers)) {
            array_push($this->openAPINullablesSetToNull, 'redeemed_bounce_back_coupon_serial_numbers');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('redeemed_bounce_back_coupon_serial_numbers', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['redeemed_bounce_back_coupon_serial_numbers'] = $redeemed_bounce_back_coupon_serial_numbers;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


