<?php
/**
 * PurchaseOrder
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * PurchaseOrder Class Doc Comment
 *
 * @category Class
 * @description Describes a purchase order
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PurchaseOrder implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PurchaseOrder';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'confirming_to' => 'string',
        'date_created' => '\DateTime',
        'date_placed' => '\DateTime',
        'date_required' => '\DateTime',
        'cancellation_date' => '\DateTime',
        'delivery_date' => '\DateTime',
        'po_date' => '\DateTime',
        'fob_point' => 'string',
        'freight' => 'string',
        'inventory_control_document_id' => 'int',
        'last_updated_date' => '\DateTime',
        'location_id' => 'int',
        'order_cost' => 'float',
        'order_number' => 'string',
        'order_shipping' => 'float',
        'order_tax' => 'float',
        'order_total' => 'float',
        'placed' => 'bool',
        'remarks' => 'string',
        'requisitioner' => 'string',
        'ship_to_location' => 'string',
        'ship_via' => 'string',
        'status' => 'string',
        'status_id' => 'int',
        'supplier' => '\Opsuite2\Model\Supplier',
        'terms' => 'string',
        'title' => 'string',
        'supplier_id' => 'int',
        'number_of_items' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'confirming_to' => null,
        'date_created' => 'date-time',
        'date_placed' => 'date-time',
        'date_required' => 'date-time',
        'cancellation_date' => 'date-time',
        'delivery_date' => 'date-time',
        'po_date' => 'date-time',
        'fob_point' => null,
        'freight' => null,
        'inventory_control_document_id' => 'int32',
        'last_updated_date' => 'date-time',
        'location_id' => 'int32',
        'order_cost' => 'double',
        'order_number' => null,
        'order_shipping' => 'double',
        'order_tax' => 'double',
        'order_total' => 'double',
        'placed' => null,
        'remarks' => null,
        'requisitioner' => null,
        'ship_to_location' => null,
        'ship_via' => null,
        'status' => null,
        'status_id' => 'int32',
        'supplier' => null,
        'terms' => null,
        'title' => null,
        'supplier_id' => 'int32',
        'number_of_items' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'confirming_to' => true,
        'date_created' => false,
        'date_placed' => true,
        'date_required' => false,
        'cancellation_date' => true,
        'delivery_date' => true,
        'po_date' => true,
        'fob_point' => true,
        'freight' => true,
        'inventory_control_document_id' => false,
        'last_updated_date' => false,
        'location_id' => false,
        'order_cost' => false,
        'order_number' => true,
        'order_shipping' => false,
        'order_tax' => false,
        'order_total' => false,
        'placed' => false,
        'remarks' => true,
        'requisitioner' => true,
        'ship_to_location' => true,
        'ship_via' => true,
        'status' => true,
        'status_id' => false,
        'supplier' => false,
        'terms' => true,
        'title' => true,
        'supplier_id' => true,
        'number_of_items' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'confirming_to' => 'confirmingTo',
        'date_created' => 'dateCreated',
        'date_placed' => 'datePlaced',
        'date_required' => 'dateRequired',
        'cancellation_date' => 'cancellationDate',
        'delivery_date' => 'deliveryDate',
        'po_date' => 'poDate',
        'fob_point' => 'fobPoint',
        'freight' => 'freight',
        'inventory_control_document_id' => 'inventoryControlDocumentId',
        'last_updated_date' => 'lastUpdatedDate',
        'location_id' => 'locationId',
        'order_cost' => 'orderCost',
        'order_number' => 'orderNumber',
        'order_shipping' => 'orderShipping',
        'order_tax' => 'orderTax',
        'order_total' => 'orderTotal',
        'placed' => 'placed',
        'remarks' => 'remarks',
        'requisitioner' => 'requisitioner',
        'ship_to_location' => 'shipToLocation',
        'ship_via' => 'shipVia',
        'status' => 'status',
        'status_id' => 'statusId',
        'supplier' => 'supplier',
        'terms' => 'terms',
        'title' => 'title',
        'supplier_id' => 'supplierId',
        'number_of_items' => 'numberOfItems'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'confirming_to' => 'setConfirmingTo',
        'date_created' => 'setDateCreated',
        'date_placed' => 'setDatePlaced',
        'date_required' => 'setDateRequired',
        'cancellation_date' => 'setCancellationDate',
        'delivery_date' => 'setDeliveryDate',
        'po_date' => 'setPoDate',
        'fob_point' => 'setFobPoint',
        'freight' => 'setFreight',
        'inventory_control_document_id' => 'setInventoryControlDocumentId',
        'last_updated_date' => 'setLastUpdatedDate',
        'location_id' => 'setLocationId',
        'order_cost' => 'setOrderCost',
        'order_number' => 'setOrderNumber',
        'order_shipping' => 'setOrderShipping',
        'order_tax' => 'setOrderTax',
        'order_total' => 'setOrderTotal',
        'placed' => 'setPlaced',
        'remarks' => 'setRemarks',
        'requisitioner' => 'setRequisitioner',
        'ship_to_location' => 'setShipToLocation',
        'ship_via' => 'setShipVia',
        'status' => 'setStatus',
        'status_id' => 'setStatusId',
        'supplier' => 'setSupplier',
        'terms' => 'setTerms',
        'title' => 'setTitle',
        'supplier_id' => 'setSupplierId',
        'number_of_items' => 'setNumberOfItems'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'confirming_to' => 'getConfirmingTo',
        'date_created' => 'getDateCreated',
        'date_placed' => 'getDatePlaced',
        'date_required' => 'getDateRequired',
        'cancellation_date' => 'getCancellationDate',
        'delivery_date' => 'getDeliveryDate',
        'po_date' => 'getPoDate',
        'fob_point' => 'getFobPoint',
        'freight' => 'getFreight',
        'inventory_control_document_id' => 'getInventoryControlDocumentId',
        'last_updated_date' => 'getLastUpdatedDate',
        'location_id' => 'getLocationId',
        'order_cost' => 'getOrderCost',
        'order_number' => 'getOrderNumber',
        'order_shipping' => 'getOrderShipping',
        'order_tax' => 'getOrderTax',
        'order_total' => 'getOrderTotal',
        'placed' => 'getPlaced',
        'remarks' => 'getRemarks',
        'requisitioner' => 'getRequisitioner',
        'ship_to_location' => 'getShipToLocation',
        'ship_via' => 'getShipVia',
        'status' => 'getStatus',
        'status_id' => 'getStatusId',
        'supplier' => 'getSupplier',
        'terms' => 'getTerms',
        'title' => 'getTitle',
        'supplier_id' => 'getSupplierId',
        'number_of_items' => 'getNumberOfItems'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('confirming_to', $data ?? [], null);
        $this->setIfExists('date_created', $data ?? [], null);
        $this->setIfExists('date_placed', $data ?? [], null);
        $this->setIfExists('date_required', $data ?? [], null);
        $this->setIfExists('cancellation_date', $data ?? [], null);
        $this->setIfExists('delivery_date', $data ?? [], null);
        $this->setIfExists('po_date', $data ?? [], null);
        $this->setIfExists('fob_point', $data ?? [], null);
        $this->setIfExists('freight', $data ?? [], null);
        $this->setIfExists('inventory_control_document_id', $data ?? [], null);
        $this->setIfExists('last_updated_date', $data ?? [], null);
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('order_cost', $data ?? [], null);
        $this->setIfExists('order_number', $data ?? [], null);
        $this->setIfExists('order_shipping', $data ?? [], null);
        $this->setIfExists('order_tax', $data ?? [], null);
        $this->setIfExists('order_total', $data ?? [], null);
        $this->setIfExists('placed', $data ?? [], null);
        $this->setIfExists('remarks', $data ?? [], null);
        $this->setIfExists('requisitioner', $data ?? [], null);
        $this->setIfExists('ship_to_location', $data ?? [], null);
        $this->setIfExists('ship_via', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('status_id', $data ?? [], null);
        $this->setIfExists('supplier', $data ?? [], null);
        $this->setIfExists('terms', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('supplier_id', $data ?? [], null);
        $this->setIfExists('number_of_items', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets confirming_to
     *
     * @return string|null
     */
    public function getConfirmingTo()
    {
        return $this->container['confirming_to'];
    }

    /**
     * Sets confirming_to
     *
     * @param string|null $confirming_to confirming_to
     *
     * @return self
     */
    public function setConfirmingTo($confirming_to)
    {
        if (is_null($confirming_to)) {
            array_push($this->openAPINullablesSetToNull, 'confirming_to');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('confirming_to', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['confirming_to'] = $confirming_to;

        return $this;
    }

    /**
     * Gets date_created
     *
     * @return \DateTime|null
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     *
     * @param \DateTime|null $date_created The date the purchase order was created
     *
     * @return self
     */
    public function setDateCreated($date_created)
    {
        if (is_null($date_created)) {
            throw new \InvalidArgumentException('non-nullable date_created cannot be null');
        }
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_placed
     *
     * @return \DateTime|null
     */
    public function getDatePlaced()
    {
        return $this->container['date_placed'];
    }

    /**
     * Sets date_placed
     *
     * @param \DateTime|null $date_placed If placed, the date the purchase order was placed
     *
     * @return self
     */
    public function setDatePlaced($date_placed)
    {
        if (is_null($date_placed)) {
            array_push($this->openAPINullablesSetToNull, 'date_placed');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_placed', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_placed'] = $date_placed;

        return $this;
    }

    /**
     * Gets date_required
     *
     * @return \DateTime|null
     */
    public function getDateRequired()
    {
        return $this->container['date_required'];
    }

    /**
     * Sets date_required
     *
     * @param \DateTime|null $date_required The date the purchase order is required
     *
     * @return self
     */
    public function setDateRequired($date_required)
    {
        if (is_null($date_required)) {
            throw new \InvalidArgumentException('non-nullable date_required cannot be null');
        }
        $this->container['date_required'] = $date_required;

        return $this;
    }

    /**
     * Gets cancellation_date
     *
     * @return \DateTime|null
     */
    public function getCancellationDate()
    {
        return $this->container['cancellation_date'];
    }

    /**
     * Sets cancellation_date
     *
     * @param \DateTime|null $cancellation_date The last date at which the purchase order can be cancelled
     *
     * @return self
     */
    public function setCancellationDate($cancellation_date)
    {
        if (is_null($cancellation_date)) {
            array_push($this->openAPINullablesSetToNull, 'cancellation_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cancellation_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cancellation_date'] = $cancellation_date;

        return $this;
    }

    /**
     * Gets delivery_date
     *
     * @return \DateTime|null
     */
    public function getDeliveryDate()
    {
        return $this->container['delivery_date'];
    }

    /**
     * Sets delivery_date
     *
     * @param \DateTime|null $delivery_date The date the purchase order will be delivered
     *
     * @return self
     */
    public function setDeliveryDate($delivery_date)
    {
        if (is_null($delivery_date)) {
            array_push($this->openAPINullablesSetToNull, 'delivery_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('delivery_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['delivery_date'] = $delivery_date;

        return $this;
    }

    /**
     * Gets po_date
     *
     * @return \DateTime|null
     */
    public function getPoDate()
    {
        return $this->container['po_date'];
    }

    /**
     * Sets po_date
     *
     * @param \DateTime|null $po_date The date the purchase order was created
     *
     * @return self
     */
    public function setPoDate($po_date)
    {
        if (is_null($po_date)) {
            array_push($this->openAPINullablesSetToNull, 'po_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('po_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['po_date'] = $po_date;

        return $this;
    }

    /**
     * Gets fob_point
     *
     * @return string|null
     */
    public function getFobPoint()
    {
        return $this->container['fob_point'];
    }

    /**
     * Sets fob_point
     *
     * @param string|null $fob_point fob_point
     *
     * @return self
     */
    public function setFobPoint($fob_point)
    {
        if (is_null($fob_point)) {
            array_push($this->openAPINullablesSetToNull, 'fob_point');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('fob_point', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['fob_point'] = $fob_point;

        return $this;
    }

    /**
     * Gets freight
     *
     * @return string|null
     */
    public function getFreight()
    {
        return $this->container['freight'];
    }

    /**
     * Sets freight
     *
     * @param string|null $freight freight
     *
     * @return self
     */
    public function setFreight($freight)
    {
        if (is_null($freight)) {
            array_push($this->openAPINullablesSetToNull, 'freight');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('freight', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['freight'] = $freight;

        return $this;
    }

    /**
     * Gets inventory_control_document_id
     *
     * @return int|null
     */
    public function getInventoryControlDocumentId()
    {
        return $this->container['inventory_control_document_id'];
    }

    /**
     * Sets inventory_control_document_id
     *
     * @param int|null $inventory_control_document_id inventory_control_document_id
     *
     * @return self
     */
    public function setInventoryControlDocumentId($inventory_control_document_id)
    {
        if (is_null($inventory_control_document_id)) {
            throw new \InvalidArgumentException('non-nullable inventory_control_document_id cannot be null');
        }
        $this->container['inventory_control_document_id'] = $inventory_control_document_id;

        return $this;
    }

    /**
     * Gets last_updated_date
     *
     * @return \DateTime|null
     */
    public function getLastUpdatedDate()
    {
        return $this->container['last_updated_date'];
    }

    /**
     * Sets last_updated_date
     *
     * @param \DateTime|null $last_updated_date The last updated date
     *
     * @return self
     */
    public function setLastUpdatedDate($last_updated_date)
    {
        if (is_null($last_updated_date)) {
            throw new \InvalidArgumentException('non-nullable last_updated_date cannot be null');
        }
        $this->container['last_updated_date'] = $last_updated_date;

        return $this;
    }

    /**
     * Gets location_id
     *
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param int|null $location_id The location at which the purchase order was created
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets order_cost
     *
     * @return float|null
     */
    public function getOrderCost()
    {
        return $this->container['order_cost'];
    }

    /**
     * Sets order_cost
     *
     * @param float|null $order_cost The supplier cost of of the goods on the order
     *
     * @return self
     */
    public function setOrderCost($order_cost)
    {
        if (is_null($order_cost)) {
            throw new \InvalidArgumentException('non-nullable order_cost cannot be null');
        }
        $this->container['order_cost'] = $order_cost;

        return $this;
    }

    /**
     * Gets order_number
     *
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->container['order_number'];
    }

    /**
     * Sets order_number
     *
     * @param string|null $order_number The order number
     *
     * @return self
     */
    public function setOrderNumber($order_number)
    {
        if (is_null($order_number)) {
            array_push($this->openAPINullablesSetToNull, 'order_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('order_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['order_number'] = $order_number;

        return $this;
    }

    /**
     * Gets order_shipping
     *
     * @return float|null
     */
    public function getOrderShipping()
    {
        return $this->container['order_shipping'];
    }

    /**
     * Sets order_shipping
     *
     * @param float|null $order_shipping The shipping total
     *
     * @return self
     */
    public function setOrderShipping($order_shipping)
    {
        if (is_null($order_shipping)) {
            throw new \InvalidArgumentException('non-nullable order_shipping cannot be null');
        }
        $this->container['order_shipping'] = $order_shipping;

        return $this;
    }

    /**
     * Gets order_tax
     *
     * @return float|null
     */
    public function getOrderTax()
    {
        return $this->container['order_tax'];
    }

    /**
     * Sets order_tax
     *
     * @param float|null $order_tax The amount of tax payable on the order
     *
     * @return self
     */
    public function setOrderTax($order_tax)
    {
        if (is_null($order_tax)) {
            throw new \InvalidArgumentException('non-nullable order_tax cannot be null');
        }
        $this->container['order_tax'] = $order_tax;

        return $this;
    }

    /**
     * Gets order_total
     *
     * @return float|null
     */
    public function getOrderTotal()
    {
        return $this->container['order_total'];
    }

    /**
     * Sets order_total
     *
     * @param float|null $order_total The order total - cost of goods + tax + shipping
     *
     * @return self
     */
    public function setOrderTotal($order_total)
    {
        if (is_null($order_total)) {
            throw new \InvalidArgumentException('non-nullable order_total cannot be null');
        }
        $this->container['order_total'] = $order_total;

        return $this;
    }

    /**
     * Gets placed
     *
     * @return bool|null
     */
    public function getPlaced()
    {
        return $this->container['placed'];
    }

    /**
     * Sets placed
     *
     * @param bool|null $placed Whether the order has been placed or not
     *
     * @return self
     */
    public function setPlaced($placed)
    {
        if (is_null($placed)) {
            throw new \InvalidArgumentException('non-nullable placed cannot be null');
        }
        $this->container['placed'] = $placed;

        return $this;
    }

    /**
     * Gets remarks
     *
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->container['remarks'];
    }

    /**
     * Sets remarks
     *
     * @param string|null $remarks The remarks
     *
     * @return self
     */
    public function setRemarks($remarks)
    {
        if (is_null($remarks)) {
            array_push($this->openAPINullablesSetToNull, 'remarks');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('remarks', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['remarks'] = $remarks;

        return $this;
    }

    /**
     * Gets requisitioner
     *
     * @return string|null
     */
    public function getRequisitioner()
    {
        return $this->container['requisitioner'];
    }

    /**
     * Sets requisitioner
     *
     * @param string|null $requisitioner The requisitioner
     *
     * @return self
     */
    public function setRequisitioner($requisitioner)
    {
        if (is_null($requisitioner)) {
            array_push($this->openAPINullablesSetToNull, 'requisitioner');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('requisitioner', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['requisitioner'] = $requisitioner;

        return $this;
    }

    /**
     * Gets ship_to_location
     *
     * @return string|null
     */
    public function getShipToLocation()
    {
        return $this->container['ship_to_location'];
    }

    /**
     * Sets ship_to_location
     *
     * @param string|null $ship_to_location Where to ship the order
     *
     * @return self
     */
    public function setShipToLocation($ship_to_location)
    {
        if (is_null($ship_to_location)) {
            array_push($this->openAPINullablesSetToNull, 'ship_to_location');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_to_location', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ship_to_location'] = $ship_to_location;

        return $this;
    }

    /**
     * Gets ship_via
     *
     * @return string|null
     */
    public function getShipVia()
    {
        return $this->container['ship_via'];
    }

    /**
     * Sets ship_via
     *
     * @param string|null $ship_via The shipping carrier being used
     *
     * @return self
     */
    public function setShipVia($ship_via)
    {
        if (is_null($ship_via)) {
            array_push($this->openAPINullablesSetToNull, 'ship_via');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_via', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ship_via'] = $ship_via;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status The order status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            array_push($this->openAPINullablesSetToNull, 'status');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('status', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets status_id
     *
     * @return int|null
     */
    public function getStatusId()
    {
        return $this->container['status_id'];
    }

    /**
     * Sets status_id
     *
     * @param int|null $status_id The order status id
     *
     * @return self
     */
    public function setStatusId($status_id)
    {
        if (is_null($status_id)) {
            throw new \InvalidArgumentException('non-nullable status_id cannot be null');
        }
        $this->container['status_id'] = $status_id;

        return $this;
    }

    /**
     * Gets supplier
     *
     * @return \Opsuite2\Model\Supplier|null
     */
    public function getSupplier()
    {
        return $this->container['supplier'];
    }

    /**
     * Sets supplier
     *
     * @param \Opsuite2\Model\Supplier|null $supplier supplier
     *
     * @return self
     */
    public function setSupplier($supplier)
    {
        if (is_null($supplier)) {
            throw new \InvalidArgumentException('non-nullable supplier cannot be null');
        }
        $this->container['supplier'] = $supplier;

        return $this;
    }

    /**
     * Gets terms
     *
     * @return string|null
     */
    public function getTerms()
    {
        return $this->container['terms'];
    }

    /**
     * Sets terms
     *
     * @param string|null $terms The terms of the order
     *
     * @return self
     */
    public function setTerms($terms)
    {
        if (is_null($terms)) {
            array_push($this->openAPINullablesSetToNull, 'terms');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('terms', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['terms'] = $terms;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title The order title
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            array_push($this->openAPINullablesSetToNull, 'title');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('title', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets supplier_id
     *
     * @return int|null
     */
    public function getSupplierId()
    {
        return $this->container['supplier_id'];
    }

    /**
     * Sets supplier_id
     *
     * @param int|null $supplier_id The order's supplier id
     *
     * @return self
     */
    public function setSupplierId($supplier_id)
    {
        if (is_null($supplier_id)) {
            array_push($this->openAPINullablesSetToNull, 'supplier_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('supplier_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['supplier_id'] = $supplier_id;

        return $this;
    }

    /**
     * Gets number_of_items
     *
     * @return int|null
     */
    public function getNumberOfItems()
    {
        return $this->container['number_of_items'];
    }

    /**
     * Sets number_of_items
     *
     * @param int|null $number_of_items The number of items on the order
     *
     * @return self
     */
    public function setNumberOfItems($number_of_items)
    {
        if (is_null($number_of_items)) {
            throw new \InvalidArgumentException('non-nullable number_of_items cannot be null');
        }
        $this->container['number_of_items'] = $number_of_items;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


