<?php
/**
 * PromotionHeader
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * PromotionHeader Class Doc Comment
 *
 * @category Class
 * @description Special Offer header details
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PromotionHeader implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PromotionHeader';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'code' => 'string',
        'description' => 'string',
        'start_date' => '\DateTime',
        'end_date' => '\DateTime',
        'last_updated' => '\DateTime',
        'priority' => 'int',
        'active' => 'bool',
        'promotion_type' => 'string',
        'account_type_scope' => 'int',
        'community_scope' => 'int',
        'scope' => 'string',
        'reason_code_id' => 'int',
        'reason_code' => 'string',
        'header_description' => 'string',
        'qualifier_description' => 'string',
        'reward_description' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int32',
        'code' => null,
        'description' => null,
        'start_date' => 'date-time',
        'end_date' => 'date-time',
        'last_updated' => 'date-time',
        'priority' => 'int32',
        'active' => null,
        'promotion_type' => null,
        'account_type_scope' => 'int32',
        'community_scope' => 'int32',
        'scope' => null,
        'reason_code_id' => 'int32',
        'reason_code' => null,
        'header_description' => null,
        'qualifier_description' => null,
        'reward_description' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'code' => true,
        'description' => true,
        'start_date' => false,
        'end_date' => true,
        'last_updated' => true,
        'priority' => false,
        'active' => false,
        'promotion_type' => true,
        'account_type_scope' => false,
        'community_scope' => false,
        'scope' => true,
        'reason_code_id' => true,
        'reason_code' => true,
        'header_description' => true,
        'qualifier_description' => true,
        'reward_description' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'code' => 'code',
        'description' => 'description',
        'start_date' => 'startDate',
        'end_date' => 'endDate',
        'last_updated' => 'lastUpdated',
        'priority' => 'priority',
        'active' => 'active',
        'promotion_type' => 'promotionType',
        'account_type_scope' => 'accountTypeScope',
        'community_scope' => 'communityScope',
        'scope' => 'scope',
        'reason_code_id' => 'reasonCodeId',
        'reason_code' => 'reasonCode',
        'header_description' => 'headerDescription',
        'qualifier_description' => 'qualifierDescription',
        'reward_description' => 'rewardDescription'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'code' => 'setCode',
        'description' => 'setDescription',
        'start_date' => 'setStartDate',
        'end_date' => 'setEndDate',
        'last_updated' => 'setLastUpdated',
        'priority' => 'setPriority',
        'active' => 'setActive',
        'promotion_type' => 'setPromotionType',
        'account_type_scope' => 'setAccountTypeScope',
        'community_scope' => 'setCommunityScope',
        'scope' => 'setScope',
        'reason_code_id' => 'setReasonCodeId',
        'reason_code' => 'setReasonCode',
        'header_description' => 'setHeaderDescription',
        'qualifier_description' => 'setQualifierDescription',
        'reward_description' => 'setRewardDescription'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'code' => 'getCode',
        'description' => 'getDescription',
        'start_date' => 'getStartDate',
        'end_date' => 'getEndDate',
        'last_updated' => 'getLastUpdated',
        'priority' => 'getPriority',
        'active' => 'getActive',
        'promotion_type' => 'getPromotionType',
        'account_type_scope' => 'getAccountTypeScope',
        'community_scope' => 'getCommunityScope',
        'scope' => 'getScope',
        'reason_code_id' => 'getReasonCodeId',
        'reason_code' => 'getReasonCode',
        'header_description' => 'getHeaderDescription',
        'qualifier_description' => 'getQualifierDescription',
        'reward_description' => 'getRewardDescription'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('start_date', $data ?? [], null);
        $this->setIfExists('end_date', $data ?? [], null);
        $this->setIfExists('last_updated', $data ?? [], null);
        $this->setIfExists('priority', $data ?? [], null);
        $this->setIfExists('active', $data ?? [], null);
        $this->setIfExists('promotion_type', $data ?? [], null);
        $this->setIfExists('account_type_scope', $data ?? [], null);
        $this->setIfExists('community_scope', $data ?? [], null);
        $this->setIfExists('scope', $data ?? [], null);
        $this->setIfExists('reason_code_id', $data ?? [], null);
        $this->setIfExists('reason_code', $data ?? [], null);
        $this->setIfExists('header_description', $data ?? [], null);
        $this->setIfExists('qualifier_description', $data ?? [], null);
        $this->setIfExists('reward_description', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id The special offer id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code The special offer short code
     *
     * @return self
     */
    public function setCode($code)
    {
        if (is_null($code)) {
            array_push($this->openAPINullablesSetToNull, 'code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The special offer reference
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            array_push($this->openAPINullablesSetToNull, 'description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets start_date
     *
     * @return \DateTime|null
     */
    public function getStartDate()
    {
        return $this->container['start_date'];
    }

    /**
     * Sets start_date
     *
     * @param \DateTime|null $start_date The date the special offer started
     *
     * @return self
     */
    public function setStartDate($start_date)
    {
        if (is_null($start_date)) {
            throw new \InvalidArgumentException('non-nullable start_date cannot be null');
        }
        $this->container['start_date'] = $start_date;

        return $this;
    }

    /**
     * Gets end_date
     *
     * @return \DateTime|null
     */
    public function getEndDate()
    {
        return $this->container['end_date'];
    }

    /**
     * Sets end_date
     *
     * @param \DateTime|null $end_date If set, the date the special offer will end
     *
     * @return self
     */
    public function setEndDate($end_date)
    {
        if (is_null($end_date)) {
            array_push($this->openAPINullablesSetToNull, 'end_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('end_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['end_date'] = $end_date;

        return $this;
    }

    /**
     * Gets last_updated
     *
     * @return \DateTime|null
     */
    public function getLastUpdated()
    {
        return $this->container['last_updated'];
    }

    /**
     * Sets last_updated
     *
     * @param \DateTime|null $last_updated The date the special offer was last updated
     *
     * @return self
     */
    public function setLastUpdated($last_updated)
    {
        if (is_null($last_updated)) {
            array_push($this->openAPINullablesSetToNull, 'last_updated');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('last_updated', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['last_updated'] = $last_updated;

        return $this;
    }

    /**
     * Gets priority
     *
     * @return int|null
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority
     *
     * @param int|null $priority The special offer priority
     *
     * @return self
     */
    public function setPriority($priority)
    {
        if (is_null($priority)) {
            throw new \InvalidArgumentException('non-nullable priority cannot be null');
        }
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Gets active
     *
     * @return bool|null
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param bool|null $active Whether the special offer is currently active or not
     *
     * @return self
     */
    public function setActive($active)
    {
        if (is_null($active)) {
            throw new \InvalidArgumentException('non-nullable active cannot be null');
        }
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets promotion_type
     *
     * @return string|null
     */
    public function getPromotionType()
    {
        return $this->container['promotion_type'];
    }

    /**
     * Sets promotion_type
     *
     * @param string|null $promotion_type The promotion type
     *
     * @return self
     */
    public function setPromotionType($promotion_type)
    {
        if (is_null($promotion_type)) {
            array_push($this->openAPINullablesSetToNull, 'promotion_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('promotion_type', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['promotion_type'] = $promotion_type;

        return $this;
    }

    /**
     * Gets account_type_scope
     *
     * @return int|null
     */
    public function getAccountTypeScope()
    {
        return $this->container['account_type_scope'];
    }

    /**
     * Sets account_type_scope
     *
     * @param int|null $account_type_scope The account type scope:      All Sales = 0      All Account Types = 1      Include Specified Account Types = 2      Exclude Specified Account Types = 3      Exclude All Account Types = 4
     *
     * @return self
     */
    public function setAccountTypeScope($account_type_scope)
    {
        if (is_null($account_type_scope)) {
            throw new \InvalidArgumentException('non-nullable account_type_scope cannot be null');
        }
        $this->container['account_type_scope'] = $account_type_scope;

        return $this;
    }

    /**
     * Gets community_scope
     *
     * @return int|null
     */
    public function getCommunityScope()
    {
        return $this->container['community_scope'];
    }

    /**
     * Sets community_scope
     *
     * @param int|null $community_scope The community scope:      All Sales = 0      All Communities = 1      Include Specified Communities = 2      Exclude Specified Communities = 3      Exclude All Communities = 4
     *
     * @return self
     */
    public function setCommunityScope($community_scope)
    {
        if (is_null($community_scope)) {
            throw new \InvalidArgumentException('non-nullable community_scope cannot be null');
        }
        $this->container['community_scope'] = $community_scope;

        return $this;
    }

    /**
     * Gets scope
     *
     * @return string|null
     */
    public function getScope()
    {
        return $this->container['scope'];
    }

    /**
     * Sets scope
     *
     * @param string|null $scope The scope as a string
     *
     * @return self
     */
    public function setScope($scope)
    {
        if (is_null($scope)) {
            array_push($this->openAPINullablesSetToNull, 'scope');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('scope', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['scope'] = $scope;

        return $this;
    }

    /**
     * Gets reason_code_id
     *
     * @return int|null
     */
    public function getReasonCodeId()
    {
        return $this->container['reason_code_id'];
    }

    /**
     * Sets reason_code_id
     *
     * @param int|null $reason_code_id The id of the reason code associated with the special offer
     *
     * @return self
     */
    public function setReasonCodeId($reason_code_id)
    {
        if (is_null($reason_code_id)) {
            array_push($this->openAPINullablesSetToNull, 'reason_code_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('reason_code_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['reason_code_id'] = $reason_code_id;

        return $this;
    }

    /**
     * Gets reason_code
     *
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->container['reason_code'];
    }

    /**
     * Sets reason_code
     *
     * @param string|null $reason_code The description of the reason code associated with the special offer
     *
     * @return self
     */
    public function setReasonCode($reason_code)
    {
        if (is_null($reason_code)) {
            array_push($this->openAPINullablesSetToNull, 'reason_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('reason_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['reason_code'] = $reason_code;

        return $this;
    }

    /**
     * Gets header_description
     *
     * @return string|null
     */
    public function getHeaderDescription()
    {
        return $this->container['header_description'];
    }

    /**
     * Sets header_description
     *
     * @param string|null $header_description A description of this special offer
     *
     * @return self
     */
    public function setHeaderDescription($header_description)
    {
        if (is_null($header_description)) {
            array_push($this->openAPINullablesSetToNull, 'header_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('header_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['header_description'] = $header_description;

        return $this;
    }

    /**
     * Gets qualifier_description
     *
     * @return string|null
     */
    public function getQualifierDescription()
    {
        return $this->container['qualifier_description'];
    }

    /**
     * Sets qualifier_description
     *
     * @param string|null $qualifier_description A description of the qualifier(s) for this special offer
     *
     * @return self
     */
    public function setQualifierDescription($qualifier_description)
    {
        if (is_null($qualifier_description)) {
            array_push($this->openAPINullablesSetToNull, 'qualifier_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('qualifier_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['qualifier_description'] = $qualifier_description;

        return $this;
    }

    /**
     * Gets reward_description
     *
     * @return string|null
     */
    public function getRewardDescription()
    {
        return $this->container['reward_description'];
    }

    /**
     * Sets reward_description
     *
     * @param string|null $reward_description A description of the reward(s) for this special offer
     *
     * @return self
     */
    public function setRewardDescription($reward_description)
    {
        if (is_null($reward_description)) {
            array_push($this->openAPINullablesSetToNull, 'reward_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('reward_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['reward_description'] = $reward_description;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


